/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.util.Collections;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.SnapshotSegmentScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ImmutableSegment
extends Segment {
    public static final long DEEP_OVERHEAD = Segment.DEEP_OVERHEAD + (long)ClassSize.NON_SYNC_TIMERANGE_TRACKER;

    protected abstract boolean canBeFlattened();

    public int getNumUniqueKeys() {
        return this.getCellSet().getNumUniqueKeys();
    }

    protected ImmutableSegment(CellComparator comparator) {
        super(comparator, TimeRangeTracker.create(TimeRangeTracker.Type.NON_SYNC));
    }

    protected ImmutableSegment(CellComparator comparator, List<ImmutableSegment> segments) {
        super(comparator, segments, TimeRangeTracker.create(TimeRangeTracker.Type.NON_SYNC));
    }

    protected ImmutableSegment(CellSet cs, CellComparator comparator, MemStoreLAB memStoreLAB) {
        super(cs, comparator, memStoreLAB, TimeRangeTracker.create(TimeRangeTracker.Type.NON_SYNC));
    }

    protected ImmutableSegment(Segment segment) {
        super(segment);
    }

    public int getNumOfSegments() {
        return 1;
    }

    public List<Segment> getAllSegments() {
        return Collections.singletonList(this);
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = res + "Num uniques " + this.getNumUniqueKeys() + "; ";
        return res;
    }

    List<KeyValueScanner> getSnapshotScanners() {
        return Collections.singletonList(new SnapshotSegmentScanner(this));
    }
}

