/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.core;

import org.apache.hudi.org.apache.htrace.core.SpanId;
import org.apache.hudi.org.apache.htrace.core.TraceScope;
import org.apache.hudi.org.apache.htrace.core.Tracer;

public class TraceRunnable
implements Runnable {
    private final Tracer tracer;
    private final SpanId parentId;
    private final Runnable runnable;
    private final String description;

    @Deprecated
    public TraceRunnable(Tracer tracer, TraceScope parent, Runnable runnable, String description) {
        this(tracer, parent.getSpanId(), runnable, description);
    }

    public TraceRunnable(Tracer tracer, SpanId parentId, Runnable runnable, String description) {
        this.tracer = tracer;
        this.parentId = parentId;
        this.runnable = runnable;
        this.description = description;
    }

    @Override
    public void run() {
        String description = this.description;
        if (description == null) {
            description = Thread.currentThread().getName();
        }
        try (TraceScope chunk = this.tracer.newScope(description, this.parentId);){
            this.runnable.run();
        }
    }

    public Runnable getRunnable() {
        return this.runnable;
    }
}

