/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.util.StreamerUtil;

public class FileIndex {
    private final Path path;
    private final HoodieMetadataConfig metadataConfig;
    private List<String> partitionPaths;
    private final boolean tableExists;

    private FileIndex(Path path, Configuration conf) {
        this.path = path;
        this.metadataConfig = FileIndex.metadataConfig(conf);
        this.tableExists = StreamerUtil.tableExists(path.toString(), HadoopConfigurations.getHadoopConf(conf));
    }

    public static FileIndex instance(Path path, Configuration conf) {
        return new FileIndex(path, conf);
    }

    public List<Map<String, String>> getPartitions(List<String> partitionKeys, String defaultParName, boolean hivePartition) {
        if (partitionKeys.size() == 0) {
            return Collections.emptyList();
        }
        List<String> partitionPaths = this.getOrBuildPartitionPaths();
        if (partitionPaths.size() == 1 && partitionPaths.get(0).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> partitions = new ArrayList<Map<String, String>>();
        for (String partitionPath : partitionPaths) {
            String[] paths = partitionPath.split("/");
            LinkedHashMap<String, String> partitionMapping = new LinkedHashMap<String, String>();
            if (hivePartition) {
                Arrays.stream(paths).forEach(p -> {
                    String[] kv = p.split("=");
                    if (kv.length == 2) {
                        partitionMapping.put(kv[0], defaultParName.equals(kv[1]) ? null : kv[1]);
                    }
                });
            } else {
                for (int i = 0; i < partitionKeys.size(); ++i) {
                    partitionMapping.put(partitionKeys.get(i), defaultParName.equals(paths[i]) ? null : paths[i]);
                }
            }
            partitions.add(partitionMapping);
        }
        return partitions;
    }

    public FileStatus[] getFilesInPartitions() {
        if (!this.tableExists) {
            return new FileStatus[0];
        }
        String[] partitions = (String[])this.getOrBuildPartitionPaths().stream().map(p -> FileIndex.fullPartitionPath(this.path, p)).toArray(String[]::new);
        return (FileStatus[])FSUtils.getFilesInPartitions(HoodieFlinkEngineContext.DEFAULT, this.metadataConfig, this.path.toString(), partitions, "/tmp/").values().stream().flatMap(Arrays::stream).toArray(FileStatus[]::new);
    }

    private static String fullPartitionPath(Path basePath, String partitionPath) {
        if (partitionPath.isEmpty()) {
            return basePath.toString();
        }
        return new Path(basePath, partitionPath).toString();
    }

    @VisibleForTesting
    public void reset() {
        this.partitionPaths = null;
    }

    public void setPartitionPaths(@Nullable Set<String> partitionPaths) {
        if (partitionPaths != null) {
            this.partitionPaths = new ArrayList<String>(partitionPaths);
        }
    }

    public List<String> getOrBuildPartitionPaths() {
        if (this.partitionPaths != null) {
            return this.partitionPaths;
        }
        this.partitionPaths = this.tableExists ? FSUtils.getAllPartitionPaths(HoodieFlinkEngineContext.DEFAULT, this.metadataConfig, this.path.toString()) : Collections.emptyList();
        return this.partitionPaths;
    }

    private static HoodieMetadataConfig metadataConfig(Configuration conf) {
        Properties properties = new Properties();
        properties.put(HoodieMetadataConfig.ENABLE.key(), (Object)conf.getBoolean(FlinkOptions.METADATA_ENABLED));
        return HoodieMetadataConfig.newBuilder().fromProperties(properties).build();
    }
}

