/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.repair;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;

public final class RepairUtils {
    public static Map<String, List<String>> tagInstantsOfBaseAndLogFiles(String basePath, List<Path> allPaths) {
        HashMap<String, List<String>> instantToFilesMap = new HashMap<String, List<String>>();
        allPaths.forEach(path -> {
            String instantTime = FSUtils.getCommitTime(path.getName());
            instantToFilesMap.computeIfAbsent(instantTime, k -> new ArrayList());
            ((List)instantToFilesMap.get(instantTime)).add(FSUtils.getRelativePartitionPath(new Path(basePath), path));
        });
        return instantToFilesMap;
    }

    public static Option<Set<String>> getBaseAndLogFilePathsFromTimeline(HoodieTimeline timeline, HoodieInstant instant) throws IOException {
        if (!instant.isCompleted()) {
            throw new HoodieException("Cannot get base and log file paths from instant not completed: " + instant.getTimestamp());
        }
        switch (instant.getAction()) {
            case "commit": 
            case "deltacommit": {
                HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(timeline.getInstantDetails(instant).get(), HoodieCommitMetadata.class);
                return Option.of(commitMetadata.getPartitionToWriteStats().values().stream().flatMap(Collection::stream).map(HoodieWriteStat::getPath).collect(Collectors.toSet()));
            }
            case "replacecommit": {
                HoodieReplaceCommitMetadata replaceCommitMetadata = HoodieReplaceCommitMetadata.fromBytes(timeline.getInstantDetails(instant).get(), HoodieReplaceCommitMetadata.class);
                return Option.of(replaceCommitMetadata.getPartitionToWriteStats().values().stream().flatMap(Collection::stream).map(HoodieWriteStat::getPath).collect(Collectors.toSet()));
            }
        }
        return Option.empty();
    }

    public static List<String> findInstantFilesToRemove(String instantToRepair, List<String> baseAndLogFilesFromFs, HoodieActiveTimeline activeTimeline, HoodieArchivedTimeline archivedTimeline) {
        if (activeTimeline.filter(instant -> instant.getTimestamp().equals(instantToRepair) && !instant.isCompleted()).getInstants().findAny().isPresent()) {
            return Collections.emptyList();
        }
        try {
            boolean doesInstantExist = false;
            Option<Object> filesFromTimeline = Option.empty();
            Option<HoodieInstant> instantOption = activeTimeline.filterCompletedInstants().filter(instant -> instant.getTimestamp().equals(instantToRepair)).firstInstant();
            if (instantOption.isPresent()) {
                doesInstantExist = true;
                filesFromTimeline = RepairUtils.getBaseAndLogFilePathsFromTimeline(activeTimeline, instantOption.get());
            } else {
                instantOption = archivedTimeline.filterCompletedInstants().filter(instant -> instant.getTimestamp().equals(instantToRepair)).firstInstant();
                if (instantOption.isPresent()) {
                    doesInstantExist = true;
                    filesFromTimeline = RepairUtils.getBaseAndLogFilePathsFromTimeline(archivedTimeline, instantOption.get());
                }
            }
            if (doesInstantExist) {
                if (!filesFromTimeline.isPresent() || ((Set)filesFromTimeline.get()).isEmpty()) {
                    return Collections.emptyList();
                }
                HashSet<String> filesToRemove = new HashSet<String>(baseAndLogFilesFromFs);
                filesToRemove.removeAll((Collection)filesFromTimeline.get());
                return new ArrayList<String>(filesToRemove);
            }
            return baseAndLogFilesFromFs;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static interface SerializablePathFilter
    extends PathFilter,
    Serializable {
    }
}

