/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.storage;

import java.util.HashSet;
import java.util.Set;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieLayoutConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.storage.HoodieStorageLayout;

public class HoodieBucketLayout
extends HoodieStorageLayout {
    public static final Set<WriteOperationType> SUPPORTED_OPERATIONS = new HashSet<WriteOperationType>(){
        {
            this.add(WriteOperationType.INSERT);
            this.add(WriteOperationType.INSERT_PREPPED);
            this.add(WriteOperationType.UPSERT);
            this.add(WriteOperationType.UPSERT_PREPPED);
            this.add(WriteOperationType.INSERT_OVERWRITE);
            this.add(WriteOperationType.DELETE);
            this.add(WriteOperationType.COMPACT);
            this.add(WriteOperationType.DELETE_PARTITION);
        }
    };

    public HoodieBucketLayout(HoodieWriteConfig config) {
        super(config);
    }

    @Override
    public boolean determinesNumFileGroups() {
        return true;
    }

    @Override
    public Option<String> layoutPartitionerClass() {
        return this.config.contains(HoodieLayoutConfig.LAYOUT_PARTITIONER_CLASS_NAME) ? Option.of(this.config.getString(HoodieLayoutConfig.LAYOUT_PARTITIONER_CLASS_NAME.key())) : Option.empty();
    }

    @Override
    public boolean doesNotSupport(WriteOperationType operationType) {
        return !SUPPORTED_OPERATIONS.contains((Object)operationType);
    }
}

