/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.util.StreamerUtil;

public class FlinkTables {
    private FlinkTables() {
    }

    public static HoodieFlinkTable<?> createTable(org.apache.flink.configuration.Configuration conf, RuntimeContext runtimeContext) {
        HoodieFlinkEngineContext context = new HoodieFlinkEngineContext(new SerializableConfiguration(HadoopConfigurations.getHadoopConf(conf)), new FlinkTaskContextSupplier(runtimeContext));
        HoodieWriteConfig writeConfig = StreamerUtil.getHoodieClientConfig(conf, true);
        return HoodieFlinkTable.create(writeConfig, context);
    }

    public static HoodieFlinkTable<?> createTable(HoodieWriteConfig writeConfig, Configuration hadoopConf, RuntimeContext runtimeContext) {
        HoodieFlinkEngineContext context = new HoodieFlinkEngineContext(new SerializableConfiguration(hadoopConf), new FlinkTaskContextSupplier(runtimeContext));
        return HoodieFlinkTable.create(writeConfig, context);
    }

    public static HoodieFlinkTable<?> createTable(org.apache.flink.configuration.Configuration conf) {
        HoodieWriteConfig writeConfig = StreamerUtil.getHoodieClientConfig(conf, true, false);
        return HoodieFlinkTable.create(writeConfig, HoodieFlinkEngineContext.DEFAULT);
    }
}

