/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import com.beust.jcommander.JCommander;
import com.uber.hoodie.hadoop.HoodieInputFormat;
import com.uber.hoodie.hadoop.realtime.HoodieRealtimeInputFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.InvalidTableException;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HoodieHiveSyncClient;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.SchemaDifference;
import org.apache.hudi.hive.util.HiveSchemaUtil;
import org.apache.hudi.sync.common.HoodieSyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.apache.hudi.sync.common.model.PartitionEvent;
import org.apache.hudi.sync.common.util.ConfigUtils;
import org.apache.hudi.sync.common.util.SparkDataSourceTableUtils;
import org.apache.hudi.sync.common.util.TableUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;

public class HiveSyncTool
extends HoodieSyncTool
implements AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(HiveSyncTool.class);
    public static final String SUFFIX_SNAPSHOT_TABLE = "_rt";
    public static final String SUFFIX_READ_OPTIMIZED_TABLE = "_ro";
    protected final HiveSyncConfig config;
    protected final String databaseName;
    protected final String tableName;
    protected HoodieSyncClient syncClient;
    protected String snapshotTableName;
    protected Option<String> roTableName;

    public HiveSyncTool(Properties props, Configuration hadoopConf) {
        super(props, hadoopConf);
        HiveSyncConfig config;
        this.config = config = new HiveSyncConfig(props, hadoopConf);
        this.databaseName = config.getStringOrDefault(HoodieSyncConfig.META_SYNC_DATABASE_NAME);
        this.tableName = config.getStringOrDefault(HoodieSyncConfig.META_SYNC_TABLE_NAME);
        this.initSyncClient(config);
        this.initTableNameVars(config);
    }

    protected void initSyncClient(HiveSyncConfig config) {
        try {
            this.syncClient = new HoodieHiveSyncClient(config);
        }
        catch (RuntimeException e) {
            if (config.getBoolean(HiveSyncConfigHolder.HIVE_IGNORE_EXCEPTIONS).booleanValue()) {
                LOG.error((Object)"Got runtime exception when hive syncing, but continuing as ignoreExceptions config is set ", (Throwable)e);
            }
            throw new HoodieHiveSyncException("Got runtime exception when hive syncing", e);
        }
    }

    private void initTableNameVars(HiveSyncConfig config) {
        String tableName = config.getStringOrDefault(HoodieSyncConfig.META_SYNC_TABLE_NAME);
        if (this.syncClient != null) {
            switch (this.syncClient.getTableType()) {
                case COPY_ON_WRITE: {
                    this.snapshotTableName = tableName;
                    this.roTableName = Option.empty();
                    break;
                }
                case MERGE_ON_READ: {
                    this.snapshotTableName = tableName + SUFFIX_SNAPSHOT_TABLE;
                    this.roTableName = config.getBoolean(HiveSyncConfigHolder.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE) != false ? Option.of((Object)tableName) : Option.of((Object)(tableName + SUFFIX_READ_OPTIMIZED_TABLE));
                    break;
                }
                default: {
                    LOG.error((Object)("Unknown table type " + this.syncClient.getTableType()));
                    throw new InvalidTableException(this.syncClient.getBasePath());
                }
            }
        }
    }

    public void syncHoodieTable() {
        try {
            if (this.syncClient != null) {
                LOG.info((Object)("Syncing target hoodie table with hive table(" + TableUtils.tableId((String)this.databaseName, (String)this.tableName) + "). Hive metastore URL :" + this.config.getString(HiveSyncConfigHolder.METASTORE_URIS) + ", basePath :" + this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH)));
                this.doSync();
            }
        }
        catch (RuntimeException re) {
            throw new HoodieException("Got runtime exception when hive syncing " + this.tableName, (Throwable)re);
        }
        finally {
            this.close();
        }
    }

    protected void doSync() {
        switch (this.syncClient.getTableType()) {
            case COPY_ON_WRITE: {
                this.syncHoodieTable(this.snapshotTableName, false, false);
                break;
            }
            case MERGE_ON_READ: {
                this.syncHoodieTable((String)this.roTableName.get(), false, true);
                this.syncHoodieTable(this.snapshotTableName, true, false);
                break;
            }
            default: {
                LOG.error((Object)("Unknown table type " + this.syncClient.getTableType()));
                throw new InvalidTableException(this.syncClient.getBasePath());
            }
        }
    }

    @Override
    public void close() {
        if (this.syncClient != null) {
            try {
                this.syncClient.close();
            }
            catch (Exception e) {
                throw new HoodieHiveSyncException("Fail to close sync client.", e);
            }
        }
    }

    protected void syncHoodieTable(String tableName, boolean useRealtimeInputFormat, boolean readAsOptimized) {
        boolean meetSyncConditions;
        LOG.info((Object)("Trying to sync hoodie table " + tableName + " with base path " + this.syncClient.getBasePath() + " of type " + this.syncClient.getTableType()));
        if (this.config.getBoolean(HiveSyncConfigHolder.HIVE_AUTO_CREATE_DATABASE).booleanValue()) {
            try {
                if (!this.syncClient.databaseExists(this.databaseName)) {
                    this.syncClient.createDatabase(this.databaseName);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to create database", (Throwable)e);
            }
        } else if (!this.syncClient.databaseExists(this.databaseName)) {
            LOG.error((Object)("Hive database does not exist " + this.databaseName));
            throw new HoodieHiveSyncException("hive database does not exist " + this.databaseName);
        }
        boolean tableExists = this.syncClient.tableExists(tableName);
        MessageType schema = this.syncClient.getStorageSchema();
        if (this.syncClient.isBootstrap() && this.syncClient.getTableType() == HoodieTableType.MERGE_ON_READ && !readAsOptimized) {
            this.config.setValue(HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE, "false");
        }
        boolean schemaChanged = this.syncSchema(tableName, tableExists, useRealtimeInputFormat, readAsOptimized, schema);
        LOG.info((Object)("Schema sync complete. Syncing partitions for " + tableName));
        Option lastCommitTimeSynced = Option.empty();
        if (tableExists) {
            lastCommitTimeSynced = this.syncClient.getLastCommitTimeSynced(tableName);
        }
        LOG.info((Object)("Last commit time synced was found to be " + (String)lastCommitTimeSynced.orElse((Object)"null")));
        List writtenPartitionsSince = this.syncClient.getWrittenPartitionsSince(lastCommitTimeSynced);
        LOG.info((Object)("Storage partitions scan complete. Found " + writtenPartitionsSince.size()));
        Set droppedPartitions = this.syncClient.getDroppedPartitionsSince(lastCommitTimeSynced);
        boolean partitionsChanged = this.syncPartitions(tableName, writtenPartitionsSince, droppedPartitions);
        boolean bl = meetSyncConditions = schemaChanged || partitionsChanged;
        if (!this.config.getBoolean(HoodieSyncConfig.META_SYNC_CONDITIONAL_SYNC).booleanValue() || meetSyncConditions) {
            this.syncClient.updateLastCommitTimeSynced(tableName);
        }
        LOG.info((Object)("Sync complete for " + tableName));
    }

    private boolean syncSchema(String tableName, boolean tableExists, boolean useRealTimeInputFormat, boolean readAsOptimized, MessageType schema) {
        Map tableProperties = ConfigUtils.toMap((String)this.config.getString(HiveSyncConfigHolder.HIVE_TABLE_PROPERTIES));
        Map serdeProperties = ConfigUtils.toMap((String)this.config.getString(HiveSyncConfigHolder.HIVE_TABLE_SERDE_PROPERTIES));
        if (this.config.getBoolean(HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE).booleanValue()) {
            Map sparkTableProperties = SparkDataSourceTableUtils.getSparkTableProperties((List)this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS), (String)this.config.getStringOrDefault(HoodieSyncConfig.META_SYNC_SPARK_VERSION), (int)this.config.getIntOrDefault(HiveSyncConfigHolder.HIVE_SYNC_SCHEMA_STRING_LENGTH_THRESHOLD), (MessageType)schema);
            Map sparkSerdeProperties = SparkDataSourceTableUtils.getSparkSerdeProperties((boolean)readAsOptimized, (String)this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH));
            tableProperties.putAll(sparkTableProperties);
            serdeProperties.putAll(sparkSerdeProperties);
        }
        boolean schemaChanged = false;
        if (!tableExists) {
            LOG.info((Object)("Hive table " + tableName + " is not found. Creating it"));
            HoodieFileFormat baseFileFormat = HoodieFileFormat.valueOf((String)this.config.getStringOrDefault(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT).toUpperCase());
            String inputFormatClassName = HoodieInputFormatUtils.getInputFormatClassName((HoodieFileFormat)baseFileFormat, (boolean)useRealTimeInputFormat);
            if (baseFileFormat.equals((Object)HoodieFileFormat.PARQUET) && this.config.getBooleanOrDefault(HiveSyncConfigHolder.HIVE_USE_PRE_APACHE_INPUT_FORMAT)) {
                inputFormatClassName = useRealTimeInputFormat ? HoodieRealtimeInputFormat.class.getName() : HoodieInputFormat.class.getName();
            }
            String outputFormatClassName = HoodieInputFormatUtils.getOutputFormatClassName((HoodieFileFormat)baseFileFormat);
            String serDeFormatClassName = HoodieInputFormatUtils.getSerDeClassName((HoodieFileFormat)baseFileFormat);
            this.syncClient.createTable(tableName, schema, inputFormatClassName, outputFormatClassName, serDeFormatClassName, serdeProperties, tableProperties);
            schemaChanged = true;
        } else {
            Map tableSchema = this.syncClient.getMetastoreSchema(tableName);
            SchemaDifference schemaDiff = HiveSchemaUtil.getSchemaDifference(schema, tableSchema, this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS), this.config.getBooleanOrDefault(HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE));
            if (!schemaDiff.isEmpty()) {
                LOG.info((Object)("Schema difference found for " + tableName));
                this.syncClient.updateTableSchema(tableName, schema);
                if (this.config.getString(HiveSyncConfigHolder.HIVE_TABLE_PROPERTIES) != null || this.config.getBoolean(HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE).booleanValue()) {
                    this.syncClient.updateTableProperties(tableName, tableProperties);
                    this.syncClient.updateSerdeProperties(tableName, serdeProperties);
                    LOG.info((Object)("Sync table properties for " + tableName + ", table properties is: " + tableProperties));
                }
                schemaChanged = true;
            } else {
                LOG.info((Object)("No Schema difference for " + tableName));
            }
        }
        if (this.config.getBoolean(HiveSyncConfigHolder.HIVE_SYNC_COMMENT).booleanValue()) {
            List fromMetastore = this.syncClient.getMetastoreFieldSchemas(tableName);
            List fromStorage = this.syncClient.getStorageFieldSchemas();
            this.syncClient.updateTableComments(tableName, fromMetastore, fromStorage);
        }
        return schemaChanged;
    }

    private boolean syncPartitions(String tableName, List<String> writtenPartitionsSince, Set<String> droppedPartitions) {
        boolean partitionsChanged;
        try {
            List<String> dropPartitions;
            List<String> updatePartitions;
            List hivePartitions = this.syncClient.getAllPartitions(tableName);
            List partitionEvents = this.syncClient.getPartitionEvents(hivePartitions, writtenPartitionsSince, droppedPartitions);
            List<String> newPartitions = this.filterPartitions(partitionEvents, PartitionEvent.PartitionEventType.ADD);
            if (!newPartitions.isEmpty()) {
                LOG.info((Object)("New Partitions " + newPartitions));
                this.syncClient.addPartitionsToTable(tableName, newPartitions);
            }
            if (!(updatePartitions = this.filterPartitions(partitionEvents, PartitionEvent.PartitionEventType.UPDATE)).isEmpty()) {
                LOG.info((Object)("Changed Partitions " + updatePartitions));
                this.syncClient.updatePartitionsToTable(tableName, updatePartitions);
            }
            if (!(dropPartitions = this.filterPartitions(partitionEvents, PartitionEvent.PartitionEventType.DROP)).isEmpty()) {
                LOG.info((Object)("Drop Partitions " + dropPartitions));
                this.syncClient.dropPartitions(tableName, dropPartitions);
            }
            partitionsChanged = !updatePartitions.isEmpty() || !newPartitions.isEmpty() || !dropPartitions.isEmpty();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to sync partitions for table " + tableName, e);
        }
        return partitionsChanged;
    }

    private List<String> filterPartitions(List<PartitionEvent> events, PartitionEvent.PartitionEventType eventType) {
        return events.stream().filter(s -> s.eventType == eventType).map(s -> s.storagePartition).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        HiveSyncConfig.HiveSyncConfigParams params = new HiveSyncConfig.HiveSyncConfigParams();
        JCommander cmd = JCommander.newBuilder().addObject((Object)params).build();
        cmd.parse(args);
        if (params.isHelp()) {
            cmd.usage();
            System.exit(0);
        }
        new HiveSyncTool((Properties)params.toProps(), new Configuration()).syncHoodieTable();
    }
}

