/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.replication;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.replication.GlobalHiveSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@Parameters(commandDescription="A tool to sync the hudi table to hive from different clusters. Similar to HiveSyncTool but syncs it to morethan one hive cluster ( currently a local and remote cluster). The common timestamp that was synced is stored as a new table property This is most useful when we want to ensure that across different hive clusters we want ensure consistent reads. If that is not a requirementthen it is better to run HiveSyncTool separately.Note:   The tool tries to be transactional but does not guarantee it. If the sync fails midway in one cluster it will try to roll back the committed   timestamp from already successful sync on other clusters but that can also fail.  The tool does not roll back any synced partitions but only the timestamp.")
public class HiveSyncGlobalCommitParams {
    private static final Logger LOG = LogManager.getLogger(HiveSyncGlobalCommitParams.class);
    public static String LOCAL_HIVE_SITE_URI = "hivesyncglobal.local_hive_site_uri";
    public static String REMOTE_HIVE_SITE_URI = "hivesyncglobal.remote_hive_site_uri";
    public static String REMOTE_BASE_PATH = "hivesyncglobal.remote_base_path";
    public static String LOCAL_BASE_PATH = "hivesyncglobal.local_base_path";
    public static String REMOTE_HIVE_SERVER_JDBC_URLS = "hivesyncglobal.remote_hs2_jdbc_urls";
    public static String LOCAL_HIVE_SERVER_JDBC_URLS = "hivesyncglobal.local_hs2_jdbc_urls";
    @Parameter(names={"--config-xml-file"}, description="path to the config file in Hive", required=true)
    public String configFile;
    @ParametersDelegate
    public final GlobalHiveSyncConfig.GlobalHiveSyncConfigParams globalHiveSyncConfigParams = new GlobalHiveSyncConfig.GlobalHiveSyncConfigParams();
    public Properties loadedProps = new Properties();
    private boolean finalize = false;

    public boolean isHelp() {
        return this.globalHiveSyncConfigParams.isHelp();
    }

    public void load() throws IOException {
        if (this.finalize) {
            throw new RuntimeException("trying to modify finalized config");
        }
        this.finalize = true;
        try (FileInputStream configStream = new FileInputStream(this.configFile);){
            this.loadedProps.loadFromXML(configStream);
        }
        if (StringUtils.isNullOrEmpty((String)this.globalHiveSyncConfigParams.globallyReplicatedTimeStamp)) {
            throw new RuntimeException("globally replicated timestamp not set");
        }
    }

    Properties mkGlobalHiveSyncProps(boolean forRemote) {
        TypedProperties props = new TypedProperties(this.loadedProps);
        props.putAll((Map)this.globalHiveSyncConfigParams.toProps());
        String basePath = forRemote ? this.loadedProps.getProperty(REMOTE_BASE_PATH) : this.loadedProps.getProperty(LOCAL_BASE_PATH, this.loadedProps.getProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key()));
        props.setPropertyIfNonNull(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), (Object)basePath);
        String jdbcUrl = forRemote ? this.loadedProps.getProperty(REMOTE_HIVE_SERVER_JDBC_URLS) : this.loadedProps.getProperty(LOCAL_HIVE_SERVER_JDBC_URLS, this.loadedProps.getProperty(HiveSyncConfigHolder.HIVE_URL.key()));
        props.setPropertyIfNonNull(HiveSyncConfigHolder.HIVE_URL.key(), (Object)jdbcUrl);
        LOG.info((Object)("building hivesync config forRemote: " + forRemote + " " + jdbcUrl + " " + basePath));
        return props;
    }

    public String toString() {
        return "HiveSyncGlobalCommitParams{ configFile=" + this.configFile + ", properties=" + this.loadedProps + ", " + super.toString() + " }";
    }
}

