/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.PartitionValueExtractor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class HivePartitionUtil {
    private static final Logger LOG = LogManager.getLogger(HivePartitionUtil.class);

    public static String getPartitionClauseForDrop(String partition, PartitionValueExtractor partitionValueExtractor, HiveSyncConfig config) {
        List partitionValues = partitionValueExtractor.extractPartitionValuesInPath(partition);
        ValidationUtils.checkArgument((config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).size() == partitionValues.size() ? 1 : 0) != 0, (String)("Partition key parts " + config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS) + " does not match with partition values " + partitionValues + ". Check partition strategy. "));
        ArrayList<String> partBuilder = new ArrayList<String>();
        for (int i = 0; i < config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).size(); ++i) {
            String partitionValue = (String)partitionValues.get(i);
            if (config.getBoolean(HoodieSyncConfig.META_SYNC_DECODE_PARTITION).booleanValue()) {
                partitionValue = PartitionPathEncodeUtils.unescapePathName((String)partitionValue);
            }
            partBuilder.add((String)config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).get(i) + "=" + partitionValue);
        }
        return String.join((CharSequence)"/", partBuilder);
    }

    public static Boolean partitionExists(IMetaStoreClient client, String tableName, String partitionPath, PartitionValueExtractor partitionValueExtractor, HiveSyncConfig config) {
        Partition newPartition;
        try {
            List partitionValues = partitionValueExtractor.extractPartitionValuesInPath(partitionPath);
            newPartition = client.getPartition(config.getStringOrDefault(HoodieSyncConfig.META_SYNC_DATABASE_NAME), tableName, partitionValues);
        }
        catch (NoSuchObjectException ignored) {
            newPartition = null;
        }
        catch (TException e) {
            LOG.error((Object)("Failed to get partition " + partitionPath), (Throwable)e);
            throw new HoodieHiveSyncException("Failed to get partition " + partitionPath, e);
        }
        return newPartition != null;
    }
}

