/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.hash;

import org.apache.hudi.common.util.Base64CodecUtil;
import org.apache.hudi.common.util.hash.HashID;
import org.apache.hudi.common.util.hash.HoodieID;

public class ColumnID
extends HoodieID {
    private static final HoodieID.Type TYPE = HoodieID.Type.COLUMN;
    private static final HashID.Size ID_COLUMN_HASH_SIZE = HashID.Size.BITS_64;
    private final byte[] hash;

    public ColumnID(String message) {
        this.hash = HashID.hash(message, ID_COLUMN_HASH_SIZE);
    }

    @Override
    public int bits() {
        return ID_COLUMN_HASH_SIZE.byteSize();
    }

    @Override
    public byte[] asBytes() {
        return this.hash;
    }

    @Override
    public String asBase64EncodedString() {
        return Base64CodecUtil.encode(this.hash);
    }

    @Override
    public String toString() {
        return new String(this.hash);
    }

    @Override
    protected HoodieID.Type getType() {
        return TYPE;
    }
}

