/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client.backoff;

import java.util.Map;
import java.util.TreeMap;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ServerStatistics {
    private Map<byte[], RegionStatistics> stats = new TreeMap<byte[], RegionStatistics>(Bytes.BYTES_COMPARATOR);

    public void update(byte[] region, ClientProtos.RegionLoadStats currentStats) {
        RegionStatistics regionStat = this.stats.get(region);
        if (regionStat == null) {
            regionStat = new RegionStatistics();
            this.stats.put(region, regionStat);
        }
        regionStat.update(currentStats);
    }

    @InterfaceAudience.Private
    public RegionStatistics getStatsForRegion(byte[] regionName) {
        return this.stats.get(regionName);
    }

    public static class RegionStatistics {
        private int memstoreLoad = 0;
        private int heapOccupancy = 0;
        private int compactionPressure = 0;

        public void update(ClientProtos.RegionLoadStats currentStats) {
            this.memstoreLoad = currentStats.getMemstoreLoad();
            this.heapOccupancy = currentStats.getHeapOccupancy();
            this.compactionPressure = currentStats.getCompactionPressure();
        }

        public int getMemstoreLoadPercent() {
            return this.memstoreLoad;
        }

        public int getHeapOccupancyPercent() {
            return this.heapOccupancy;
        }

        public int getCompactionPressure() {
            return this.compactionPressure;
        }
    }
}

