/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import org.apache.hudi.com.google.protobuf.Descriptors;
import org.apache.hudi.com.google.protobuf.Message;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class Call {
    final int id;
    final Message param;
    CellScanner cells;
    Message response;
    Message responseDefaultType;
    IOException error;
    volatile boolean done;
    final Descriptors.MethodDescriptor md;
    final int timeout;
    final MetricsConnection.CallStats callStats;

    protected Call(int id, Descriptors.MethodDescriptor md, Message param, CellScanner cells, Message responseDefaultType, int timeout, MetricsConnection.CallStats callStats) {
        this.param = param;
        this.md = md;
        this.cells = cells;
        this.callStats = callStats;
        this.callStats.setStartTime(EnvironmentEdgeManager.currentTime());
        this.responseDefaultType = responseDefaultType;
        this.id = id;
        this.timeout = timeout;
    }

    public boolean checkAndSetTimeout() {
        if (this.timeout == 0) {
            return false;
        }
        long waitTime = EnvironmentEdgeManager.currentTime() - this.getStartTime();
        if (waitTime >= (long)this.timeout) {
            CallTimeoutException ie = new CallTimeoutException("Call id=" + this.id + ", waitTime=" + waitTime + ", operationTimeout=" + this.timeout + " expired.");
            this.setException(ie);
            return true;
        }
        return false;
    }

    public int remainingTime() {
        if (this.timeout == 0) {
            return Integer.MAX_VALUE;
        }
        int remaining = this.timeout - (int)(EnvironmentEdgeManager.currentTime() - this.getStartTime());
        return remaining > 0 ? remaining : 0;
    }

    public String toString() {
        return "callId: " + this.id + " methodName: " + this.md.getName() + " param {" + (this.param != null ? ProtobufUtil.getShortTextFormat(this.param) : "") + "}";
    }

    protected synchronized void callComplete() {
        this.done = true;
        this.notify();
    }

    public void setException(IOException error) {
        this.error = error;
        this.callComplete();
    }

    public void setResponse(Message response, CellScanner cells) {
        this.response = response;
        this.cells = cells;
        this.callComplete();
    }

    public long getStartTime() {
        return this.callStats.getStartTime();
    }
}

