/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.replication;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.Abortable;
import org.apache.hudi.org.apache.hadoop.hbase.Stoppable;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationPeersZKImpl;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationQueuesClientZKImpl;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationQueuesZKImpl;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationTrackerZKImpl;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class ReplicationFactory {
    public static ReplicationQueues getReplicationQueues(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
        return new ReplicationQueuesZKImpl(zk, conf, abortable);
    }

    public static ReplicationQueuesClient getReplicationQueuesClient(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
        return new ReplicationQueuesClientZKImpl(zk, conf, abortable);
    }

    public static ReplicationPeers getReplicationPeers(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) {
        return new ReplicationPeersZKImpl(zk, conf, abortable);
    }

    public static ReplicationTracker getReplicationTracker(ZooKeeperWatcher zookeeper, ReplicationPeers replicationPeers, Configuration conf, Abortable abortable, Stoppable stopper) {
        return new ReplicationTrackerZKImpl(zookeeper, replicationPeers, conf, abortable, stopper);
    }
}

