/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyException;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hudi.org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.EncryptionProtos;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class EncryptionUtil {
    private static final SecureRandom RNG = new SecureRandom();

    public static byte[] wrapKey(Configuration conf, byte[] key, String algorithm) throws IOException {
        return EncryptionUtil.wrapKey(conf, conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), new SecretKeySpec(key, algorithm));
    }

    public static byte[] wrapKey(Configuration conf, String subject, Key key) throws IOException {
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Cipher cipher = Encryption.getCipher(conf, algorithm);
        if (cipher == null) {
            throw new RuntimeException("Cipher '" + algorithm + "' not available");
        }
        EncryptionProtos.WrappedKey.Builder builder = EncryptionProtos.WrappedKey.newBuilder();
        builder.setAlgorithm(key.getAlgorithm());
        byte[] iv = null;
        if (cipher.getIvLength() > 0) {
            iv = new byte[cipher.getIvLength()];
            RNG.nextBytes(iv);
            builder.setIv(ByteStringer.wrap(iv));
        }
        byte[] keyBytes = key.getEncoded();
        builder.setLength(keyBytes.length);
        builder.setHash(ByteStringer.wrap(Encryption.hash128(new byte[][]{keyBytes})));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encryption.encryptWithSubjectKey(out, new ByteArrayInputStream(keyBytes), subject, conf, cipher, iv);
        builder.setData(ByteStringer.wrap(out.toByteArray()));
        out.reset();
        builder.build().writeDelimitedTo(out);
        return out.toByteArray();
    }

    public static Key unwrapKey(Configuration conf, String subject, byte[] value) throws IOException, KeyException {
        EncryptionProtos.WrappedKey wrappedKey = EncryptionProtos.WrappedKey.PARSER.parseDelimitedFrom(new ByteArrayInputStream(value));
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        Cipher cipher = Encryption.getCipher(conf, algorithm);
        if (cipher == null) {
            throw new RuntimeException("Cipher '" + algorithm + "' not available");
        }
        return EncryptionUtil.getUnwrapKey(conf, subject, wrappedKey, cipher);
    }

    private static Key getUnwrapKey(Configuration conf, String subject, EncryptionProtos.WrappedKey wrappedKey, Cipher cipher) throws IOException, KeyException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] iv = wrappedKey.hasIv() ? wrappedKey.getIv().toByteArray() : null;
        Encryption.decryptWithSubjectKey(out, wrappedKey.getData().newInput(), wrappedKey.getLength(), subject, conf, cipher, iv);
        byte[] keyBytes = out.toByteArray();
        if (wrappedKey.hasHash() && !Bytes.equals(wrappedKey.getHash().toByteArray(), Encryption.hash128(new byte[][]{keyBytes}))) {
            throw new KeyException("Key was not successfully unwrapped");
        }
        return new SecretKeySpec(keyBytes, wrappedKey.getAlgorithm());
    }

    public static Key unwrapWALKey(Configuration conf, String subject, byte[] value) throws IOException, KeyException {
        EncryptionProtos.WrappedKey wrappedKey = EncryptionProtos.WrappedKey.PARSER.parseDelimitedFrom(new ByteArrayInputStream(value));
        String algorithm = conf.get("hbase.crypto.wal.algorithm", "AES");
        Cipher cipher = Encryption.getCipher(conf, algorithm);
        if (cipher == null) {
            throw new RuntimeException("Cipher '" + algorithm + "' not available");
        }
        return EncryptionUtil.getUnwrapKey(conf, subject, wrappedKey, cipher);
    }
}

