/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class JVM {
    private static final Log LOG = LogFactory.getLog(JVM.class);
    private OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
    private static final boolean ibmvendor = System.getProperty("java.vendor").contains("IBM");
    private static final boolean windows = System.getProperty("os.name").startsWith("Windows");
    private static final boolean linux = System.getProperty("os.name").startsWith("Linux");
    private static final String JVMVersion = System.getProperty("java.version");
    private static final boolean amd64 = System.getProperty("os.arch").contains("amd64");

    public static boolean isUnix() {
        if (windows) {
            return false;
        }
        return ibmvendor ? linux : true;
    }

    public static boolean isLinux() {
        return linux;
    }

    public static boolean isAmd64() {
        return amd64;
    }

    public static boolean isGZIPOutputStreamFinishBroken() {
        return ibmvendor && JVMVersion.contains("1.6.0");
    }

    private Long runUnixMXBeanMethod(String mBeanMethodName) {
        try {
            Class<?> classRef = Class.forName("com.sun.management.UnixOperatingSystemMXBean");
            if (classRef.isInstance(this.osMbean)) {
                Method mBeanMethod = classRef.getMethod(mBeanMethodName, new Class[0]);
                Object unixos = classRef.cast(this.osMbean);
                return (Long)mBeanMethod.invoke(unixos, new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Not able to load class or method for com.sun.management.UnixOperatingSystemMXBean.", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOpenFileDescriptorCount() {
        if (!ibmvendor) {
            Long ofdc = this.runUnixMXBeanMethod("getOpenFileDescriptorCount");
            return ofdc != null ? ofdc : -1L;
        }
        InputStream in = null;
        BufferedReader output = null;
        try {
            RuntimeMXBean rtmbean = ManagementFactory.getRuntimeMXBean();
            String rtname = rtmbean.getName();
            String[] pidhost = rtname.split("@");
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "ls /proc/" + pidhost[0] + "/fdinfo | wc -l"});
            in = p.getInputStream();
            output = new BufferedReader(new InputStreamReader(in));
            String openFileDesCount = output.readLine();
            if (openFileDesCount != null) {
                long l = Long.parseLong(openFileDesCount);
                return l;
            }
        }
        catch (IOException ie) {
            LOG.warn((Object)"Not able to get the number of open file descriptors", (Throwable)ie);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Not able to close the InputStream", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Not able to close the InputStream", (Throwable)e);
                }
            }
        }
        return -1L;
    }

    public double getSystemLoadAverage() {
        return this.osMbean.getSystemLoadAverage();
    }

    public long getFreeMemory() {
        if (ibmvendor) {
            return 0L;
        }
        Long r = this.runUnixMXBeanMethod("getFreePhysicalMemorySize");
        return r != null ? r : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV_DONT_JUST_NULL_CHECK_READLINE"}, justification="used by testing")
    public int getNumberOfRunningProcess() {
        if (!JVM.isUnix()) {
            return 0;
        }
        BufferedReader input = null;
        try {
            int count = 0;
            Process p = Runtime.getRuntime().exec("ps -e");
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while (input.readLine() != null) {
                ++count;
            }
            int n = count - 1;
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Not able to close the InputStream", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxFileDescriptorCount() {
        if (!ibmvendor) {
            Long mfdc = this.runUnixMXBeanMethod("getMaxFileDescriptorCount");
            return mfdc != null ? mfdc : -1L;
        }
        InputStream in = null;
        BufferedReader output = null;
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "ulimit -n"});
            in = p.getInputStream();
            output = new BufferedReader(new InputStreamReader(in));
            String maxFileDesCount = output.readLine();
            if (maxFileDesCount != null) {
                long l = Long.parseLong(maxFileDesCount);
                return l;
            }
        }
        catch (IOException ie) {
            LOG.warn((Object)"Not able to get the max number of file descriptors", (Throwable)ie);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Not able to close the reader", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Not able to close the InputStream", (Throwable)e);
                }
            }
        }
        return -1L;
    }
}

