/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core;

import io.javalin.Context;
import io.javalin.ExceptionHandler;
import io.javalin.HttpResponseException;
import io.javalin.InternalServerErrorResponse;
import io.javalin.core.util.HttpResponseExceptionMapper;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0080\b\u00a2\u0006\u0002\b\u0014J(\u0010\u0015\u001a\u000e\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0018\u00010\b2\u0012\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0006j\u0002`\u00070\u0005H\u0002J!\u0010\u0017\u001a\u00020\u000f2\n\u0010\u0018\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0019J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u0006j\u0002`\u0007H\u0002R5\u0010\u0003\u001a&\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u00060\u0006j\u0002`\u00070\u0005\u0012\u0010\u0012\u000e\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0018\u00010\b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/javalin/core/ExceptionMapper;", "", "()V", "exceptionMap", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lio/javalin/ExceptionHandler;", "getExceptionMap", "()Ljava/util/HashMap;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "catchException", "", "ctx", "Lio/javalin/Context;", "func", "Lkotlin/Function0;", "catchException$javalin", "getHandler", "exceptionClass", "handle", "exception", "handle$javalin", "noUserHandler", "", "e", "javalin"})
public final class ExceptionMapper {
    private final Logger log = LoggerFactory.getLogger(ExceptionMapper.class);
    @NotNull
    private final HashMap<Class<? extends Exception>, ExceptionHandler<Exception>> exceptionMap = new HashMap();

    @NotNull
    public final HashMap<Class<? extends Exception>, ExceptionHandler<Exception>> getExceptionMap() {
        return this.exceptionMap;
    }

    public final void handle$javalin(@NotNull Exception exception, @NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        ctx.setInExceptionHandler$javalin(true);
        if (HttpResponseExceptionMapper.INSTANCE.canHandle(exception) && this.noUserHandler(exception)) {
            HttpResponseExceptionMapper.INSTANCE.handle(exception, ctx);
        } else {
            ExceptionHandler<Exception> exceptionHandler = this.getHandler(exception.getClass());
            if (exceptionHandler != null) {
                exceptionHandler.handle(exception, ctx);
            } else {
                this.log.warn("Uncaught exception", (Throwable)exception);
                HttpResponseExceptionMapper.INSTANCE.handle(new InternalServerErrorResponse(null, 1, null), ctx);
            }
        }
        ctx.setInExceptionHandler$javalin(false);
    }

    public final void catchException$javalin(@NotNull Context ctx, @NotNull Function0<Unit> func) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        Intrinsics.checkParameterIsNotNull(func, "func");
        try {
            func.invoke();
        }
        catch (Exception e) {
            this.handle$javalin(e, ctx);
        }
    }

    private final ExceptionHandler<Exception> getHandler(Class<? extends Exception> exceptionClass) {
        if (this.exceptionMap.containsKey(exceptionClass)) {
            return this.exceptionMap.get(exceptionClass);
        }
        for (Class<? extends Exception> superclass = exceptionClass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            Map map;
            Map map2 = map = (Map)this.exceptionMap;
            if (map2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (!map2.containsKey(superclass)) continue;
            map = this.exceptionMap;
            return (ExceptionHandler)map.get(superclass);
        }
        return null;
    }

    private final boolean noUserHandler(Exception e) {
        return this.exceptionMap.get(e.getClass()) == null && this.exceptionMap.get(HttpResponseException.class) == null;
    }
}

