/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.PartitionedFile$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

public final class HoodieDataSourceHelper$
implements PredicateHelper,
SparkAdapterSupport {
    public static HoodieDataSourceHelper$ MODULE$;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new HoodieDataSourceHelper$();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieDataSourceHelper$ hoodieDataSourceHelper$ = this;
        synchronized (hoodieDataSourceHelper$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildHoodieParquetReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf, boolean appendPartitionValues) {
        ParquetFileFormat parquetFileFormat = (ParquetFileFormat)this.sparkAdapter().createHoodieParquetFileFormat(appendPartitionValues).get();
        Function1 readParquetFile = parquetFileFormat.buildReaderWithPartitionValues(sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iter = (Iterator)readParquetFile.apply(file);
            return iter.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                GenTraversableOnce genTraversableOnce;
                Object object = x0$1;
                if (object instanceof InternalRow) {
                    InternalRow internalRow = (InternalRow)object;
                    genTraversableOnce = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{internalRow}));
                } else if (object instanceof ColumnarBatch) {
                    ColumnarBatch columnarBatch = (ColumnarBatch)object;
                    genTraversableOnce = (GenTraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(columnarBatch.rowIterator()).asScala();
                } else {
                    throw new MatchError(object);
                }
                return genTraversableOnce;
            });
        };
    }

    public boolean buildHoodieParquetReader$default$8() {
        return false;
    }

    public Seq<PartitionedFile> splitFiles(SparkSession sparkSession, FileStatus file, InternalRow partitionValues) {
        Path filePath = file.getPath();
        long maxSplitBytes = sparkSession.sessionState().conf().filesMaxPartitionBytes();
        return (Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)file.getLen())).by((Object)BoxesRunTime.boxToLong((long)maxSplitBytes)).map((Function1 & Serializable & scala.Serializable)offset -> HoodieDataSourceHelper$.$anonfun$splitFiles$1(file, maxSplitBytes, partitionValues, filePath, BoxesRunTime.unboxToLong((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Configuration getConfigurationWithInternalSchema(Configuration conf, InternalSchema internalSchema, String tablePath, String validCommits) {
        block0: {
            String querySchemaString = SerDeHelper.toJson(internalSchema);
            if (StringUtils.isNullOrEmpty(querySchemaString)) break block0;
            conf.set("hoodie.schema.internal.querySchema", SerDeHelper.toJson(internalSchema));
            conf.set("hoodie.tablePath", tablePath);
            conf.set("hoodie.valid.commits.list", validCommits);
        }
        return conf;
    }

    public static final /* synthetic */ PartitionedFile $anonfun$splitFiles$1(FileStatus file$1, long maxSplitBytes$1, InternalRow partitionValues$1, Path filePath$1, long offset) {
        long remaining = file$1.getLen() - offset;
        long size = remaining > maxSplitBytes$1 ? maxSplitBytes$1 : remaining;
        return new PartitionedFile(partitionValues$1, filePath$1.toUri().toString(), offset, size, PartitionedFile$.MODULE$.apply$default$5());
    }

    private HoodieDataSourceHelper$() {
        MODULE$ = this;
        PredicateHelper.$init$((PredicateHelper)this);
        SparkAdapterSupport.$init$(this);
    }
}

