/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.ReduceFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.types.StructType;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.JavaConverters;
import scala.collection.mutable.Buffer;

public class SparkRowWriteHelper {
    private SparkRowWriteHelper() {
    }

    public static SparkRowWriteHelper newInstance() {
        return WriteHelperHolder.SPARK_WRITE_HELPER;
    }

    public Dataset<Row> deduplicateRows(Dataset<Row> inputDf, String preCombineField, boolean isGlobalIndex) {
        return inputDf.groupByKey((MapFunction & Serializable)value -> isGlobalIndex ? (String)value.getAs("_hoodie_record_key") : value.getAs("_hoodie_partition_path") + "+" + value.getAs("_hoodie_record_key"), Encoders.STRING()).reduceGroups((ReduceFunction & Serializable)(v1, v2) -> ((Comparable)v1.getAs(preCombineField)).compareTo(v2.getAs(preCombineField)) >= 0 ? v1 : v2).map((MapFunction & Serializable)value -> (Row)value._2, (Encoder)this.getEncoder(inputDf.schema()));
    }

    private ExpressionEncoder getEncoder(StructType schema) {
        List attributes = JavaConversions.asJavaCollection((Iterable)schema.toAttributes()).stream().map(Attribute::toAttribute).collect(Collectors.toList());
        return RowEncoder.apply((StructType)schema).resolveAndBind(((Buffer)JavaConverters.asScalaBufferConverter(attributes).asScala()).toSeq(), (Analyzer)SimpleAnalyzer$.MODULE$);
    }

    private static class WriteHelperHolder {
        private static final SparkRowWriteHelper SPARK_WRITE_HELPER = new SparkRowWriteHelper();

        private WriteHelperHolder() {
        }
    }
}

