/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.update.strategy;

import java.util.List;
import java.util.Set;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.table.action.cluster.strategy.UpdateStrategy;

public abstract class BaseSparkUpdateStrategy<T extends HoodieRecordPayload<T>>
extends UpdateStrategy<T, HoodieData<HoodieRecord<T>>> {
    public BaseSparkUpdateStrategy(HoodieSparkEngineContext engineContext, Set<HoodieFileGroupId> fileGroupsInPendingClustering) {
        super(engineContext, fileGroupsInPendingClustering);
    }

    protected List<HoodieFileGroupId> getGroupIdsWithUpdate(HoodieData<HoodieRecord<T>> inputRecords) {
        return inputRecords.filter(record -> record.getCurrentLocation() != null).map(record -> new HoodieFileGroupId(record.getPartitionPath(), record.getCurrentLocation().getFileId())).distinct().collectAsList();
    }
}

