/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RetryHelper<T> {
    private static final Logger LOG = LogManager.getLogger(RetryHelper.class);
    private CheckedFunction<T> func;
    private int num;
    private long maxIntervalTime;
    private long initialIntervalTime = 100L;
    private String taskInfo = "N/A";
    private List<? extends Class<? extends Exception>> retryExceptionsClasses;

    public RetryHelper() {
    }

    public RetryHelper(long maxRetryIntervalMs, int maxRetryNumbers, long initialRetryIntervalMs, String retryExceptions) {
        this.num = maxRetryNumbers;
        this.initialIntervalTime = initialRetryIntervalMs;
        this.maxIntervalTime = maxRetryIntervalMs;
        this.retryExceptionsClasses = StringUtils.isNullOrEmpty(retryExceptions) ? new ArrayList<Class<? extends Exception>>() : Arrays.stream(retryExceptions.split(",")).map(exception -> (Exception)ReflectionUtils.loadClass(exception, "")).map(Object::getClass).collect(Collectors.toList());
    }

    public RetryHelper(String taskInfo) {
        this.taskInfo = taskInfo;
    }

    public RetryHelper tryWith(CheckedFunction<T> func) {
        this.func = func;
        return this;
    }

    public T start() throws IOException {
        int retries = 0;
        T functionResult = null;
        while (true) {
            long waitTime = Math.min(this.getWaitTimeExp(retries), this.maxIntervalTime);
            try {
                functionResult = this.func.get();
            }
            catch (IOException | RuntimeException e) {
                if (!this.checkIfExceptionInRetryList(e)) {
                    throw e;
                }
                if (retries++ >= this.num) {
                    LOG.error((Object)("Still failed to " + this.taskInfo + " after retried " + this.num + " times."), (Throwable)e);
                    throw e;
                }
                LOG.warn((Object)("Catch Exception " + this.taskInfo + ", will retry after " + waitTime + " ms."), (Throwable)e);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        if (retries > 0) {
            LOG.info((Object)("Success to " + this.taskInfo + " after retried " + retries + " times."));
        }
        return functionResult;
    }

    private boolean checkIfExceptionInRetryList(Exception e) {
        boolean inRetryList = false;
        if (this.retryExceptionsClasses.isEmpty()) {
            return true;
        }
        for (Class<? extends Exception> clazz : this.retryExceptionsClasses) {
            if (!clazz.isInstance(e)) continue;
            inRetryList = true;
            break;
        }
        return inRetryList;
    }

    private long getWaitTimeExp(int retryCount) {
        Random random = new Random();
        if (0 == retryCount) {
            return this.initialIntervalTime;
        }
        return (long)Math.pow(2.0, retryCount) * this.initialIntervalTime + (long)random.nextInt(100);
    }

    @FunctionalInterface
    public static interface CheckedFunction<T> {
        public T get() throws IOException;
    }
}

