/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.queue.BoundedInMemoryExecutor;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;

public class SparkLazyInsertIterable<T extends HoodieRecordPayload>
extends HoodieLazyInsertIterable<T> {
    private boolean useWriterSchema;

    public SparkLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, boolean useWriterSchema) {
        super(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier);
        this.useWriterSchema = useWriterSchema;
    }

    public SparkLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, WriteHandleFactory writeHandleFactory) {
        this(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, false, writeHandleFactory);
    }

    public SparkLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, boolean useWriterSchema, WriteHandleFactory writeHandleFactory) {
        super(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, writeHandleFactory);
        this.useWriterSchema = useWriterSchema;
    }

    @Override
    protected List<WriteStatus> computeNext() {
        BoundedInMemoryExecutor bufferedIteratorExecutor = null;
        try {
            Schema schema = new Schema.Parser().parse(this.hoodieConfig.getSchema());
            if (this.useWriterSchema) {
                schema = HoodieAvroUtils.addMetadataFields(schema);
            }
            bufferedIteratorExecutor = new BoundedInMemoryExecutor((long)this.hoodieConfig.getWriteBufferLimitBytes(), this.inputItr, this.getInsertHandler(), SparkLazyInsertIterable.getTransformFunction(schema, this.hoodieConfig), this.hoodieTable.getPreExecuteRunnable());
            List<WriteStatus> result = bufferedIteratorExecutor.execute();
            assert (result != null && !result.isEmpty() && !bufferedIteratorExecutor.isRemaining());
            List<WriteStatus> list = result;
            return list;
        }
        catch (Exception e) {
            throw new HoodieException(e);
        }
        finally {
            if (null != bufferedIteratorExecutor) {
                bufferedIteratorExecutor.shutdownNow();
                bufferedIteratorExecutor.awaitTermination();
            }
        }
    }
}

