/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.replication;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.hive.replication.GlobalHiveSyncConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class GlobalHiveSyncTool
extends HiveSyncTool {
    private static final Logger LOG = LogManager.getLogger(HiveSyncTool.class);

    public GlobalHiveSyncTool(GlobalHiveSyncConfig cfg, HiveConf configuration, FileSystem fs) {
        super(cfg, configuration, fs);
    }

    @Override
    public void syncHoodieTable() {
        this.doSync();
    }

    @Override
    protected void syncHoodieTable(String tableName, boolean useRealtimeInputFormat, boolean readAsOptimized) {
        super.syncHoodieTable(tableName, useRealtimeInputFormat, readAsOptimized);
        if (((GlobalHiveSyncConfig)this.hiveSyncConfig).globallyReplicatedTimeStamp != null) {
            this.hoodieHiveClient.updateLastReplicatedTimeStamp(tableName, ((GlobalHiveSyncConfig)this.hiveSyncConfig).globallyReplicatedTimeStamp);
        }
        LOG.info((Object)("Sync complete for " + tableName));
    }

    public Map<String, Option<String>> getLastReplicatedTimeStampMap() {
        HashMap<String, Option<String>> timeStampMap = new HashMap<String, Option<String>>();
        Option<String> timeStamp = this.hoodieHiveClient.getLastReplicatedTime(this.snapshotTableName);
        timeStampMap.put(this.snapshotTableName, timeStamp);
        if (HoodieTableType.MERGE_ON_READ.equals((Object)this.hoodieHiveClient.getTableType())) {
            Option<String> roTimeStamp = this.hoodieHiveClient.getLastReplicatedTime((String)this.roTableName.get());
            timeStampMap.put((String)this.roTableName.get(), roTimeStamp);
        }
        return timeStampMap;
    }

    public void setLastReplicatedTimeStamp(Map<String, Option<String>> timeStampMap) {
        for (String tableName : timeStampMap.keySet()) {
            Option<String> timestamp = timeStampMap.get(tableName);
            if (timestamp.isPresent()) {
                this.hoodieHiveClient.updateLastReplicatedTimeStamp(tableName, timestamp.get());
                LOG.info((Object)("updated timestamp for " + tableName + " to: " + timestamp.get()));
                continue;
            }
            this.hoodieHiveClient.deleteLastReplicatedTimeStamp(tableName);
            LOG.info((Object)("deleted timestamp for " + tableName));
        }
    }

    public static GlobalHiveSyncTool buildGlobalHiveSyncTool(GlobalHiveSyncConfig cfg, HiveConf hiveConf) {
        FileSystem fs = FSUtils.getFs(cfg.basePath, new Configuration());
        hiveConf.addResource(fs.getConf());
        return new GlobalHiveSyncTool(cfg, hiveConf, fs);
    }
}

