/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.exception.MetadataNotFoundException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.IntervalTreeBasedIndexFileFilter;
import org.apache.hudi.index.bloom.ListBasedIndexFileFilter;
import org.apache.hudi.io.HoodieRangeInfoHandle;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieBloomIndex
extends HoodieIndex<Object, Object> {
    private static final Logger LOG = LogManager.getLogger(HoodieBloomIndex.class);
    private final BaseHoodieBloomIndexHelper bloomIndexHelper;

    public HoodieBloomIndex(HoodieWriteConfig config, BaseHoodieBloomIndexHelper bloomIndexHelper) {
        super(config);
        this.bloomIndexHelper = bloomIndexHelper;
    }

    @Override
    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable) {
        if (this.config.getBloomIndexUseCaching()) {
            records.persist(new HoodieConfig(this.config.getProps()).getString(HoodieIndexConfig.BLOOM_INDEX_INPUT_STORAGE_LEVEL_VALUE));
        }
        HoodiePairData<String, String> partitionRecordKeyPairs = records.mapToPair(record -> new ImmutablePair<String, String>(record.getPartitionPath(), record.getRecordKey()));
        HoodiePairData<HoodieKey, HoodieRecordLocation> keyFilenamePairs = this.lookupIndex(partitionRecordKeyPairs, context, hoodieTable);
        if (this.config.getBloomIndexUseCaching()) {
            keyFilenamePairs.persist("MEMORY_AND_DISK_SER");
        }
        if (LOG.isDebugEnabled()) {
            long totalTaggedRecords = keyFilenamePairs.count();
            LOG.debug((Object)("Number of update records (ones tagged with a fileID): " + totalTaggedRecords));
        }
        HoodieData<HoodieRecord<R>> taggedRecords = this.tagLocationBacktoRecords(keyFilenamePairs, records);
        if (this.config.getBloomIndexUseCaching()) {
            records.unpersist();
            keyFilenamePairs.unpersist();
        }
        return taggedRecords;
    }

    private HoodiePairData<HoodieKey, HoodieRecordLocation> lookupIndex(HoodiePairData<String, String> partitionRecordKeyPairs, HoodieEngineContext context, HoodieTable hoodieTable) {
        Map<String, Long> recordsPerPartition = partitionRecordKeyPairs.countByKey();
        ArrayList<String> affectedPartitionPathList = new ArrayList<String>(recordsPerPartition.keySet());
        List<Pair<String, BloomIndexFileInfo>> fileInfoList = this.getBloomIndexFileInfoForPartitions(context, hoodieTable, affectedPartitionPathList);
        Map<String, List<BloomIndexFileInfo>> partitionToFileInfo = fileInfoList.stream().collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        HoodieData<Pair<String, HoodieKey>> fileComparisonPairs = this.explodeRecordsWithFileComparisons(partitionToFileInfo, partitionRecordKeyPairs);
        return this.bloomIndexHelper.findMatchingFilesForRecordKeys(this.config, context, hoodieTable, partitionRecordKeyPairs, fileComparisonPairs, partitionToFileInfo, recordsPerPartition);
    }

    private List<Pair<String, BloomIndexFileInfo>> getBloomIndexFileInfoForPartitions(HoodieEngineContext context, HoodieTable hoodieTable, List<String> affectedPartitionPathList) {
        List<Object> fileInfoList = new ArrayList();
        if (this.config.getBloomIndexPruneByRanges()) {
            if (this.config.getBloomIndexUseMetadata() && HoodieTableMetadataUtil.getCompletedMetadataPartitions(hoodieTable.getMetaClient().getTableConfig()).contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath())) {
                fileInfoList = this.loadColumnRangesFromMetaIndex(affectedPartitionPathList, context, hoodieTable);
            }
            if (CollectionUtils.isNullOrEmpty(fileInfoList)) {
                fileInfoList = this.loadColumnRangesFromFiles(affectedPartitionPathList, context, hoodieTable);
            }
        } else {
            fileInfoList = this.getFileInfoForLatestBaseFiles(affectedPartitionPathList, context, hoodieTable);
        }
        return fileInfoList;
    }

    List<Pair<String, BloomIndexFileInfo>> loadColumnRangesFromFiles(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        List partitionPathFileIDList = HoodieIndexUtils.getLatestBaseFilesForAllPartitions(partitions, context, hoodieTable).stream().map(pair -> Pair.of(pair.getKey(), ((HoodieBaseFile)pair.getValue()).getFileId())).collect(Collectors.toList());
        context.setJobStatus(this.getClass().getName(), "Obtain key ranges for file slices (range pruning=on): " + this.config.getTableName());
        return context.map(partitionPathFileIDList, pf -> {
            try {
                HoodieRangeInfoHandle rangeInfoHandle = new HoodieRangeInfoHandle(this.config, hoodieTable, (Pair<String, String>)pf);
                String[] minMaxKeys = rangeInfoHandle.getMinMaxKeys();
                return Pair.of(pf.getKey(), new BloomIndexFileInfo((String)pf.getValue(), minMaxKeys[0], minMaxKeys[1]));
            }
            catch (MetadataNotFoundException me) {
                LOG.warn((Object)("Unable to find range metadata in file :" + pf));
                return Pair.of(pf.getKey(), new BloomIndexFileInfo((String)pf.getValue()));
            }
        }, Math.max(partitionPathFileIDList.size(), 1));
    }

    private List<Pair<String, BloomIndexFileInfo>> getFileInfoForLatestBaseFiles(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        List partitionPathFileIDList = HoodieIndexUtils.getLatestBaseFilesForAllPartitions(partitions, context, hoodieTable).stream().map(pair -> Pair.of(pair.getKey(), ((HoodieBaseFile)pair.getValue()).getFileId())).collect(Collectors.toList());
        return partitionPathFileIDList.stream().map(pf -> Pair.of(pf.getKey(), new BloomIndexFileInfo((String)pf.getValue()))).collect(Collectors.toList());
    }

    protected List<Pair<String, BloomIndexFileInfo>> loadColumnRangesFromMetaIndex(List<String> partitions, HoodieEngineContext context, HoodieTable<?, ?, ?, ?> hoodieTable) {
        context.setJobStatus(this.getClass().getName(), "Load meta index key ranges for file slices: " + this.config.getTableName());
        String keyField = hoodieTable.getMetaClient().getTableConfig().getRecordKeyFieldProp();
        return context.flatMap(partitions, partitionName -> {
            List<Pair<String, String>> partitionFileNameList = HoodieIndexUtils.getLatestBaseFilesForPartition(partitionName, hoodieTable).stream().map(baseFile -> Pair.of(partitionName, baseFile.getFileName())).sorted().collect(Collectors.toList());
            if (partitionFileNameList.isEmpty()) {
                return Stream.empty();
            }
            try {
                Map<Pair<String, String>, HoodieMetadataColumnStats> fileToColumnStatsMap = hoodieTable.getMetadataTable().getColumnStats(partitionFileNameList, keyField);
                ArrayList<Pair<String, BloomIndexFileInfo>> result = new ArrayList<Pair<String, BloomIndexFileInfo>>();
                for (Map.Entry<Pair<String, String>, HoodieMetadataColumnStats> entry : fileToColumnStatsMap.entrySet()) {
                    result.add(Pair.of(entry.getKey().getLeft(), new BloomIndexFileInfo(FSUtils.getFileId(entry.getKey().getRight()), (String)((Object)HoodieMetadataPayload.unwrapStatisticValueWrapper(entry.getValue().getMinValue())), (String)((Object)HoodieMetadataPayload.unwrapStatisticValueWrapper(entry.getValue().getMaxValue())))));
                }
                return result.stream();
            }
            catch (MetadataNotFoundException me) {
                throw new HoodieMetadataException("Unable to find column range metadata for partition:" + partitionName, me);
            }
        }, Math.max(partitions.size(), 1));
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean canIndexLogFiles() {
        return false;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return true;
    }

    HoodieData<Pair<String, HoodieKey>> explodeRecordsWithFileComparisons(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo, HoodiePairData<String, String> partitionRecordKeyPairs) {
        IndexFileFilter indexFileFilter = this.config.useBloomIndexTreebasedFilter() ? new IntervalTreeBasedIndexFileFilter(partitionToFileIndexInfo) : new ListBasedIndexFileFilter(partitionToFileIndexInfo);
        return partitionRecordKeyPairs.map(partitionRecordKeyPair -> {
            String recordKey = (String)partitionRecordKeyPair.getRight();
            String partitionPath = (String)partitionRecordKeyPair.getLeft();
            return indexFileFilter.getMatchingFilesAndPartition(partitionPath, recordKey).stream().map(partitionFileIdPair -> new ImmutablePair(partitionFileIdPair.getRight(), new HoodieKey(recordKey, partitionPath))).collect(Collectors.toList());
        }).flatMap(List::iterator);
    }

    protected <R> HoodieData<HoodieRecord<R>> tagLocationBacktoRecords(HoodiePairData<HoodieKey, HoodieRecordLocation> keyFilenamePair, HoodieData<HoodieRecord<R>> records) {
        HoodiePairData keyRecordPairs = records.mapToPair(record -> new ImmutablePair<HoodieKey, HoodieRecord>(record.getKey(), (HoodieRecord)record));
        return keyRecordPairs.leftOuterJoin(keyFilenamePair).values().map(v -> HoodieIndexUtils.getTaggedRecord((HoodieRecord)v.getLeft(), Option.ofNullable(((Option)v.getRight()).orElse(null))));
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatusData, HoodieEngineContext context, HoodieTable hoodieTable) {
        return writeStatusData;
    }
}

