/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.RowKeyGeneratorHelper;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;

public abstract class BuiltinKeyGenerator
extends BaseKeyGenerator
implements SparkKeyGeneratorInterface {
    private static final String STRUCT_NAME = "hoodieRowTopLevelField";
    private static final String NAMESPACE = "hoodieRow";
    private Function1<Row, GenericRecord> converterFn = null;
    private final AtomicBoolean validatePartitionFields = new AtomicBoolean(false);
    protected StructType structType;
    protected Map<String, Pair<List<Integer>, DataType>> recordKeySchemaInfo = new HashMap<String, Pair<List<Integer>, DataType>>();
    protected Map<String, Pair<List<Integer>, DataType>> partitionPathSchemaInfo = new HashMap<String, Pair<List<Integer>, DataType>>();

    protected BuiltinKeyGenerator(TypedProperties config) {
        super(config);
    }

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public String getRecordKey(Row row) {
        if (null == this.converterFn) {
            this.converterFn = AvroConversionUtils.createConverterToAvro(row.schema(), STRUCT_NAME, NAMESPACE);
        }
        return this.getKey((GenericRecord)this.converterFn.apply((Object)row)).getRecordKey();
    }

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public String getPartitionPath(Row row) {
        if (null == this.converterFn) {
            this.converterFn = AvroConversionUtils.createConverterToAvro(row.schema(), STRUCT_NAME, NAMESPACE);
        }
        return this.getKey((GenericRecord)this.converterFn.apply((Object)row)).getPartitionPath();
    }

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public String getPartitionPath(InternalRow internalRow, StructType structType) {
        try {
            this.buildFieldSchemaInfoIfNeeded(structType);
            return RowKeyGeneratorHelper.getPartitionPathFromInternalRow(internalRow, this.getPartitionPathFields(), this.hiveStylePartitioning, this.partitionPathSchemaInfo);
        }
        catch (Exception e) {
            throw new HoodieIOException("Conversion of InternalRow to Row failed with exception " + e);
        }
    }

    void buildFieldSchemaInfoIfNeeded(StructType structType) {
        if (this.structType == null) {
            this.getRecordKeyFields().stream().filter(f -> !f.isEmpty()).forEach(f -> this.recordKeySchemaInfo.put((String)f, RowKeyGeneratorHelper.getFieldSchemaInfo(structType, f, true)));
            if (this.getPartitionPathFields() != null) {
                this.getPartitionPathFields().stream().filter(f -> !f.isEmpty()).forEach(f -> this.partitionPathSchemaInfo.put((String)f, RowKeyGeneratorHelper.getFieldSchemaInfo(structType, f, false)));
            }
            this.structType = structType;
        }
    }

    protected String getPartitionPathInternal(InternalRow row, StructType structType) {
        this.buildFieldSchemaInfoIfNeeded(structType);
        this.validatePartitionFieldsForInternalRow();
        return RowKeyGeneratorHelper.getPartitionPathFromInternalRow(row, this.getPartitionPathFields(), this.hiveStylePartitioning, this.partitionPathSchemaInfo);
    }

    protected void validatePartitionFieldsForInternalRow() {
        if (!this.validatePartitionFields.getAndSet(true)) {
            this.partitionPathSchemaInfo.values().forEach(entry -> {
                if (((List)entry.getKey()).size() > 1) {
                    throw new IllegalArgumentException("Nested column for partitioning is not supported with disabling meta columns");
                }
            });
        }
    }
}

