/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Option;

public class RowKeyGeneratorHelper {
    public static String getRecordKeyFromRow(Row row, List<String> recordKeyFields, Map<String, Pair<List<Integer>, DataType>> recordKeyPositions, boolean prefixFieldName) {
        AtomicBoolean keyIsNullOrEmpty = new AtomicBoolean(true);
        String toReturn = recordKeyFields.stream().map(field -> {
            String val = null;
            List fieldPositions = (List)((Pair)recordKeyPositions.get(field)).getKey();
            if (fieldPositions.size() == 1) {
                Integer fieldPos = (Integer)fieldPositions.get(0);
                if (row.isNullAt(fieldPos.intValue())) {
                    val = "__null__";
                } else {
                    val = row.getAs(field).toString();
                    if (val.isEmpty()) {
                        val = "__empty__";
                    } else {
                        keyIsNullOrEmpty.set(false);
                    }
                }
            } else {
                val = RowKeyGeneratorHelper.getNestedFieldVal(row, (List)((Pair)recordKeyPositions.get(field)).getKey()).toString();
                if (!val.contains("__null__") && !val.contains("__empty__")) {
                    keyIsNullOrEmpty.set(false);
                }
            }
            return prefixFieldName ? field + ":" + val : val;
        }).collect(Collectors.joining(","));
        if (keyIsNullOrEmpty.get()) {
            throw new HoodieKeyException("recordKey value: \"" + toReturn + "\" for fields: \"" + Arrays.toString(recordKeyFields.toArray()) + "\" cannot be null or empty.");
        }
        return toReturn;
    }

    public static String getPartitionPathFromRow(Row row, List<String> partitionPathFields, boolean hiveStylePartitioning, Map<String, Pair<List<Integer>, DataType>> partitionPathPositions) {
        return IntStream.range(0, partitionPathFields.size()).mapToObj(idx -> {
            String field = (String)partitionPathFields.get(idx);
            String val = null;
            List fieldPositions = (List)((Pair)partitionPathPositions.get(field)).getKey();
            if (fieldPositions.size() == 1) {
                Integer fieldPos = (Integer)fieldPositions.get(0);
                if (fieldPos == -1 || row.isNullAt(fieldPos.intValue())) {
                    val = "default";
                } else {
                    Object data = row.get(fieldPos.intValue());
                    val = RowKeyGeneratorHelper.convertToTimestampIfInstant(data).toString();
                    if (val.isEmpty()) {
                        val = "default";
                    }
                }
                if (hiveStylePartitioning) {
                    val = field + "=" + val;
                }
            } else {
                Object data = RowKeyGeneratorHelper.getNestedFieldVal(row, (List)((Pair)partitionPathPositions.get(field)).getKey());
                val = (data = RowKeyGeneratorHelper.convertToTimestampIfInstant(data)).toString().contains("__null__") || data.toString().contains("__empty__") ? (hiveStylePartitioning ? field + "=" + "default" : "default") : (hiveStylePartitioning ? field + "=" + data.toString() : data.toString());
            }
            return val;
        }).collect(Collectors.joining("/"));
    }

    public static String getPartitionPathFromInternalRow(InternalRow internalRow, List<String> partitionPathFields, boolean hiveStylePartitioning, Map<String, Pair<List<Integer>, DataType>> partitionPathPositions) {
        return IntStream.range(0, partitionPathFields.size()).mapToObj(idx -> {
            String field = (String)partitionPathFields.get(idx);
            String val = null;
            List fieldPositions = (List)((Pair)partitionPathPositions.get(field)).getKey();
            DataType dataType = (DataType)((Pair)partitionPathPositions.get(field)).getValue();
            if (fieldPositions.size() == 1) {
                Object value;
                Integer fieldPos = (Integer)fieldPositions.get(0);
                val = fieldPos == -1 || internalRow.isNullAt(fieldPos.intValue()) ? "default" : ((value = internalRow.get(fieldPos.intValue(), dataType)) == null || value.toString().isEmpty() ? "default" : value.toString());
                if (hiveStylePartitioning) {
                    val = field + "=" + val;
                }
            } else {
                throw new IllegalArgumentException("Nested partitioning is not supported with disabling meta columns.");
            }
            return val;
        }).collect(Collectors.joining("/"));
    }

    public static Object getFieldValFromInternalRow(InternalRow internalRow, Integer partitionPathPosition, DataType partitionPathDataType) {
        Object val = null;
        if (internalRow.isNullAt(partitionPathPosition.intValue())) {
            return "default";
        }
        Object value = partitionPathDataType == DataTypes.StringType ? internalRow.getString(partitionPathPosition.intValue()) : internalRow.get(partitionPathPosition.intValue(), partitionPathDataType);
        val = value == null || value.toString().isEmpty() ? "default" : value;
        return val;
    }

    public static Object getNestedFieldVal(Row row, List<Integer> positions) {
        if (positions.size() == 1 && positions.get(0) == -1) {
            return "default";
        }
        int totalCount = positions.size();
        Row valueToProcess = row;
        Object toReturn = null;
        for (int index = 0; index < totalCount; ++index) {
            if (valueToProcess.isNullAt(positions.get(index).intValue())) {
                toReturn = "__null__";
                break;
            }
            if (index < totalCount - 1) {
                valueToProcess = (Row)valueToProcess.get(positions.get(index).intValue());
                continue;
            }
            if (valueToProcess.getAs(positions.get(index).intValue()).toString().isEmpty()) {
                toReturn = "__empty__";
                break;
            }
            toReturn = valueToProcess.getAs(positions.get(index).intValue());
        }
        return toReturn;
    }

    public static Pair<List<Integer>, DataType> getFieldSchemaInfo(StructType structType, String field, boolean isRecordKey) {
        String[] slices = field.split("\\.");
        List<Integer> positions = new ArrayList<Integer>();
        int totalCount = slices.length;
        DataType leafFieldDataType = null;
        for (int index = 0; index < totalCount; ++index) {
            String slice = slices[index];
            Option curIndexOpt = structType.getFieldIndex(slice);
            if (curIndexOpt.isDefined()) {
                int curIndex = (Integer)curIndexOpt.get();
                positions.add(curIndex);
                StructField nestedField = structType.fields()[curIndex];
                if (index < totalCount - 1) {
                    if (!(nestedField.dataType() instanceof StructType)) {
                        if (isRecordKey) {
                            throw new HoodieKeyException("Nested field should be of type StructType " + nestedField);
                        }
                        positions = Collections.singletonList(-1);
                        break;
                    }
                    structType = (StructType)nestedField.dataType();
                    continue;
                }
                leafFieldDataType = nestedField.dataType();
                continue;
            }
            if (isRecordKey) {
                throw new HoodieKeyException("Can't find " + slice + " in StructType for the field " + field);
            }
            positions = Collections.singletonList(-1);
            break;
        }
        return Pair.of(positions, leafFieldDataType);
    }

    private static Object convertToTimestampIfInstant(Object data) {
        if (data instanceof Instant) {
            return Timestamp.from((Instant)data);
        }
        return data;
    }
}

