/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Collections;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.RowKeyGeneratorHelper;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class SimpleKeyGenerator
extends BuiltinKeyGenerator {
    private final SimpleAvroKeyGenerator simpleAvroKeyGenerator;

    public SimpleKeyGenerator(TypedProperties props) {
        this(props, props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()), props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
    }

    SimpleKeyGenerator(TypedProperties props, String partitionPathField) {
        this(props, null, partitionPathField);
    }

    SimpleKeyGenerator(TypedProperties props, String recordKeyField, String partitionPathField) {
        super(props);
        this.recordKeyFields = recordKeyField == null ? Collections.emptyList() : Collections.singletonList(recordKeyField);
        this.partitionPathFields = partitionPathField == null ? Collections.emptyList() : Collections.singletonList(partitionPathField);
        this.simpleAvroKeyGenerator = new SimpleAvroKeyGenerator(props, recordKeyField, partitionPathField);
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return this.simpleAvroKeyGenerator.getRecordKey(record);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.simpleAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        this.buildFieldSchemaInfoIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getRecordKeyFromRow(row, this.getRecordKeyFields(), this.recordKeySchemaInfo, false);
    }

    @Override
    public String getPartitionPath(Row row) {
        this.buildFieldSchemaInfoIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getPartitionPathFromRow(row, this.getPartitionPathFields(), this.hiveStylePartitioning, this.partitionPathSchemaInfo);
    }

    @Override
    public String getPartitionPath(InternalRow row, StructType structType) {
        return this.getPartitionPathInternal(row, structType);
    }
}

