/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hudi.org.apache.hadoop.hbase.client.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchErrors {
    private static final Logger LOG = LoggerFactory.getLogger(BatchErrors.class);
    final List<Throwable> throwables = new ArrayList<Throwable>();
    final List<Row> actions = new ArrayList<Row>();
    final List<String> addresses = new ArrayList<String>();

    BatchErrors() {
    }

    public synchronized void add(Throwable ex, Row row, ServerName serverName) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null. location=" + serverName);
        }
        this.throwables.add(ex);
        this.actions.add(row);
        this.addresses.add(serverName != null ? serverName.toString() : "null");
    }

    public boolean hasErrors() {
        return !this.throwables.isEmpty();
    }

    synchronized RetriesExhaustedWithDetailsException makeException(boolean logDetails) {
        if (logDetails) {
            LOG.error("Exception occurred! Exception details: " + this.throwables + ";\nActions: " + this.actions);
        }
        return new RetriesExhaustedWithDetailsException(new ArrayList<Throwable>(this.throwables), new ArrayList<Row>(this.actions), new ArrayList<String>(this.addresses));
    }

    public synchronized void clear() {
        this.throwables.clear();
        this.actions.clear();
        this.addresses.clear();
    }

    public synchronized void merge(BatchErrors other) {
        this.throwables.addAll(other.throwables);
        this.actions.addAll(other.actions);
        this.addresses.addAll(other.addresses);
    }
}

