/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface BufferedMutator
extends Closeable {
    public static final String CLASSNAME_KEY = "hbase.client.bufferedmutator.classname";
    public static final long MIN_WRITE_BUFFER_PERIODIC_FLUSH_TIMERTICK_MS = 100L;

    public TableName getName();

    public Configuration getConfiguration();

    public void mutate(Mutation var1) throws IOException;

    public void mutate(List<? extends Mutation> var1) throws IOException;

    @Override
    public void close() throws IOException;

    public void flush() throws IOException;

    default public void setWriteBufferPeriodicFlush(long timeoutMs) {
        this.setWriteBufferPeriodicFlush(timeoutMs, 1000L);
    }

    default public void setWriteBufferPeriodicFlush(long timeoutMs, long timerTickMs) {
        throw new UnsupportedOperationException("The BufferedMutator::setWriteBufferPeriodicFlush has not been implemented");
    }

    default public void disableWriteBufferPeriodicFlush() {
        this.setWriteBufferPeriodicFlush(0L, 100L);
    }

    default public long getWriteBufferPeriodicFlushTimeoutMs() {
        throw new UnsupportedOperationException("The BufferedMutator::getWriteBufferPeriodicFlushTimeoutMs has not been implemented");
    }

    default public long getWriteBufferPeriodicFlushTimerTickMs() {
        throw new UnsupportedOperationException("The BufferedMutator::getWriteBufferPeriodicFlushTimerTickMs has not been implemented");
    }

    public long getWriteBufferSize();

    public void setRpcTimeout(int var1);

    public void setOperationTimeout(int var1);

    @InterfaceAudience.Public
    public static interface ExceptionListener {
        public void onException(RetriesExhaustedWithDetailsException var1, BufferedMutator var2) throws RetriesExhaustedWithDetailsException;
    }
}

