/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.NettyServerCall;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcResponse;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerRpcConnection;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyServerRpcConnection
extends ServerRpcConnection {
    final Channel channel;

    NettyServerRpcConnection(NettyRpcServer rpcServer, Channel channel) {
        super(rpcServer);
        this.channel = channel;
        InetSocketAddress inetSocketAddress = (InetSocketAddress)channel.remoteAddress();
        this.addr = inetSocketAddress.getAddress();
        this.hostAddress = this.addr == null ? "*Unknown*" : inetSocketAddress.getAddress().getHostAddress();
        this.remotePort = inetSocketAddress.getPort();
    }

    void process(ByteBuf buf) throws IOException, InterruptedException {
        if (this.connectionHeaderRead) {
            this.callCleanup = buf::release;
            this.process(new SingleByteBuff(buf.nioBuffer()));
        } else {
            ByteBuffer connectionHeader = ByteBuffer.allocate(buf.readableBytes());
            buf.readBytes(connectionHeader);
            buf.release();
            this.process(connectionHeader);
        }
    }

    void process(ByteBuffer buf) throws IOException, InterruptedException {
        this.process(new SingleByteBuff(buf));
    }

    void process(ByteBuff buf) throws IOException, InterruptedException {
        try {
            if (this.skipInitialSaslHandshake) {
                this.skipInitialSaslHandshake = false;
                if (this.callCleanup != null) {
                    this.callCleanup.run();
                }
                return;
            }
            if (this.useSasl) {
                this.saslReadAndProcess(buf);
            } else {
                this.processOneRpc(buf);
            }
        }
        catch (Exception e) {
            if (this.callCleanup != null) {
                this.callCleanup.run();
            }
            throw e;
        }
        finally {
            this.callCleanup = null;
        }
    }

    @Override
    public synchronized void close() {
        this.disposeSasl();
        this.channel.close();
        this.callCleanup = null;
    }

    @Override
    public boolean isConnectionOpen() {
        return this.channel.isOpen();
    }

    public NettyServerCall createCall(int id, BlockingService service2, Descriptors.MethodDescriptor md, RPCProtos.RequestHeader header, Message param, CellScanner cellScanner, long size, InetAddress remoteAddress, int timeout, RpcServer.CallCleanup reqCleanup) {
        return new NettyServerCall(id, service2, md, header, param, cellScanner, this, size, remoteAddress, System.currentTimeMillis(), timeout, this.rpcServer.bbAllocator, this.rpcServer.cellBlockBuilder, reqCleanup);
    }

    @Override
    protected void doRespond(RpcResponse resp) {
        this.channel.writeAndFlush(resp);
    }
}

