/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hudi.org.apache.hadoop.hbase.io.ByteBufferListOutputStream;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.BufferChain;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.CellBlockBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcCallback;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcResponse;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerRpcConnection;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ServerCall<T extends ServerRpcConnection>
implements RpcCall,
RpcResponse {
    protected final int id;
    protected final BlockingService service;
    protected final Descriptors.MethodDescriptor md;
    protected final RPCProtos.RequestHeader header;
    protected Message param;
    protected final CellScanner cellScanner;
    protected final T connection;
    protected final long receiveTime;
    protected final int timeout;
    protected long startTime;
    protected final long deadline;
    protected final ByteBuffAllocator bbAllocator;
    protected final CellBlockBuilder cellBlockBuilder;
    protected BufferChain response;
    protected final long size;
    protected boolean isError;
    protected ByteBufferListOutputStream cellBlockStream = null;
    protected RpcServer.CallCleanup reqCleanup = null;
    protected final User user;
    protected final InetAddress remoteAddress;
    protected RpcCallback rpcCallback;
    private long responseCellSize = 0L;
    private long responseBlockSize = 0L;
    private long exceptionSize = 0L;
    private final boolean retryImmediatelySupported;
    private final AtomicInteger reference = new AtomicInteger(Integer.MIN_VALUE);

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="Can't figure why this complaint is happening... see below")
    ServerCall(int id, BlockingService service2, Descriptors.MethodDescriptor md, RPCProtos.RequestHeader header, Message param, CellScanner cellScanner, T connection, long size, InetAddress remoteAddress, long receiveTime, int timeout, ByteBuffAllocator byteBuffAllocator, CellBlockBuilder cellBlockBuilder, RpcServer.CallCleanup reqCleanup) {
        this.id = id;
        this.service = service2;
        this.md = md;
        this.header = header;
        this.param = param;
        this.cellScanner = cellScanner;
        this.connection = connection;
        this.receiveTime = receiveTime;
        this.response = null;
        this.isError = false;
        this.size = size;
        if (connection != null) {
            this.user = ((ServerRpcConnection)connection).user;
            this.retryImmediatelySupported = ((ServerRpcConnection)connection).retryImmediatelySupported;
        } else {
            this.user = null;
            this.retryImmediatelySupported = false;
        }
        this.remoteAddress = remoteAddress;
        this.timeout = timeout;
        this.deadline = this.timeout > 0 ? this.receiveTime + (long)this.timeout : Long.MAX_VALUE;
        this.bbAllocator = byteBuffAllocator;
        this.cellBlockBuilder = cellBlockBuilder;
        this.reqCleanup = reqCleanup;
    }

    @Override
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Presume the lock on processing request held by caller is protection enough")
    public void done() {
        if (this.cellBlockStream != null) {
            this.cellBlockStream.releaseResources();
            this.cellBlockStream = null;
        }
        this.cleanup();
    }

    @Override
    public void cleanup() {
        int nextRef;
        int ref;
        do {
            if (((ref = this.reference.get()) & Integer.MIN_VALUE) != 0) continue;
            return;
        } while (!this.reference.compareAndSet(ref, nextRef = ref & Integer.MAX_VALUE));
        if (nextRef == 0 && this.reqCleanup != null) {
            this.reqCleanup.run();
        }
    }

    public void retainByWAL() {
        this.reference.incrementAndGet();
    }

    public void releaseByWAL() {
        if (this.reference.decrementAndGet() == 0 && this.reqCleanup != null) {
            this.reqCleanup.run();
        }
    }

    public String toString() {
        return this.toShortString() + " param: " + (this.param != null ? ProtobufUtil.getShortTextFormat(this.param) : "") + " connection: " + ((ServerRpcConnection)this.connection).toString();
    }

    @Override
    public RPCProtos.RequestHeader getHeader() {
        return this.header;
    }

    @Override
    public int getPriority() {
        return this.header.getPriority();
    }

    @Override
    public String toShortString() {
        String serviceName = ((ServerRpcConnection)this.connection).service != null ? ((ServerRpcConnection)this.connection).service.getDescriptorForType().getName() : "null";
        return "callId: " + this.id + " service: " + serviceName + " methodName: " + (this.md != null ? this.md.getName() : "n/a") + " size: " + StringUtils.TraditionalBinaryPrefix.long2String((long)this.size, (String)"", (int)1) + " connection: " + ((ServerRpcConnection)this.connection).toString() + " deadline: " + this.deadline;
    }

    @Override
    public synchronized void setResponse(Message m, CellScanner cells, Throwable t, String errorMsg) {
        if (this.isError) {
            return;
        }
        if (t != null) {
            this.isError = true;
        }
        BufferChain bc = null;
        try {
            RPCProtos.ResponseHeader.Builder headerBuilder = RPCProtos.ResponseHeader.newBuilder();
            headerBuilder.setCallId(this.id);
            if (t != null) {
                ServerCall.setExceptionResponse(t, errorMsg, headerBuilder);
            }
            List<ByteBuffer> cellBlock = null;
            int cellBlockSize = 0;
            if (this.bbAllocator.isReservoirEnabled()) {
                this.cellBlockStream = this.cellBlockBuilder.buildCellBlockStream(((ServerRpcConnection)this.connection).codec, ((ServerRpcConnection)this.connection).compressionCodec, cells, this.bbAllocator);
                if (this.cellBlockStream != null) {
                    cellBlock = this.cellBlockStream.getByteBuffers();
                    cellBlockSize = this.cellBlockStream.size();
                }
            } else {
                ByteBuffer b = this.cellBlockBuilder.buildCellBlock(((ServerRpcConnection)this.connection).codec, ((ServerRpcConnection)this.connection).compressionCodec, cells);
                if (b != null) {
                    cellBlockSize = b.remaining();
                    cellBlock = new ArrayList<ByteBuffer>(1);
                    cellBlock.add(b);
                }
            }
            if (cellBlockSize > 0) {
                RPCProtos.CellBlockMeta.Builder cellBlockBuilder = RPCProtos.CellBlockMeta.newBuilder();
                cellBlockBuilder.setLength(cellBlockSize);
                headerBuilder.setCellBlockMeta(cellBlockBuilder.build());
            }
            RPCProtos.ResponseHeader header = headerBuilder.build();
            ByteBuffer headerBuf = ServerCall.createHeaderAndMessageBytes(m, (Message)header, cellBlockSize, cellBlock);
            ByteBuffer[] responseBufs = null;
            int cellBlockBufferSize = 0;
            if (cellBlock != null) {
                cellBlockBufferSize = cellBlock.size();
                responseBufs = new ByteBuffer[1 + cellBlockBufferSize];
            } else {
                responseBufs = new ByteBuffer[]{headerBuf};
            }
            if (cellBlock != null) {
                for (int i = 0; i < cellBlockBufferSize; ++i) {
                    responseBufs[i + 1] = cellBlock.get(i);
                }
            }
            bc = new BufferChain(responseBufs);
        }
        catch (IOException e) {
            RpcServer.LOG.warn("Exception while creating response " + e);
        }
        this.response = bc;
        if (this.rpcCallback != null) {
            try {
                this.rpcCallback.run();
            }
            catch (Exception e) {
                RpcServer.LOG.warn("Exception while running the Rpc Callback.", (Throwable)e);
            }
        }
    }

    static void setExceptionResponse(Throwable t, String errorMsg, RPCProtos.ResponseHeader.Builder headerBuilder) {
        RPCProtos.ExceptionResponse.Builder exceptionBuilder = RPCProtos.ExceptionResponse.newBuilder();
        exceptionBuilder.setExceptionClassName(t.getClass().getName());
        exceptionBuilder.setStackTrace(errorMsg);
        exceptionBuilder.setDoNotRetry(t instanceof DoNotRetryIOException);
        if (t instanceof RegionMovedException) {
            RegionMovedException rme = (RegionMovedException)t;
            exceptionBuilder.setHostname(rme.getHostname());
            exceptionBuilder.setPort(rme.getPort());
        }
        headerBuilder.setException(exceptionBuilder.build());
    }

    static ByteBuffer createHeaderAndMessageBytes(Message result, Message header, int cellBlockSize, List<ByteBuffer> cellBlock) throws IOException {
        ByteBuffer possiblePBBuf = cellBlockSize > 0 ? cellBlock.get(cellBlock.size() - 1) : null;
        int headerSerializedSize = 0;
        int resultSerializedSize = 0;
        int headerVintSize = 0;
        int resultVintSize = 0;
        if (header != null) {
            headerSerializedSize = header.getSerializedSize();
            headerVintSize = CodedOutputStream.computeUInt32SizeNoTag(headerSerializedSize);
        }
        if (result != null) {
            resultSerializedSize = result.getSerializedSize();
            resultVintSize = CodedOutputStream.computeUInt32SizeNoTag(resultSerializedSize);
        }
        int totalSize = headerSerializedSize + headerVintSize + (resultSerializedSize + resultVintSize) + cellBlockSize;
        int totalPBSize = headerSerializedSize + headerVintSize + resultSerializedSize + resultVintSize + 4;
        if (possiblePBBuf != null && possiblePBBuf.limit() + totalPBSize <= possiblePBBuf.capacity()) {
            ByteBuffer pbBuf = possiblePBBuf.duplicate();
            int limit = pbBuf.limit();
            pbBuf.position(limit);
            pbBuf.limit(totalPBSize + limit);
            pbBuf.mark();
            ServerCall.writeToCOS(result, header, totalSize, pbBuf);
            pbBuf.reset();
            return pbBuf;
        }
        return ServerCall.createHeaderAndMessageBytes(result, header, totalSize, totalPBSize);
    }

    private static void writeToCOS(Message result, Message header, int totalSize, ByteBuffer pbBuf) throws IOException {
        ByteBufferUtils.putInt(pbBuf, totalSize);
        CodedOutputStream cos = CodedOutputStream.newInstance(pbBuf);
        if (header != null) {
            cos.writeMessageNoTag(header);
        }
        if (result != null) {
            cos.writeMessageNoTag(result);
        }
        cos.flush();
        cos.checkNoSpaceLeft();
    }

    private static ByteBuffer createHeaderAndMessageBytes(Message result, Message header, int totalSize, int totalPBSize) throws IOException {
        ByteBuffer pbBuf = ByteBuffer.allocate(totalPBSize);
        ServerCall.writeToCOS(result, header, totalSize, pbBuf);
        pbBuf.flip();
        return pbBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferChain wrapWithSasl(BufferChain bc) throws IOException {
        byte[] token;
        Object object;
        if (!((ServerRpcConnection)this.connection).useSasl) {
            return bc;
        }
        byte[] responseBytes = bc.getBytes();
        if (((ServerRpcConnection)this.connection).useCryptoAesWrap) {
            object = ((ServerRpcConnection)this.connection).cryptoAES;
            synchronized (object) {
                token = ((ServerRpcConnection)this.connection).cryptoAES.wrap(responseBytes, 0, responseBytes.length);
            }
        }
        object = ((ServerRpcConnection)this.connection).saslServer;
        synchronized (object) {
            token = ((ServerRpcConnection)this.connection).saslServer.wrap(responseBytes, 0, responseBytes.length);
        }
        if (RpcServer.LOG.isTraceEnabled()) {
            RpcServer.LOG.trace("Adding saslServer wrapped token of size " + token.length + " as call response.");
        }
        ByteBuffer[] responseBufs = new ByteBuffer[]{ByteBuffer.wrap(Bytes.toBytes(token.length)), ByteBuffer.wrap(token)};
        return new BufferChain(responseBufs);
    }

    @Override
    public long disconnectSince() {
        if (!((ServerRpcConnection)this.connection).isConnectionOpen()) {
            return System.currentTimeMillis() - this.receiveTime;
        }
        return -1L;
    }

    @Override
    public boolean isClientCellBlockSupported() {
        return this.connection != null && ((ServerRpcConnection)this.connection).codec != null;
    }

    @Override
    public long getResponseCellSize() {
        return this.responseCellSize;
    }

    @Override
    public void incrementResponseCellSize(long cellSize) {
        this.responseCellSize += cellSize;
    }

    @Override
    public long getResponseBlockSize() {
        return this.responseBlockSize;
    }

    @Override
    public void incrementResponseBlockSize(long blockSize) {
        this.responseBlockSize += blockSize;
    }

    @Override
    public long getResponseExceptionSize() {
        return this.exceptionSize;
    }

    @Override
    public void incrementResponseExceptionSize(long exSize) {
        this.exceptionSize += exSize;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public Optional<User> getRequestUser() {
        return Optional.ofNullable(this.user);
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public HBaseProtos.VersionInfo getClientVersionInfo() {
        return ((ServerRpcConnection)this.connection).getVersionInfo();
    }

    @Override
    public synchronized void setCallBack(RpcCallback callback) {
        this.rpcCallback = callback;
    }

    @Override
    public boolean isRetryImmediatelySupported() {
        return this.retryImmediatelySupported;
    }

    @Override
    public BlockingService getService() {
        return this.service;
    }

    @Override
    public Descriptors.MethodDescriptor getMethod() {
        return this.md;
    }

    @Override
    public Message getParam() {
        return this.param;
    }

    @Override
    public CellScanner getCellScanner() {
        return this.cellScanner;
    }

    @Override
    public long getReceiveTime() {
        return this.receiveTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(long t) {
        this.startTime = t;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public int getRemotePort() {
        return ((ServerRpcConnection)this.connection).getRemotePort();
    }

    @Override
    public synchronized BufferChain getResponse() {
        if (((ServerRpcConnection)this.connection).useWrap) {
            try {
                return this.wrapWithSasl(this.response);
            }
            catch (IOException e) {
                RpcServer.LOG.warn("Exception while creating response " + e);
                return null;
            }
        }
        return this.response;
    }
}

