/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.hash.Hashing;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ScannerIdGenerator {
    private final long serverNameHash;
    private final AtomicInteger scannerIdGen = new AtomicInteger(0);

    public ScannerIdGenerator(ServerName serverName) {
        long hash = Hashing.murmur3_32().hashString(serverName.toString(), StandardCharsets.UTF_8).asInt();
        this.serverNameHash = hash << 32;
    }

    public long generateNewScannerId() {
        return (long)this.scannerIdGen.incrementAndGet() & 0xFFFFFFFFL | this.serverNameHash;
    }

    public static void main(String[] args) {
        ScannerIdGenerator sig = new ScannerIdGenerator(ServerName.valueOf("a.example.org,1234,5678"));
        for (int i = 0; i < 10; ++i) {
            System.out.println(sig.generateNewScannerId());
        }
    }
}

