/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.org.apache.hadoop.hbase.Server;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hudi.org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hudi.org.apache.hadoop.hbase.coordination.SplitLogWorkerCoordination;
import org.apache.hudi.org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hudi.org.apache.hadoop.hbase.executor.EventType;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hudi.org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
public class WALSplitterHandler
extends EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WALSplitterHandler.class);
    private final ServerName serverName;
    private final CancelableProgressable reporter;
    private final AtomicInteger inProgressTasks;
    private final SplitLogWorker.TaskExecutor splitTaskExecutor;
    private final SplitLogWorkerCoordination.SplitTaskDetails splitTaskDetails;
    private final SplitLogWorkerCoordination coordination;

    public WALSplitterHandler(Server server, SplitLogWorkerCoordination coordination, SplitLogWorkerCoordination.SplitTaskDetails splitDetails, CancelableProgressable reporter, AtomicInteger inProgressTasks, SplitLogWorker.TaskExecutor splitTaskExecutor) {
        super(server, EventType.RS_LOG_REPLAY);
        this.splitTaskDetails = splitDetails;
        this.coordination = coordination;
        this.reporter = reporter;
        this.inProgressTasks = inProgressTasks;
        this.inProgressTasks.incrementAndGet();
        this.serverName = server.getServerName();
        this.splitTaskExecutor = splitTaskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process() throws IOException {
        long startTime = System.currentTimeMillis();
        SplitLogWorker.TaskExecutor.Status status = null;
        try {
            status = this.splitTaskExecutor.exec(this.splitTaskDetails.getWALFile(), this.reporter);
            switch (status) {
                case DONE: {
                    this.coordination.endTask(new SplitLogTask.Done(this.serverName), SplitLogCounters.tot_wkr_task_done, this.splitTaskDetails);
                    return;
                }
                case PREEMPTED: {
                    SplitLogCounters.tot_wkr_preempt_task.increment();
                    LOG.warn("task execution preempted " + this.splitTaskDetails.getWALFile());
                    return;
                }
                case ERR: {
                    if (this.server != null && !this.server.isStopped()) {
                        this.coordination.endTask(new SplitLogTask.Err(this.serverName), SplitLogCounters.tot_wkr_task_err, this.splitTaskDetails);
                        return;
                    }
                }
                case RESIGNED: {
                    if (this.server != null && this.server.isStopped()) {
                        LOG.info("task execution interrupted because worker is exiting " + this.splitTaskDetails.toString());
                    }
                    this.coordination.endTask(new SplitLogTask.Resigned(this.serverName), SplitLogCounters.tot_wkr_task_resigned, this.splitTaskDetails);
                    return;
                }
            }
            return;
        }
        finally {
            LOG.info("Worker " + this.serverName + " done with task " + this.splitTaskDetails.toString() + " in " + (System.currentTimeMillis() - startTime) + "ms. Status = " + (Object)((Object)status));
            this.inProgressTasks.decrementAndGet();
        }
    }
}

