/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.jetty.client;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hudi.org.apache.jetty.client.ConnectionPool;
import org.apache.hudi.org.apache.jetty.client.HttpClient;
import org.apache.hudi.org.apache.jetty.client.HttpExchange;
import org.apache.hudi.org.apache.jetty.client.HttpRequest;
import org.apache.hudi.org.apache.jetty.client.Origin;
import org.apache.hudi.org.apache.jetty.client.ProxyConfiguration;
import org.apache.hudi.org.apache.jetty.client.RequestNotifier;
import org.apache.hudi.org.apache.jetty.client.ResponseNotifier;
import org.apache.hudi.org.apache.jetty.client.SendFailure;
import org.apache.hudi.org.apache.jetty.client.api.Connection;
import org.apache.hudi.org.apache.jetty.client.api.Destination;
import org.apache.hudi.org.apache.jetty.client.api.Response;
import org.apache.hudi.org.apache.jetty.http.HttpField;
import org.apache.hudi.org.apache.jetty.http.HttpHeader;
import org.apache.hudi.org.apache.jetty.io.ClientConnectionFactory;
import org.apache.hudi.org.apache.jetty.io.CyclicTimeout;
import org.apache.hudi.org.apache.jetty.util.BlockingArrayQueue;
import org.apache.hudi.org.apache.jetty.util.Callback;
import org.apache.hudi.org.apache.jetty.util.HostPort;
import org.apache.hudi.org.apache.jetty.util.Promise;
import org.apache.hudi.org.apache.jetty.util.annotation.ManagedAttribute;
import org.apache.hudi.org.apache.jetty.util.annotation.ManagedObject;
import org.apache.hudi.org.apache.jetty.util.component.ContainerLifeCycle;
import org.apache.hudi.org.apache.jetty.util.component.Dumpable;
import org.apache.hudi.org.apache.jetty.util.component.DumpableCollection;
import org.apache.hudi.org.apache.jetty.util.log.Log;
import org.apache.hudi.org.apache.jetty.util.log.Logger;
import org.apache.hudi.org.apache.jetty.util.thread.Scheduler;
import org.apache.hudi.org.apache.jetty.util.thread.Sweeper;

@ManagedObject
public abstract class HttpDestination
extends ContainerLifeCycle
implements Destination,
Closeable,
Callback,
Dumpable {
    protected static final Logger LOG = Log.getLogger(HttpDestination.class);
    private final HttpClient client;
    private final Origin origin;
    private final Queue<HttpExchange> exchanges;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private final ProxyConfiguration.Proxy proxy;
    private final ClientConnectionFactory connectionFactory;
    private final HttpField hostField;
    private final TimeoutTask timeout;
    private ConnectionPool connectionPool;

    public HttpDestination(HttpClient client, Origin origin) {
        this.client = client;
        this.origin = origin;
        this.exchanges = this.newExchangeQueue(client);
        this.requestNotifier = new RequestNotifier(client);
        this.responseNotifier = new ResponseNotifier();
        this.timeout = new TimeoutTask(client.getScheduler());
        ProxyConfiguration proxyConfig = client.getProxyConfiguration();
        this.proxy = proxyConfig.match(origin);
        ClientConnectionFactory connectionFactory = client.getTransport();
        if (this.proxy != null) {
            connectionFactory = this.proxy.newClientConnectionFactory(connectionFactory);
            if (this.proxy.isSecure()) {
                connectionFactory = this.newSslClientConnectionFactory(connectionFactory);
            }
        } else if (this.isSecure()) {
            connectionFactory = this.newSslClientConnectionFactory(connectionFactory);
        }
        this.connectionFactory = connectionFactory;
        String host = HostPort.normalizeHost(this.getHost());
        if (!client.isDefaultPort(this.getScheme(), this.getPort())) {
            host = host + ":" + this.getPort();
        }
        this.hostField = new HttpField(HttpHeader.HOST, host);
    }

    @Override
    protected void doStart() throws Exception {
        this.connectionPool = this.newConnectionPool(this.client);
        this.addBean(this.connectionPool);
        super.doStart();
        Sweeper sweeper = this.client.getBean(Sweeper.class);
        if (sweeper != null && this.connectionPool instanceof Sweeper.Sweepable) {
            sweeper.offer((Sweeper.Sweepable)((Object)this.connectionPool));
        }
    }

    @Override
    protected void doStop() throws Exception {
        Sweeper sweeper = this.client.getBean(Sweeper.class);
        if (sweeper != null && this.connectionPool instanceof Sweeper.Sweepable) {
            sweeper.remove((Sweeper.Sweepable)((Object)this.connectionPool));
        }
        super.doStop();
        this.removeBean(this.connectionPool);
    }

    protected ConnectionPool newConnectionPool(HttpClient client) {
        return client.getTransport().getConnectionPoolFactory().newConnectionPool(this);
    }

    protected Queue<HttpExchange> newExchangeQueue(HttpClient client) {
        return new BlockingArrayQueue<HttpExchange>(client.getMaxRequestsQueuedPerDestination());
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return this.client.newSslClientConnectionFactory(connectionFactory);
    }

    public boolean isSecure() {
        return HttpClient.isSchemeSecure(this.getScheme());
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Queue<HttpExchange> getHttpExchanges() {
        return this.exchanges;
    }

    public RequestNotifier getRequestNotifier() {
        return this.requestNotifier;
    }

    public ResponseNotifier getResponseNotifier() {
        return this.responseNotifier;
    }

    public ProxyConfiguration.Proxy getProxy() {
        return this.proxy;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    @ManagedAttribute(value="The destination scheme", readonly=true)
    public String getScheme() {
        return this.origin.getScheme();
    }

    @Override
    @ManagedAttribute(value="The destination host", readonly=true)
    public String getHost() {
        return this.origin.getAddress().getHost();
    }

    @Override
    @ManagedAttribute(value="The destination port", readonly=true)
    public int getPort() {
        return this.origin.getAddress().getPort();
    }

    @ManagedAttribute(value="The number of queued requests", readonly=true)
    public int getQueuedRequestCount() {
        return this.exchanges.size();
    }

    public Origin.Address getConnectAddress() {
        return this.proxy == null ? this.origin.getAddress() : this.proxy.getAddress();
    }

    public HttpField getHostField() {
        return this.hostField;
    }

    @ManagedAttribute(value="The connection pool", readonly=true)
    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public void succeeded() {
        this.send();
    }

    @Override
    public void failed(Throwable x) {
        this.abort(x);
    }

    protected void send(HttpRequest request, List<Response.ResponseListener> listeners) {
        if (!this.getScheme().equalsIgnoreCase(request.getScheme())) {
            throw new IllegalArgumentException("Invalid request scheme " + request.getScheme() + " for destination " + this);
        }
        if (!this.getHost().equalsIgnoreCase(request.getHost())) {
            throw new IllegalArgumentException("Invalid request host " + request.getHost() + " for destination " + this);
        }
        int port = request.getPort();
        if (port >= 0 && this.getPort() != port) {
            throw new IllegalArgumentException("Invalid request port " + port + " for destination " + this);
        }
        this.send(new HttpExchange(this, request, listeners));
    }

    public void send(HttpExchange exchange) {
        HttpRequest request = exchange.getRequest();
        if (this.client.isRunning()) {
            if (this.enqueue(this.exchanges, exchange)) {
                long expiresAt = request.getTimeoutAt();
                if (expiresAt != -1L) {
                    this.timeout.schedule(expiresAt);
                }
                if (!this.client.isRunning() && this.exchanges.remove(exchange)) {
                    request.abort(new RejectedExecutionException(this.client + " is stopping"));
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Queued {} for {}", request, this);
                    }
                    this.requestNotifier.notifyQueued(request);
                    this.send();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Max queue size {} exceeded by {} for {}", this.client.getMaxRequestsQueuedPerDestination(), request, this);
                }
                request.abort(new RejectedExecutionException("Max requests queued per destination " + this.client.getMaxRequestsQueuedPerDestination() + " exceeded for " + this));
            }
        } else {
            request.abort(new RejectedExecutionException(this.client + " is stopped"));
        }
    }

    protected boolean enqueue(Queue<HttpExchange> queue, HttpExchange exchange) {
        return queue.offer(exchange);
    }

    public void send() {
        if (this.getHttpExchanges().isEmpty()) {
            return;
        }
        this.process();
    }

    private void process() {
        boolean proceed;
        Connection connection;
        while ((connection = this.connectionPool.acquire()) != null && (proceed = this.process(connection))) {
        }
    }

    public boolean process(Connection connection) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing exchange {} on {} of {}", exchange, connection, this);
        }
        if (exchange == null) {
            if (!this.connectionPool.release(connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} is stopping", client);
                }
                connection.close();
            }
            return false;
        }
        HttpRequest request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", exchange, cause);
            }
            if (!this.connectionPool.release(connection)) {
                connection.close();
            }
            exchange.abort(cause);
        } else {
            SendFailure result = this.send(connection, exchange);
            if (result != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send failed {} for {}", result, exchange);
                }
                if (result.retry) {
                    this.send(exchange);
                } else {
                    request.abort(result.failure);
                }
            }
        }
        return this.getHttpExchanges().peek() != null;
    }

    protected abstract SendFailure send(Connection var1, HttpExchange var2);

    @Override
    public void newConnection(Promise<Connection> promise) {
        this.createConnection(promise);
    }

    protected void createConnection(Promise<Connection> promise) {
        this.client.newConnection(this, promise);
    }

    public boolean remove(HttpExchange exchange) {
        return this.exchanges.remove(exchange);
    }

    @Override
    public void close() {
        this.abort(new AsynchronousCloseException());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closed {}", this);
        }
        this.connectionPool.close();
        this.timeout.destroy();
    }

    public void release(Connection connection) {
        HttpClient client;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", connection);
        }
        if ((client = this.getHttpClient()).isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                if (this.connectionPool.release(connection)) {
                    this.send();
                } else {
                    connection.close();
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Released explicit {}", connection);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is stopped", client);
            }
            connection.close();
        }
    }

    public boolean remove(Connection connection) {
        return this.connectionPool.remove(connection);
    }

    public void close(Connection connection) {
        boolean removed = this.remove(connection);
        if (this.getHttpExchanges().isEmpty()) {
            this.tryRemoveIdleDestination();
        } else if (removed) {
            this.process();
        }
    }

    public void abort(Throwable cause) {
        for (HttpExchange exchange : new ArrayList<HttpExchange>(this.exchanges)) {
            exchange.getRequest().abort(cause);
        }
        if (this.exchanges.isEmpty()) {
            this.tryRemoveIdleDestination();
        }
    }

    private void tryRemoveIdleDestination() {
        if (this.getHttpClient().isRemoveIdleDestinations() && this.connectionPool.isEmpty()) {
            this.getHttpClient().removeDestination(this);
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new DumpableCollection("exchanges", this.exchanges));
    }

    public String asString() {
        return this.origin.asString();
    }

    @Override
    public String toString() {
        return String.format("%s[%s]@%x%s,queue=%d,pool=%s", HttpDestination.class.getSimpleName(), this.asString(), this.hashCode(), this.proxy == null ? "" : "(via " + this.proxy + ")", this.exchanges.size(), this.connectionPool);
    }

    private class TimeoutTask
    extends CyclicTimeout {
        private final AtomicLong nextTimeout;

        private TimeoutTask(Scheduler scheduler) {
            super(scheduler);
            this.nextTimeout = new AtomicLong(Long.MAX_VALUE);
        }

        @Override
        public void onTimeoutExpired() {
            this.nextTimeout.set(Long.MAX_VALUE);
            long now = System.nanoTime();
            long nextExpiresAt = Long.MAX_VALUE;
            for (HttpExchange exchange : HttpDestination.this.exchanges) {
                HttpRequest request = exchange.getRequest();
                long expiresAt = request.getTimeoutAt();
                if (expiresAt == -1L) continue;
                if (expiresAt <= now) {
                    request.abort(new TimeoutException("Total timeout " + request.getTimeout() + " ms elapsed"));
                    continue;
                }
                if (expiresAt >= nextExpiresAt) continue;
                nextExpiresAt = expiresAt;
            }
            if (nextExpiresAt < Long.MAX_VALUE && HttpDestination.this.client.isRunning()) {
                this.schedule(nextExpiresAt);
            }
        }

        private void schedule(long expiresAt) {
            long timeoutAt = this.nextTimeout.getAndUpdate(e -> Math.min(e, expiresAt));
            if (timeoutAt != expiresAt) {
                long delay = expiresAt - System.nanoTime();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduled timeout in {} ms", TimeUnit.NANOSECONDS.toMillis(delay));
                }
                if (delay <= 0L) {
                    this.onTimeoutExpired();
                } else {
                    this.schedule(delay, TimeUnit.NANOSECONDS);
                }
            }
        }
    }
}

