/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.jetty.websocket.server;

import java.io.IOException;
import org.apache.hudi.javax.servlet.ServletException;
import org.apache.hudi.javax.servlet.http.HttpServletRequest;
import org.apache.hudi.javax.servlet.http.HttpServletResponse;
import org.apache.hudi.org.apache.jetty.io.ByteBufferPool;
import org.apache.hudi.org.apache.jetty.io.MappedByteBufferPool;
import org.apache.hudi.org.apache.jetty.server.Request;
import org.apache.hudi.org.apache.jetty.server.handler.HandlerWrapper;
import org.apache.hudi.org.apache.jetty.websocket.api.WebSocketBehavior;
import org.apache.hudi.org.apache.jetty.websocket.api.WebSocketPolicy;
import org.apache.hudi.org.apache.jetty.websocket.server.WebSocketServerFactory;
import org.apache.hudi.org.apache.jetty.websocket.servlet.WebSocketServletFactory;

public abstract class WebSocketHandler
extends HandlerWrapper {
    private final ByteBufferPool bufferPool;
    private WebSocketServletFactory webSocketFactory;

    public WebSocketHandler() {
        this(new MappedByteBufferPool());
    }

    public WebSocketHandler(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public abstract void configure(WebSocketServletFactory var1);

    public void configurePolicy(WebSocketPolicy policy) {
    }

    @Override
    protected void doStart() throws Exception {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        this.configurePolicy(policy);
        this.webSocketFactory = new WebSocketServerFactory(policy, this.getServer().getThreadPool(), this.bufferPool);
        this.addBean(this.webSocketFactory);
        this.configure(this.webSocketFactory);
        super.doStart();
    }

    public WebSocketServletFactory getWebSocketFactory() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Not Started yet");
        }
        return this.webSocketFactory;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.webSocketFactory.isUpgradeRequest(request, response)) {
            if (this.webSocketFactory.acceptWebSocket(request, response)) {
                baseRequest.setHandled(true);
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }

    public static class Simple
    extends WebSocketHandler {
        private Class<?> websocketPojo;

        public Simple(Class<?> websocketClass) {
            this.websocketPojo = websocketClass;
        }

        @Override
        public void configure(WebSocketServletFactory factory) {
            factory.register(this.websocketPojo);
        }
    }
}

