/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.index;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieIndexPartitionInfo;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ScheduleIndexActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieIndexPlan>> {
    private static final Logger LOG = LogManager.getLogger(ScheduleIndexActionExecutor.class);
    private static final Integer INDEX_PLAN_VERSION_1;
    private static final Integer LATEST_INDEX_PLAN_VERSION;
    private final List<MetadataPartitionType> partitionIndexTypes;
    private final TransactionManager txnManager;

    public ScheduleIndexActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, List<MetadataPartitionType> partitionIndexTypes) {
        super(context, config, table, instantTime);
        this.partitionIndexTypes = partitionIndexTypes;
        this.txnManager = new TransactionManager(config, table.getMetaClient().getFs());
    }

    @Override
    public Option<HoodieIndexPlan> execute() {
        this.validateBeforeScheduling();
        Set<String> indexesInflightOrCompleted = HoodieTableMetadataUtil.getInflightAndCompletedMetadataPartitions(this.table.getMetaClient().getTableConfig());
        Set requestedPartitions = this.partitionIndexTypes.stream().map(MetadataPartitionType::getPartitionPath).collect(Collectors.toSet());
        requestedPartitions.removeAll(indexesInflightOrCompleted);
        if (requestedPartitions.isEmpty()) {
            LOG.error((Object)("All requested index types are inflight or completed: " + this.partitionIndexTypes));
            return Option.empty();
        }
        LOG.warn((Object)String.format("Following partitions already exist or inflight: %s. Going to schedule indexing of only these partitions: %s", indexesInflightOrCompleted, requestedPartitions));
        List<MetadataPartitionType> finalPartitionsToIndex = this.partitionIndexTypes.stream().filter(p -> requestedPartitions.contains(p.getPartitionPath())).collect(Collectors.toList());
        HoodieInstant indexInstant = HoodieTimeline.getIndexRequestedInstant(this.instantTime);
        try {
            this.txnManager.beginTransaction(Option.of(indexInstant), Option.empty());
            Option<HoodieInstant> indexUptoInstant = this.table.getActiveTimeline().getContiguousCompletedWriteTimeline().lastInstant();
            if (indexUptoInstant.isPresent()) {
                HoodieTableMetadataWriter metadataWriter = this.table.getMetadataWriter(this.instantTime).orElseThrow(() -> new HoodieIndexException(String.format("Could not get metadata writer to initialize filegroups for indexing for instant: %s", this.instantTime)));
                if (!((MetadataPartitionType)((Object)finalPartitionsToIndex.get(0))).getPartitionPath().equals(MetadataPartitionType.FILES.getPartitionPath())) {
                    metadataWriter.initializeMetadataPartitions(this.table.getMetaClient(), finalPartitionsToIndex, indexInstant.getTimestamp());
                }
                List<HoodieIndexPartitionInfo> indexPartitionInfos = finalPartitionsToIndex.stream().map(p -> new HoodieIndexPartitionInfo(LATEST_INDEX_PLAN_VERSION, p.getPartitionPath(), ((HoodieInstant)indexUptoInstant.get()).getTimestamp())).collect(Collectors.toList());
                HoodieIndexPlan indexPlan = new HoodieIndexPlan(LATEST_INDEX_PLAN_VERSION, indexPartitionInfos);
                this.table.getActiveTimeline().saveToPendingIndexAction(indexInstant, TimelineMetadataUtils.serializeIndexPlan(indexPlan));
                Option<HoodieIndexPlan> option = Option.of(indexPlan);
                return option;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Could not initialize file groups", (Throwable)e);
            this.abort(indexInstant);
            throw new HoodieIOException(e.getMessage(), e);
        }
        finally {
            this.txnManager.endTransaction(Option.of(indexInstant));
        }
        return Option.empty();
    }

    private void validateBeforeScheduling() {
        if (!EnumSet.allOf(MetadataPartitionType.class).containsAll(this.partitionIndexTypes)) {
            throw new HoodieIndexException("Not all index types are valid: " + this.partitionIndexTypes);
        }
        if (!this.config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl() || StringUtils.isNullOrEmpty(this.config.getLockProviderClass())) {
            throw new HoodieIndexException(String.format("Need to set %s as %s and configure lock provider class", HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name()));
        }
    }

    private void abort(HoodieInstant indexInstant) {
        this.partitionIndexTypes.forEach(partitionType -> {
            if (HoodieTableMetadataUtil.metadataPartitionExists(this.table.getMetaClient().getBasePath(), this.context, partitionType)) {
                HoodieTableMetadataUtil.deleteMetadataPartition(this.table.getMetaClient().getBasePath(), this.context, partitionType);
            }
        });
        this.table.getMetaClient().reloadActiveTimeline().deleteInstantFileIfExists(indexInstant);
    }

    static {
        LATEST_INDEX_PLAN_VERSION = INDEX_PLAN_VERSION_1 = Integer.valueOf(1);
    }
}

