/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import com.esotericsoftware.minlog.Log;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.StorageSchemes;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.DirectWriteMarkers;
import org.apache.hudi.table.marker.TimelineServerBasedWriteMarkers;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class WriteMarkersFactory {
    private static final Logger LOG = LogManager.getLogger(WriteMarkersFactory.class);

    public static WriteMarkers get(MarkerType markerType, HoodieTable table, String instantTime) {
        LOG.debug((Object)("Instantiated MarkerFiles with marker type: " + markerType.toString()));
        switch (markerType) {
            case DIRECT: {
                return new DirectWriteMarkers(table, instantTime);
            }
            case TIMELINE_SERVER_BASED: {
                if (!table.getConfig().isEmbeddedTimelineServerEnabled()) {
                    Log.warn((String)"Timeline-server-based markers are configured as the marker type but embedded timeline server is not enabled.  Falling back to direct markers.");
                    return new DirectWriteMarkers(table, instantTime);
                }
                String basePath = table.getMetaClient().getBasePath();
                if (StorageSchemes.HDFS.getScheme().equals(FSUtils.getFs(basePath, table.getContext().getHadoopConf().newCopy()).getScheme())) {
                    Log.warn((String)("Timeline-server-based markers are not supported for HDFS: base path " + basePath + ".  Falling back to direct markers."));
                    return new DirectWriteMarkers(table, instantTime);
                }
                return new TimelineServerBasedWriteMarkers(table, instantTime);
            }
        }
        throw new HoodieException("The marker type \"" + markerType.name() + "\" is not supported.");
    }
}

