/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.HoodieHadoopFSUtils$;
import org.apache.spark.execution.datasources.HoodieInMemoryFileIndex$;
import org.apache.spark.execution.datasources.PathFilterWrapper;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001\u0002\b\u0010\u0001iA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!1\u0006A!A!\u0002\u00139\u0006\"\u0002.\u0001\t\u0003Y\u0006\"B2\u0001\t\u0003\"\u0007\"\u0002:\u0001\t#\u0019xaBA\f\u001f!\u0005\u0011\u0011\u0004\u0004\u0007\u001d=A\t!a\u0007\t\riSA\u0011AA\u0012\u0011\u001d\t)C\u0003C\u0001\u0003OA\u0011\"a\f\u000b#\u0003%\t!!\r\u0003/!{w\u000eZ5f\u0013:lU-\\8ss\u001aKG.Z%oI\u0016D(B\u0001\t\u0012\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005I\u0019\u0012!C3yK\u000e,H/[8o\u0015\t!R#A\u0003ta\u0006\u00148N\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0011\u000e\u0003uQ!\u0001\u0005\u0010\u000b\u0005Iy\"B\u0001\u0011\u0014\u0003\r\u0019\u0018\u000f\\\u0005\u0003Eu\u0011\u0011#\u00138NK6|'/\u001f$jY\u0016Le\u000eZ3y\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t)c%D\u0001 \u0013\t9sD\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\ns_>$\b+\u0019;igN\u0003XmY5gS\u0016$\u0007c\u0001\u00165o9\u00111&\r\b\u0003Y=j\u0011!\f\u0006\u0003]e\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005I\u001a\u0014a\u00029bG.\fw-\u001a\u0006\u0002a%\u0011QG\u000e\u0002\u0004'\u0016\f(B\u0001\u001a4!\tAT(D\u0001:\u0015\tQ4(\u0001\u0002gg*\u0011A(F\u0001\u0007Q\u0006$wn\u001c9\n\u0005yJ$\u0001\u0002)bi\"\f!\u0002]1sC6,G/\u001a:t!\u0011\tU\t\u0013%\u000f\u0005\t\u001b\u0005C\u0001\u00174\u0013\t!5'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u00131!T1q\u0015\t!5\u0007\u0005\u0002B\u0013&\u0011!j\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002'U\u001cXM]*qK\u000eLg-[3e'\u000eDW-\\1\u0011\u00075s\u0005+D\u00014\u0013\ty5G\u0001\u0004PaRLwN\u001c\t\u0003#Rk\u0011A\u0015\u0006\u0003'~\tQ\u0001^=qKNL!!\u0016*\u0003\u0015M#(/^2u)f\u0004X-A\bgS2,7\u000b^1ukN\u001c\u0015m\u00195f!\ta\u0002,\u0003\u0002Z;\tya)\u001b7f'R\fG/^:DC\u000eDW-\u0001\u0004=S:LGO\u0010\u000b\u00079z{\u0006-\u00192\u0011\u0005u\u0003Q\"A\b\t\u000b\r2\u0001\u0019\u0001\u0013\t\u000b!2\u0001\u0019A\u0015\t\u000b}2\u0001\u0019\u0001!\t\u000b-3\u0001\u0019\u0001'\t\u000fY3\u0001\u0013!a\u0001/\u0006iA.[:u\u0019\u0016\fgMR5mKN$\"!\u001a9\u0011\u0007\u0019\\W.D\u0001h\u0015\tA\u0017.A\u0004nkR\f'\r\\3\u000b\u0005)\u001c\u0014AC2pY2,7\r^5p]&\u0011An\u001a\u0002\u000e\u0019&t7.\u001a3ICND7+\u001a;\u0011\u0005ar\u0017BA8:\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006c\u001e\u0001\r!K\u0001\u0006a\u0006$\bn]\u0001\u0012EVd7\u000eT5ti2+\u0017M\u001a$jY\u0016\u001cHC\u0002;zuz\f9\u0001E\u0002+iU\u0004B!\u0014<8q&\u0011qo\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007)\"T\u000eC\u0003$\u0011\u0001\u0007A\u0005C\u0003r\u0011\u0001\u00071\u0010E\u0002gy^J!!`4\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\u0007\u007f\"\u0001\r!!\u0001\u0002\r\u0019LG\u000e^3s!\rA\u00141A\u0005\u0004\u0003\u000bI$A\u0003)bi\"4\u0015\u000e\u001c;fe\"9\u0011\u0011\u0002\u0005A\u0002\u0005-\u0011A\u00035bI>|\u0007oQ8oMB!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012m\nAaY8oM&!\u0011QCA\b\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u00069\u0002j\\8eS\u0016Le.T3n_JLh)\u001b7f\u0013:$W\r\u001f\t\u0003;*\u00192ACA\u000f!\ri\u0015qD\u0005\u0004\u0003C\u0019$AB!osJ+g\r\u0006\u0002\u0002\u001a\u000511M]3bi\u0016$R\u0001XA\u0015\u0003WAQa\t\u0007A\u0002\u0011Ba!!\f\r\u0001\u0004I\u0013\u0001D4m_\n\u0014W\r\u001a)bi\"\u001c\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u00024)\u001aq+!\u000e,\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00114\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\nYDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class HoodieInMemoryFileIndex
extends InMemoryFileIndex {
    private final SparkSession sparkSession;
    private final FileStatusCache fileStatusCache;

    public static FileStatusCache $lessinit$greater$default$5() {
        return HoodieInMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    public static HoodieInMemoryFileIndex create(SparkSession sparkSession, Seq<Path> seq) {
        return HoodieInMemoryFileIndex$.MODULE$.create(sparkSession, seq);
    }

    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        long startTime = System.nanoTime();
        LinkedHashSet output = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1 & Serializable & scala.Serializable)path -> {
            HoodieInMemoryFileIndex.$anonfun$listLeafFiles$1(this, output, pathsToFetch, path);
            return BoxedUnit.UNIT;
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = this.bulkListLeafFiles(this.sparkSession, (ArrayBuffer<Path>)pathsToFetch, filter, this.hadoopConf());
        discovered.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            Seq leafFiles = (Seq)tuple2._2();
            HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
            $this.fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
            LinkedHashSet linkedHashSet = (LinkedHashSet)output.$plus$plus$eq((TraversableOnce)leafFiles);
            return linkedHashSet;
        });
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("It took ").append((System.nanoTime() - startTime) / 1000000L).append(" ms to list leaf files").append(" for ").append(paths.length()).append(" paths.").toString());
        return output;
    }

    public Seq<Tuple2<Path, Seq<FileStatus>>> bulkListLeafFiles(SparkSession sparkSession, ArrayBuffer<Path> paths, PathFilter filter, Configuration hadoopConf) {
        return HoodieHadoopFSUtils$.MODULE$.parallelListLeafFiles(sparkSession.sparkContext(), (Seq<Path>)paths, hadoopConf, new PathFilterWrapper(filter), sparkSession.sessionState().conf().ignoreMissingFiles(), true, sparkSession.sessionState().conf().parallelPartitionDiscoveryThreshold(), sparkSession.sessionState().conf().parallelPartitionDiscoveryParallelism());
    }

    public static final /* synthetic */ void $anonfun$listLeafFiles$1(HoodieInMemoryFileIndex $this, LinkedHashSet output$1, ArrayBuffer pathsToFetch$1, Path path) {
        ArrayBuffer arrayBuffer;
        Option option = $this.fileStatusCache.getLeafFiles(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            FileStatus[] files = (FileStatus[])some.value();
            HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
            arrayBuffer = (AbstractIterable)output$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)));
        } else if (None$.MODULE$.equals(option)) {
            arrayBuffer = pathsToFetch$1.$plus$eq((Object)path);
        } else {
            throw new MatchError((Object)option);
        }
    }

    public HoodieInMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache) {
        this.sparkSession = sparkSession;
        this.fileStatusCache = fileStatusCache;
        super(sparkSession, rootPathsSpecified, parameters, userSpecifiedSchema, fileStatusCache);
    }
}

