/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001\u0002\u00180\u0001qB\u0001B\u000e\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0015\"Aq\n\u0001BA\u0002\u0013\u0005\u0001\u000b\u0003\u0005V\u0001\t\u0005\r\u0011\"\u0001W\u0011!a\u0006A!A!B\u0013\t\u0006\"B/\u0001\t\u0003q\u0006b\u00022\u0001\u0005\u0004%Ia\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011\u00023\t\u000f5\u0004!\u0019!C\u0001]\"1!\u0010\u0001Q\u0001\n=Dqa\u001f\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011B?\t\u0011\u0005\r\u0001A1A\u0005\u00029Dq!!\u0002\u0001A\u0003%q\u000eC\u0005\u0002\b\u0001\u0011\r\u0011\"\u0001\u0002\n!A\u0011\u0011\u0003\u0001!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0014\u0001A)\u0019!C\u0001\u0003+A!\"!\u000b\u0001\u0011\u000b\u0007I\u0011AA\u0016\u0011%\t\u0019\u0004\u0001EC\u0002\u0013\u0005a\u000e\u0003\u0006\u00026\u0001A)\u0019!C\u0001\u0003oA\u0011\"!\u0012\u0001\u0011\u000b\u0007I\u0011\u00018\t\u0015\u0005\u001d\u0003\u0001#b\u0001\n\u0003\tI\u0005\u0003\u0006\u0002R\u0001A)\u0019!C\u0001\u0003'B!\"a\u0017\u0001\u0011\u000b\u0007I\u0011AA%\u0011%\ti\u0006\u0001EC\u0002\u0013\u0005a\u000e\u0003\u0006\u0002`\u0001A)\u0019!C\u0001\u0003CB!\"a\u001c\u0001\u0011\u000b\u0007I\u0011AA1\u0011)\t\t\b\u0001EC\u0002\u0013\u0005\u0011\u0011\r\u0005\u000b\u0003g\u0002\u0001R1A\u0005\u0002\u0005\u0005\u0004BCA;\u0001!\u0015\r\u0011\"\u0001\u0002b!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004bBAG\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!!(\u0001\t\u0013\ty\nC\u0005\u0002*\u0002\t\n\u0011\"\u0003\u0002,\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAd\u0001\u0011%\u0011\u0011Z\u0004\b\u0003S|\u0003\u0012AAv\r\u0019qs\u0006#\u0001\u0002n\"1Q\f\u000bC\u0001\u0003_D\u0011\"!=)\u0005\u0004%\t!a=\t\u0011\u0005m\b\u0006)A\u0005\u0003kDq!!@)\t\u0003\ty\u0010C\u0004\u0002~\"\"\tAa\u0002\u0003%!{w\u000eZ5f\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0006\u0003aE\nqaY1uC2|wM\u0003\u00023g\u0005A1-\u0019;bYf\u001cHO\u0003\u00025k\u0005\u00191/\u001d7\u000b\u0005Y:\u0014!B:qCJ\\'B\u0001\u001d:\u0003\u0019\t\u0007/Y2iK*\t!(A\u0002pe\u001e\u001c\u0001aE\u0002\u0001{\r\u0003\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0007C\u0001#H\u001b\u0005)%B\u0001$6\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001%F\u0005\u001daunZ4j]\u001e,\u0012A\u0013\t\u0003\u00172k\u0011aM\u0005\u0003\u001bN\u0012Ab\u00159be.\u001cVm]:j_:\faa\u001d9be.\u0004\u0013!\u0002;bE2,W#A)\u0011\u0005I\u001bV\"A\u0018\n\u0005Q{#\u0001D\"bi\u0006dwn\u001a+bE2,\u0017!\u0003;bE2,w\fJ3r)\t9&\f\u0005\u0002?1&\u0011\u0011l\u0010\u0002\u0005+:LG\u000fC\u0004\\\t\u0005\u0005\t\u0019A)\u0002\u0007a$\u0013'\u0001\u0004uC\ndW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007}\u0003\u0017\r\u0005\u0002S\u0001!)aG\u0002a\u0001\u0015\")qJ\u0002a\u0001#\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0016\u0003\u0011\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\t\r|gN\u001a\u0006\u0003S^\na\u0001[1e_>\u0004\u0018BA6g\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006Y\u0001.\u00193p_B\u001cuN\u001c4!\u0003A\u0019\u0017\r^1m_\u001e$\u0016M\u00197f\u001d\u0006lW-F\u0001p!\t\u0001xO\u0004\u0002rkB\u0011!oP\u0007\u0002g*\u0011AoO\u0001\u0007yI|w\u000e\u001e \n\u0005Y|\u0014A\u0002)sK\u0012,g-\u0003\u0002ys\n11\u000b\u001e:j]\u001eT!A^ \u0002#\r\fG/\u00197pOR\u000b'\r\\3OC6,\u0007%A\tdCR\fGn\\4Qe>\u0004XM\u001d;jKN,\u0012! \t\u0005az|w.\u0003\u0002\u0000s\n\u0019Q*\u00199\u0002%\r\fG/\u00197pOB\u0013x\u000e]3si&,7\u000fI\u0001\u000ei\u0006\u0014G.\u001a'pG\u0006$\u0018n\u001c8\u0002\u001dQ\f'\r\\3M_\u000e\fG/[8oA\u0005\t\u0002n\\8eS\u0016$\u0016M\u00197f\u000bbL7\u000f^:\u0016\u0005\u0005-\u0001c\u0001 \u0002\u000e%\u0019\u0011qB \u0003\u000f\t{w\u000e\\3b]\u0006\u0011\u0002n\\8eS\u0016$\u0016M\u00197f\u000bbL7\u000f^:!\u0003)iW\r^1DY&,g\u000e^\u000b\u0003\u0003/\u0001B!!\u0007\u0002&5\u0011\u00111\u0004\u0006\u0004\u001f\u0006u!\u0002BA\u0010\u0003C\taaY8n[>t'bAA\u0012o\u0005!\u0001.\u001e3j\u0013\u0011\t9#a\u0007\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\u0006YA/\u00192mK\u000e{gNZ5h+\t\ti\u0003\u0005\u0003\u0002\u001a\u0005=\u0012\u0002BA\u0019\u00037\u0011\u0011\u0003S8pI&,G+\u00192mK\u000e{gNZ5h\u0003%!\u0018M\u00197f\u001d\u0006lW-A\u0005uC\ndW\rV=qKV\u0011\u0011\u0011\b\t\u0005\u0003w\t\t%\u0004\u0002\u0002>)!\u0011qHA\u000f\u0003\u0015iw\u000eZ3m\u0013\u0011\t\u0019%!\u0010\u0003\u001f!{w\u000eZ5f)\u0006\u0014G.\u001a+za\u0016\fQ\u0002^1cY\u0016$\u0016\u0010]3OC6,\u0017a\u00039sS6\f'/_&fsN,\"!a\u0013\u0011\ty\nie\\\u0005\u0004\u0003\u001fz$!B!se\u0006L\u0018!\u00049sK\u000e{WNY5oK.+\u00170\u0006\u0002\u0002VA!a(a\u0016p\u0013\r\tIf\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001fA\f'\u000f^5uS>tg)[3mIN\faBY1tK\u001aKG.\u001a$pe6\fG/A\u0006uC\ndWmU2iK6\fWCAA2!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA5g\u0005)A/\u001f9fg&!\u0011QNA4\u0005)\u0019FO];diRK\b/Z\u0001\u001di\u0006\u0014G.Z*dQ\u0016l\u0017mV5uQ>,H/T3uC\u001aKW\r\u001c3t\u0003)!\u0017\r^1TG\",W.Y\u0001\u001cI\u0006$\u0018mU2iK6\fw+\u001b;i_V$X*\u001a;b\r&,G\u000eZ:\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006\f\u0011cZ3u!\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e5t+\t\tY\bE\u0003\u0002~\u0005\u001duN\u0004\u0003\u0002\u0000\u0005\reb\u0001:\u0002\u0002&\t\u0001)C\u0002\u0002\u0006~\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0006-%aA*fc*\u0019\u0011QQ \u0002%%\u001c\b+\u0019:uSRLwN\\3e)\u0006\u0014G.Z\u0001\u0010S:LG\u000fS8pI&,G+\u00192mKR\tq+A\u000bqCJ\u001cXmU2iK6\f\u0017I\u001c3D_:4\u0017nZ:\u0015\u0005\u0005]\u0005C\u0002 \u0002\u001a\u0006\rT0C\u0002\u0002\u001c~\u0012a\u0001V;qY\u0016\u0014\u0014\u0001E3yiJ\fG+\u00192mK\u000e{gNZ5h)\u0015i\u0018\u0011UAS\u0011\u001d\t\u0019k\ta\u0001\u0003\u0017\t1\u0002^1cY\u0016,\u00050[:ug\"A\u0011qU\u0012\u0011\u0002\u0003\u0007Q0A\tpe&<\u0017N\u001c+bE2,7i\u001c8gS\u001e\f!$\u001a=ue\u0006$\u0016M\u00197f\u0007>tg-[4%I\u00164\u0017-\u001e7uII*\"!!,+\u0007u\fyk\u000b\u0002\u00022B!\u00111WA_\u001b\t\t)L\u0003\u0003\u00028\u0006e\u0016!C;oG\",7m[3e\u0015\r\tYlP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA`\u0003k\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003maw.\u00193UC\ndWmU2iK6\f')_'fi\u0006\u001cE.[3oiR\u0011\u0011Q\u0019\t\u0006}\u0005]\u00131M\u0001\u0011m\u0016\u0014\u0018NZ=ECR\f7k\u00195f[\u0006$raVAf\u0003/\fy\u000eC\u0004\u0002N\u001a\u0002\r!a4\u0002\u001fQ\f'\r\\3JI\u0016tG/\u001b4jKJ\u0004B!!5\u0002T6\t\u0011'C\u0002\u0002VF\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\b\u0003k1\u0003\u0019AAm!\r\u0011\u00161\\\u0005\u0004\u0003;|#\u0001E\"bi\u0006dwn\u001a+bE2,G+\u001f9f\u0011\u001d\t\tH\na\u0001\u0003C\u0004b!! \u0002\b\u0006\r\b\u0003BA3\u0003KLA!a:\u0002h\tY1\u000b\u001e:vGR4\u0015.\u001a7e\u0003IAun\u001c3jK\u000e\u000bG/\u00197pOR\u000b'\r\\3\u0011\u0005IC3C\u0001\u0015>)\t\tY/A\boK\u0016$g)\u001b7uKJ\u0004&o\u001c9t+\t\t)\u0010E\u0003\u0002~\u0005]x.\u0003\u0003\u0002z\u0006-%\u0001\u0002'jgR\f\u0001C\\3fI\u001aKG\u000e^3s!J|\u0007o\u001d\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b}\u0013\tA!\u0002\t\r\t\rA\u00061\u0001K\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\ti\r\fa\u0001\u0003\u001f$Ra\u0018B\u0005\u0005\u0017AaAa\u0001.\u0001\u0004Q\u0005B\u0002B\u0007[\u0001\u0007\u0011+\u0001\u0007dCR\fGn\\4UC\ndW\r")
public class HoodieCatalogTable
implements Logging {
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private String tableName;
    private HoodieTableType tableType;
    private String tableTypeName;
    private String[] primaryKeys;
    private Option<String> preCombineKey;
    private String[] partitionFields;
    private String baseFileFormat;
    private StructType tableSchema;
    private StructType tableSchemaWithoutMetaFields;
    private StructType dataSchema;
    private StructType dataSchemaWithoutMetaFields;
    private StructType partitionSchema;
    private final SparkSession spark;
    private CatalogTable table;
    private final Configuration hadoopConf;
    private final String catalogTableName;
    private final scala.collection.immutable.Map<String, String> catalogProperties;
    private final String tableLocation;
    private final boolean hoodieTableExists;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public static HoodieCatalogTable apply(SparkSession sparkSession, CatalogTable catalogTable) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
    }

    public static HoodieCatalogTable apply(SparkSession sparkSession, TableIdentifier tableIdentifier) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
    }

    public static List<String> needFilterProps() {
        return HoodieCatalogTable$.MODULE$.needFilterProps();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public CatalogTable table() {
        return this.table;
    }

    public void table_$eq(CatalogTable x$1) {
        this.table = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String catalogTableName() {
        return this.catalogTableName;
    }

    public scala.collection.immutable.Map<String, String> catalogProperties() {
        return this.catalogProperties;
    }

    public String tableLocation() {
        return this.tableLocation;
    }

    public boolean hoodieTableExists() {
        return this.hoodieTableExists;
    }

    private HoodieTableMetaClient metaClient$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.tableLocation()).setConf(this.hadoopConf()).build();
                this.bitmap$0 |= 1;
            }
        }
        return this.metaClient;
    }

    public HoodieTableMetaClient metaClient() {
        return (this.bitmap$0 & 1) == 0 ? this.metaClient$lzycompute() : this.metaClient;
    }

    private HoodieTableConfig tableConfig$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tableConfig = this.metaClient().getTableConfig();
                this.bitmap$0 |= 2;
            }
        }
        return this.tableConfig;
    }

    public HoodieTableConfig tableConfig() {
        return (this.bitmap$0 & 2) == 0 ? this.tableConfig$lzycompute() : this.tableConfig;
    }

    private String tableName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tableName = this.tableConfig().getTableName();
                this.bitmap$0 |= 4;
            }
        }
        return this.tableName;
    }

    public String tableName() {
        return (this.bitmap$0 & 4) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 8) == 0) {
                this.tableType = this.tableConfig().getTableType();
                this.bitmap$0 |= 8;
            }
        }
        return this.tableType;
    }

    public HoodieTableType tableType() {
        return (this.bitmap$0 & 8) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    private String tableTypeName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableTypeName = this.tableType().name();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.tableTypeName;
    }

    public String tableTypeName() {
        return (this.bitmap$0 & 0x10) == 0 ? this.tableTypeName$lzycompute() : this.tableTypeName;
    }

    private String[] primaryKeys$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.primaryKeys = this.tableConfig().getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.primaryKeys;
    }

    public String[] primaryKeys() {
        return (this.bitmap$0 & 0x20) == 0 ? this.primaryKeys$lzycompute() : this.primaryKeys;
    }

    private Option<String> preCombineKey$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.preCombineKey = Option$.MODULE$.apply((Object)this.tableConfig().getPreCombineField());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.preCombineKey;
    }

    public Option<String> preCombineKey() {
        return (this.bitmap$0 & 0x40) == 0 ? this.preCombineKey$lzycompute() : this.preCombineKey;
    }

    private String[] partitionFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.partitionFields = this.tableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x80;
            }
        }
        return this.partitionFields;
    }

    public String[] partitionFields() {
        return (this.bitmap$0 & 0x80) == 0 ? this.partitionFields$lzycompute() : this.partitionFields;
    }

    private String baseFileFormat$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.baseFileFormat = this.metaClient().getTableConfig().getBaseFileFormat().name();
                this.bitmap$0 |= 0x100;
            }
        }
        return this.baseFileFormat;
    }

    public String baseFileFormat() {
        return (this.bitmap$0 & 0x100) == 0 ? this.baseFileFormat$lzycompute() : this.baseFileFormat;
    }

    private StructType tableSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.tableSchema = this.table().schema();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.tableSchema;
    }

    public StructType tableSchema() {
        return (this.bitmap$0 & 0x200) == 0 ? this.tableSchema$lzycompute() : this.tableSchema;
    }

    private StructType tableSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.tableSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.tableSchema());
                this.bitmap$0 |= 0x400;
            }
        }
        return this.tableSchemaWithoutMetaFields;
    }

    public StructType tableSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x400) == 0 ? this.tableSchemaWithoutMetaFields$lzycompute() : this.tableSchemaWithoutMetaFields;
    }

    private StructType dataSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.dataSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$dataSchema$1(this, f))));
                this.bitmap$0 |= 0x800;
            }
        }
        return this.dataSchema;
    }

    public StructType dataSchema() {
        return (this.bitmap$0 & 0x800) == 0 ? this.dataSchema$lzycompute() : this.dataSchema;
    }

    private StructType dataSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.dataSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.dataSchema());
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.dataSchemaWithoutMetaFields;
    }

    public StructType dataSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.dataSchemaWithoutMetaFields$lzycompute() : this.dataSchemaWithoutMetaFields;
    }

    private StructType partitionSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.partitionSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$partitionSchema$1(this, f))));
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.partitionSchema;
    }

    public StructType partitionSchema() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    public Seq<String> getPartitionPaths() {
        return HoodieSqlCommonUtils$.MODULE$.getAllPartitionPaths(this.spark(), this.table());
    }

    public boolean isPartitionedTable() {
        return this.table().partitionColumnNames().nonEmpty();
    }

    public void initHoodieTable() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Init hoodie.properties for ").append(this.table().identifier().unquotedString()).toString());
        Tuple2<StructType, scala.collection.immutable.Map<String, String>> tuple2 = this.parseSchemaAndConfigs();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        StructType finalSchema = (StructType)tuple2._1();
        scala.collection.immutable.Map tableConfigs = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        Tuple2 tuple23 = tuple22;
        StructType finalSchema2 = (StructType)tuple23._1();
        scala.collection.immutable.Map tableConfigs2 = (scala.collection.immutable.Map)tuple23._2();
        CatalogTable qual$1 = this.table();
        StructType x$1 = finalSchema2;
        TableIdentifier x$2 = qual$1.copy$default$1();
        CatalogTableType x$3 = qual$1.copy$default$2();
        CatalogStorageFormat x$4 = qual$1.copy$default$3();
        Option x$5 = qual$1.copy$default$5();
        Seq x$6 = qual$1.copy$default$6();
        Option x$7 = qual$1.copy$default$7();
        String x$8 = qual$1.copy$default$8();
        long x$9 = qual$1.copy$default$9();
        long x$10 = qual$1.copy$default$10();
        String x$11 = qual$1.copy$default$11();
        scala.collection.immutable.Map x$12 = qual$1.copy$default$12();
        Option x$13 = qual$1.copy$default$13();
        Option x$14 = qual$1.copy$default$14();
        Option x$15 = qual$1.copy$default$15();
        Seq x$16 = qual$1.copy$default$16();
        boolean x$17 = qual$1.copy$default$17();
        boolean x$18 = qual$1.copy$default$18();
        scala.collection.immutable.Map x$19 = qual$1.copy$default$19();
        this.table_$eq(qual$1.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19));
        Properties properties = new Properties();
        properties.putAll((java.util.Map<?, ?>)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableConfigs2).asJava()));
        if (this.hoodieTableExists()) {
            HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setTableCreateSchema(SchemaConverters$.MODULE$.toAvroType((DataType)finalSchema2, SchemaConverters$.MODULE$.toAvroType$default$2(), SchemaConverters$.MODULE$.toAvroType$default$3(), SchemaConverters$.MODULE$.toAvroType$default$4()).toString()).initTable(this.hadoopConf(), this.tableLocation());
        } else {
            Tuple2<String, String> tuple24 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.table().identifier().table());
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            String recordName = (String)tuple24._1();
            String namespace = (String)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)recordName, (Object)namespace);
            Tuple2 tuple26 = tuple25;
            String recordName2 = (String)tuple26._1();
            String namespace2 = (String)tuple26._2();
            Schema schema = SchemaConverters$.MODULE$.toAvroType((DataType)finalSchema2, false, recordName2, namespace2);
            String hoodieDatabaseName = HoodieSqlCommonUtils$.MODULE$.formatName(this.spark(), (String)this.table().identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.spark().sessionState().catalog().getCurrentDatabase()));
            HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setDatabaseName(hoodieDatabaseName).setTableName(this.table().identifier().table()).setTableCreateSchema(schema.toString()).setPartitionFields(this.table().partitionColumnNames().mkString(",")).initTable(this.hadoopConf(), this.tableLocation());
        }
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<StructType, scala.collection.immutable.Map<String, String>> parseSchemaAndConfigs() {
        globalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
        globalTableConfigs = HoodieWriterUtils$.MODULE$.mappingSparkDatasourceConfigsToTableConfigs((scala.collection.immutable.Map<String, String>)globalProps);
        globalSqlOptions = HoodieOptionConfig$.MODULE$.mappingTableConfigToSqlOption(globalTableConfigs);
        sqlOptions = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions((scala.collection.immutable.Map<String, String>)globalSqlOptions.$plus$plus(this.catalogProperties()));
        var9_5 = new Tuple2((Object)this.table().tableType(), (Object)BoxesRunTime.boxToBoolean((boolean)this.hoodieTableExists()));
        if (var9_5 == null) ** GOTO lbl-1000
        var10_6 = (CatalogTableType)var9_5._1();
        var11_7 = var9_5._2$mcZ$sp();
        v0 = CatalogTableType$.MODULE$.EXTERNAL();
        var12_8 = var10_6;
        if (!(v0 != null ? v0.equals(var12_8) == false : var12_8 != null) && var11_7) {
            existingTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
            currentTableConfig = globalTableConfigs.$plus$plus((GenTraversableOnce)existingTableConfig);
            catalogTableProps = HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(this.catalogProperties());
            HoodieWriterUtils$.MODULE$.validateTableConfig(this.spark(), catalogTableProps, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)existingTableConfig));
            options = this.extraTableConfig(this.hoodieTableExists(), (scala.collection.immutable.Map<String, String>)currentTableConfig).$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(sqlOptions)).$plus$plus((GenTraversableOnce)currentTableConfig);
            schemaFromMetaOpt = this.loadTableSchemaByMetaClient();
            if (schemaFromMetaOpt.nonEmpty()) {
                v1 = (StructType)schemaFromMetaOpt.get();
            } else if (this.table().schema().nonEmpty()) {
                v1 = HoodieSqlCommonUtils$.MODULE$.addMetaFields(this.table().schema());
            } else {
                throw new AnalysisException(new StringBuilder(60).append("Missing schema fields when applying CREATE TABLE clause for ").append(this.catalogTableName()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            schema = v1;
            var2_15 = new Tuple2((Object)schema, (Object)options);
        } else if (var9_5 != null && !(var19_16 = var9_5._2$mcZ$sp())) {
            ValidationUtils.checkArgument(this.table().schema().nonEmpty(), new StringBuilder(33).append("Missing schema for Create Table: ").append(this.catalogTableName()).toString());
            schema = this.table().schema();
            options = this.extraTableConfig(false, globalTableConfigs).$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(sqlOptions));
            var2_15 = new Tuple2((Object)HoodieSqlCommonUtils$.MODULE$.addMetaFields(schema), (Object)options);
        } else {
            if (var9_5 != null) {
                var22_19 = (CatalogTableType)var9_5._1();
                var23_20 = var9_5._2$mcZ$sp();
                v2 = CatalogTableType$.MODULE$.MANAGED();
                var24_21 = var22_19;
                if (!(v2 != null ? v2.equals(var24_21) == false : var24_21 != null) && var23_20) {
                    throw new AnalysisException(new StringBuilder(81).append("Can not create the managed table('").append(this.catalogTableName()).append("')").append(". The associated location('").append(this.tableLocation()).append("') already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            throw new MatchError((Object)var9_5);
        }
        var8_22 = var2_15;
        if (var8_22 == null) {
            throw new MatchError((Object)var8_22);
        }
        finalSchema = (StructType)var8_22._1();
        tableConfigs = (scala.collection.immutable.Map)var8_22._2();
        var1_25 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
        var7_26 = var1_25;
        finalSchema = (StructType)var7_26._1();
        tableConfigs = (scala.collection.immutable.Map)var7_26._2();
        HoodieOptionConfig$.MODULE$.validateTable(this.spark(), finalSchema, HoodieOptionConfig$.MODULE$.mappingTableConfigToSqlOption((scala.collection.immutable.Map<String, String>)tableConfigs));
        resolver = this.spark().sessionState().conf().resolver();
        dataSchema = (Seq)finalSchema.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseSchemaAndConfigs$1$adapted(org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable scala.Function2 org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Ljava/lang/Object;)((HoodieCatalogTable)this, (Function2)resolver));
        this.verifyDataSchema(this.table().identifier(), this.table().tableType(), (Seq<StructField>)dataSchema);
        return new Tuple2((Object)finalSchema, (Object)tableConfigs);
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig(boolean tableExists, scala.collection.immutable.Map<String, String> originTableConfig) {
        scala.collection.mutable.Map extraConfig = Map$.MODULE$.empty();
        if (tableExists) {
            Seq<String> allPartitionPaths = this.getPartitionPaths();
            if (originTableConfig.contains((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key())) {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), originTableConfig.apply((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isHiveStyledPartitioning(allPartitionPaths, this.table())));
            }
            if (originTableConfig.contains((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key())) {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), originTableConfig.apply((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isUrlEncodeEnabled(allPartitionPaths, this.table())));
            }
        } else {
            extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
            extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.defaultValue());
        }
        if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())));
        } else {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)ComplexKeyGenerator.class.getCanonicalName());
        }
        return extraConfig.toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private Option<StructType> loadTableSchemaByMetaClient() {
        Function2 resolver = this.spark().sessionState().conf().resolver();
        return HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(this.metaClient(), true).map((Function1 & Serializable & scala.Serializable)originSchema -> {
            StructField[] fields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
                void var3_7;
                boolean x$1 = true;
                String x$2 = f.copy$default$1();
                DataType x$3 = f.copy$default$2();
                Metadata x$4 = f.copy$default$4();
                StructField nullableField = f.copy(x$2, x$3, x$1, x$4);
                Option<StructField> catalogField = HoodieSqlCommonUtils$.MODULE$.findColumnByName(this.table().schema(), nullableField.name(), (Function2<String, String, Object>)resolver);
                return catalogField.isDefined() ? (StructField)((StructField)catalogField.get()).getComment().map((Function1 & Serializable & scala.Serializable)comment -> nullableField.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> nullableField) : var3_7;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            return new StructType(fields);
        });
    }

    private void verifyDataSchema(TableIdentifier tableIdentifier, CatalogTableType tableType, Seq<StructField> dataSchema) {
        block0: {
            CatalogTableType catalogTableType = tableType;
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2))) break block0;
            Seq invalidChars = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", ":", ";"}));
            dataSchema.foreach((Function1 & Serializable & scala.Serializable)f -> {
                HoodieCatalogTable.$anonfun$verifyDataSchema$4(tableIdentifier, invalidChars, f);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$dataSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$partitionSchema$1(HoodieCatalogTable $this, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFields())).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$2(Function2 resolver$1, StructField f$1, String x$5) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)x$5, (Object)f$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$parseSchemaAndConfigs$1(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return $this.table().partitionColumnNames().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$2(resolver$1, f, x$5)));
    }

    public static final /* synthetic */ boolean $anonfun$verifyDataSchema$2(StructField f$2, CharSequence x$1) {
        return f$2.name().contains(x$1);
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$1(Seq invalidChars$1, TableIdentifier tableIdentifier$1, StructField f) {
        DataType dataType = f.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (invalidChars$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$verifyDataSchema$2(f, x$1)))) {
                String invalidCharsString = ((TraversableOnce)invalidChars$1.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append("'").append((String)c).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                String errMsg = new StringBuilder(123).append("Cannot create a table having a nested column whose name contains ").append("invalid characters (").append(invalidCharsString).append(") in Hive metastore. Table: ").append(tableIdentifier$1).append("; ").append("Column: ").append(f.name()).toString();
                throw new AnalysisException(errMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final void verifyNestedColumnNames$1(StructType schema, Seq invalidChars$1, TableIdentifier tableIdentifier$1) {
        schema.foreach((Function1 & Serializable & scala.Serializable)f -> {
            HoodieCatalogTable.$anonfun$verifyDataSchema$1(invalidChars$1, tableIdentifier$1, f);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDataSchema$4(TableIdentifier tableIdentifier$1, Seq invalidChars$1, StructField f) {
        DataType dataType = f.dataType();
        if (f.name().contains(",")) {
            throw new AnalysisException(new StringBuilder(101).append("Cannot create a table having a column whose name ").append("contains commas in Hive metastore. Table: ").append(tableIdentifier$1).append("; Column: ").append(f.name()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            HoodieCatalogTable.verifyNestedColumnNames$1(structType, invalidChars$1, tableIdentifier$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public HoodieCatalogTable(SparkSession spark, CatalogTable table) {
        this.spark = spark;
        this.table = table;
        Logging.$init$((Logging)this);
        Object object = this.table().provider().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string) : string != null), (Function0 & Serializable & scala.Serializable)() -> "It's not a Hudi table");
        this.hadoopConf = spark.sessionState().newHadoopConf();
        this.catalogTableName = this.table().qualifiedName();
        this.catalogProperties = this.table().storage().properties().$plus$plus((GenTraversableOnce)this.table().properties());
        this.tableLocation = HoodieSqlCommonUtils$.MODULE$.getTableLocation(this.table(), spark);
        this.hoodieTableExists = HoodieSqlCommonUtils$.MODULE$.tableExistsInPath(this.tableLocation(), this.hadoopConf());
    }

    public static final /* synthetic */ Object $anonfun$parseSchemaAndConfigs$1$adapted(HoodieCatalogTable $this, Function2 resolver$1, StructField f) {
        return BoxesRunTime.boxToBoolean((boolean)HoodieCatalogTable.$anonfun$parseSchemaAndConfigs$1($this, resolver$1, f));
    }
}

