/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.CreateSavepointsProcedure$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\t\u0012\u0001\u0001BQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004=\u0001\u0001\u0006Ia\r\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!)a\t\u0001C\u0001e!)q\t\u0001C\u0001}!)\u0001\n\u0001C!\u0013\")q\f\u0001C!A\u001e)A-\u0005E\u0001K\u001a)\u0001#\u0005E\u0001M\")af\u0003C\u0001U\"91n\u0003b\u0001\n\u0003a\u0007BB;\fA\u0003%Q\u000eC\u0003w\u0017\u0011\u0005qOA\rDe\u0016\fG/Z*bm\u0016\u0004x.\u001b8ugB\u0013xnY3ekJ,'B\u0001\n\u0014\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003)U\tqaY8n[\u0006tGM\u0003\u0002\u0017/\u0005!\u0001.\u001e3j\u0015\tA\u0012$A\u0002tc2T!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011%\n\u0015\u0011\u0005\t\u001aS\"A\t\n\u0005\u0011\n\"!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002#M%\u0011q%\u0005\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJ\u0004\"!\u000b\u0017\u000e\u0003)R!aK\r\u0002\u0011%tG/\u001a:oC2L!!\f\u0016\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\r\t\u0003E\u0001\t!\u0002U!S\u00036+E+\u0012*T+\u0005\u0019\u0004c\u0001\u001b8s5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATGA\u0003BeJ\f\u0017\u0010\u0005\u0002#u%\u00111(\u0005\u0002\u0013!J|7-\u001a3ve\u0016\u0004\u0016M]1nKR,'/A\u0006Q\u0003J\u000bU*\u0012+F%N\u0003\u0013aC(V)B+Fk\u0018+Z!\u0016+\u0012a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005^\tQ\u0001^=qKNL!\u0001R!\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0007P+R\u0003V\u000bV0U3B+\u0005%\u0001\u0006qCJ\fW.\u001a;feN\f!b\\;uaV$H+\u001f9f\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0005)S\u0006cA&T-:\u0011A*\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f~\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005I+\u0014a\u00029bG.\fw-Z\u0005\u0003)V\u00131aU3r\u0015\t\u0011V\u0007\u0005\u0002X16\tq#\u0003\u0002Z/\t\u0019!k\\<\t\u000bmC\u0001\u0019\u0001/\u0002\t\u0005\u0014xm\u001d\t\u0003EuK!AX\t\u0003\u001bA\u0013xnY3ekJ,\u0017I]4t\u0003\u0015\u0011W/\u001b7e+\u0005\t\u0007C\u0001\u0012c\u0013\t\u0019\u0017CA\u0005Qe>\u001cW\rZ;sK\u0006I2I]3bi\u0016\u001c\u0016M^3q_&tGo\u001d)s_\u000e,G-\u001e:f!\t\u00113b\u0005\u0002\fOB\u0011A\u0007[\u0005\u0003SV\u0012a!\u00118z%\u00164G#A3\u0002\t9\u000bU*R\u000b\u0002[B\u0011aN\u001d\b\u0003_B\u0004\"!T\u001b\n\u0005E,\u0014A\u0002)sK\u0012,g-\u0003\u0002ti\n11\u000b\u001e:j]\u001eT!!]\u001b\u0002\u000b9\u000bU*\u0012\u0011\u0002\u000f\t,\u0018\u000e\u001c3feV\t\u0001\u0010\u0005\u0003z\u0003\u0003)S\"\u0001>\u000b\u0005md\u0018\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005ut\u0018\u0001B;uS2T\u0011a`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0004i\u0014\u0001bU;qa2LWM\u001d")
public class CreateSavepointsProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return CreateSavepointsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return CreateSavepointsProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        String commitTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        String user = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        String comments = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get();
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        if (!activeTimeline.getCommitsTimeline().filterCompletedInstants().containsInstant(commitTime)) {
            throw new HoodieException(new StringBuilder(29).append("Commit ").append(commitTime).append(" not found in Commits ").append(activeTimeline).toString());
        }
        SparkRDDWriteClient<HoodieRecordPayload<?>> client = this.createHoodieClient(this.jsc(), basePath);
        boolean result = false;
        try {
            client.savepoint(commitTime, user, comments);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("The commit ").append(commitTime).append(" has been savepointed.").toString());
            result = true;
        }
        catch (HoodieSavepointException hoodieSavepointException) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Failed: Could not create savepoint ").append(commitTime).append(".").toString());
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)}))}));
    }

    @Override
    public Procedure build() {
        return new CreateSavepointsProcedure();
    }

    public CreateSavepointsProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "commit_Time", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(2, "user", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(3, "comments", DataTypes.StringType, "")});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("create_savepoint_result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }
}

