/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class HoodieSparkUtils$
implements SparkAdapterSupport {
    public static HoodieSparkUtils$ MODULE$;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new HoodieSparkUtils$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieSparkUtils$ hoodieSparkUtils$ = this;
        synchronized (hoodieSparkUtils$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public boolean isSpark2() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("2.");
    }

    public boolean isSpark3() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("3.");
    }

    public boolean isSpark3_0() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("3.0");
    }

    public boolean isSpark3_1() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("3.1");
    }

    public boolean gteqSpark3_1() {
        return new StringOps(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION())).$greater((Object)"3.1");
    }

    public boolean gteqSpark3_1_3() {
        return new StringOps(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION())).$greater$eq((Object)"3.1.3");
    }

    public boolean isSpark3_2() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("3.2");
    }

    public boolean gteqSpark3_2() {
        return new StringOps(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION())).$greater((Object)"3.2");
    }

    public boolean gteqSpark3_2_1() {
        return new StringOps(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION())).$greater$eq((Object)"3.2.1");
    }

    public StructType getMetaSchema() {
        return StructType$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1 & Serializable & scala.Serializable)col -> new StructField(col, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom()));
    }

    public boolean isGlobPath(Path pattern) {
        Set set = new StringOps(Predef$.MODULE$.augmentString("{}[]*?\\")).toSet();
        return new StringOps(Predef$.MODULE$.augmentString(pattern.toString())).exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains(elem)));
    }

    public Seq<Path> globPath(FileSystem fs, Path pattern) {
        ObjectRef basePath = ObjectRef.create((Object)pattern.getParent());
        while (((Path)basePath.elem).getName().equals("*")) {
            basePath.elem = ((Path)basePath.elem).getParent();
        }
        return (Seq)Option$.MODULE$.apply((Object)fs.globStatus(pattern)).map((Function1 & Serializable & scala.Serializable)statuses -> {
            FileStatus[] nonMetaStatuses = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).filterNot((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkUtils$.$anonfun$globPath$2(basePath, entry)));
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonMetaStatuses)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().makeQualified(fs.getUri(), fs.getWorkingDirectory()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).toSeq();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
    }

    public Seq<Path> globPathIfNecessary(FileSystem fs, Path pattern) {
        return this.isGlobPath(pattern) ? this.globPath(fs, pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{pattern}));
    }

    public Seq<Path> checkAndGlobPathIfNecessary(Seq<String> paths, FileSystem fs) {
        return (Seq)paths.flatMap((Function1 & Serializable & scala.Serializable)path -> {
            Path qualified = new Path(path).makeQualified(fs.getUri(), fs.getWorkingDirectory());
            return MODULE$.globPathIfNecessary(fs, qualified);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, String structName, String recordNamespace, boolean reconcileToLatestSchema, Option<Schema> latestTableSchema) {
        Object latestTableSchemaConverted = None$.MODULE$;
        latestTableSchemaConverted = latestTableSchema.isPresent() && reconcileToLatestSchema ? new Some(latestTableSchema.get()) : (latestTableSchema.isPresent() ? new Some(latestTableSchema.get()) : None$.MODULE$);
        return this.createRdd(df, structName, recordNamespace, (scala.Option<Schema>)latestTableSchemaConverted);
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, String structName, String recordNamespace, scala.Option<Schema> readerAvroSchemaOpt) {
        boolean nullable;
        StructType writerSchema = df.schema();
        Schema writerAvroSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)writerSchema, structName, recordNamespace);
        Schema readerAvroSchema = (Schema)readerAvroSchemaOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> writerAvroSchema);
        boolean sameSchema = writerAvroSchema.equals((Object)readerAvroSchema);
        Tuple2<Object, Schema> tuple2 = AvroConversionUtils$.MODULE$.resolveAvroTypeNullability(writerAvroSchema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean bl = nullable = tuple2._1$mcZ$sp();
        boolean nullable2 = bl;
        String readerAvroSchemaStr = readerAvroSchema.toString();
        String writerAvroSchemaStr = writerAvroSchema.toString();
        return df.queryExecution().toRdd().mapPartitions((Function1 & Serializable & scala.Serializable)rows -> {
            Iterator iterator;
            if (rows.isEmpty()) {
                iterator = scala.package$.MODULE$.Iterator().empty();
            } else {
                Function1 & Serializable & scala.Serializable intersect;
                if (sameSchema) {
                    intersect = (Function1 & Serializable & scala.Serializable)x -> (GenericRecord)Predef$.MODULE$.identity(x);
                } else {
                    Schema readerAvroSchema = new Schema.Parser().parse(readerAvroSchemaStr);
                    intersect = (Function1 & Serializable & scala.Serializable)x$2 -> HoodieAvroUtils.rewriteRecord((GenericRecord)x$2, (Schema)readerAvroSchema);
                }
                Function1 & Serializable & scala.Serializable transform = intersect;
                Schema writerAvroSchema = new Schema.Parser().parse(writerAvroSchemaStr);
                Function1<InternalRow, GenericRecord> convert = AvroConversionUtils$.MODULE$.createInternalRowToAvroConverter(writerSchema, writerAvroSchema, nullable2);
                iterator = rows.map((Function1 & Serializable & scala.Serializable)ir -> (GenericRecord)transform.apply(convert.apply(ir)));
            }
            return iterator;
        }, df.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(GenericRecord.class));
    }

    public Option<Schema> createRdd$default$5() {
        return Option.empty();
    }

    public SparkRowSerDe getDeserializer(StructType structType) {
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(structType);
        Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$2 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder encoder = qual$1.resolveAndBind(x$1, x$2);
        return this.sparkAdapter().createSparkRowSerDe((ExpressionEncoder<Row>)encoder);
    }

    public Seq<scala.Option<Expression>> convertToCatalystExpressions(Seq<Filter> filters, StructType tableSchema) {
        return (Seq)filters.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.convertToCatalystExpression((Filter)x$3, tableSchema), Seq$.MODULE$.canBuildFrom());
    }

    public scala.Option<Expression> convertToCatalystExpression(Filter[] filters, StructType tableSchema) {
        Seq<scala.Option<Expression>> expressions = this.convertToCatalystExpressions((Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])filters), tableSchema);
        return expressions.forall((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.isDefined())) ? (expressions.isEmpty() ? None$.MODULE$ : (expressions.length() == 1 ? (scala.Option)expressions.head() : new Some(((TraversableOnce)expressions.map((Function1 & Serializable & scala.Serializable)x$4 -> (Expression)x$4.get(), Seq$.MODULE$.canBuildFrom())).reduce((Function2)And$.MODULE$)))) : None$.MODULE$;
    }

    public scala.Option<Expression> convertToCatalystExpression(Filter filter, StructType tableSchema) {
        EqualTo equalTo;
        Filter filter2 = filter;
        if (filter2 instanceof org.apache.spark.sql.sources.EqualTo) {
            org.apache.spark.sql.sources.EqualTo equalTo2 = (org.apache.spark.sql.sources.EqualTo)filter2;
            String attribute = equalTo2.attribute();
            Object value = equalTo2.value();
            equalTo = new EqualTo((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.EqualNullSafe) {
            org.apache.spark.sql.sources.EqualNullSafe equalNullSafe = (org.apache.spark.sql.sources.EqualNullSafe)filter2;
            String attribute = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            equalTo = new EqualNullSafe((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.GreaterThan) {
            org.apache.spark.sql.sources.GreaterThan greaterThan = (org.apache.spark.sql.sources.GreaterThan)filter2;
            String attribute = greaterThan.attribute();
            Object value = greaterThan.value();
            equalTo = new GreaterThan((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.GreaterThanOrEqual) {
            org.apache.spark.sql.sources.GreaterThanOrEqual greaterThanOrEqual = (org.apache.spark.sql.sources.GreaterThanOrEqual)filter2;
            String attribute = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            equalTo = new GreaterThanOrEqual((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.LessThan) {
            org.apache.spark.sql.sources.LessThan lessThan = (org.apache.spark.sql.sources.LessThan)filter2;
            String attribute = lessThan.attribute();
            Object value = lessThan.value();
            equalTo = new LessThan((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.LessThanOrEqual) {
            org.apache.spark.sql.sources.LessThanOrEqual lessThanOrEqual = (org.apache.spark.sql.sources.LessThanOrEqual)filter2;
            String attribute = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            equalTo = new LessThanOrEqual((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof In) {
            In in = (In)filter2;
            String attribute = in.attribute();
            Object[] values = in.values();
            AttributeReference attrExp = this.toAttribute(attribute, tableSchema);
            Literal[] valuesExp = (Literal[])Predef$.MODULE$.genericArrayOps((Object)values).map((Function1 & Serializable & scala.Serializable)v -> Literal$.MODULE$.create(v, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Literal.class)));
            equalTo = new org.apache.spark.sql.catalyst.expressions.In((Expression)attrExp, (Seq)Predef$.MODULE$.wrapRefArray((Object[])valuesExp));
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attribute = isNull.attribute();
            equalTo = new org.apache.spark.sql.catalyst.expressions.IsNull((Expression)this.toAttribute(attribute, tableSchema));
        } else if (filter2 instanceof org.apache.spark.sql.sources.IsNotNull) {
            org.apache.spark.sql.sources.IsNotNull isNotNull = (org.apache.spark.sql.sources.IsNotNull)filter2;
            String attribute = isNotNull.attribute();
            equalTo = new IsNotNull((Expression)this.toAttribute(attribute, tableSchema));
        } else if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            scala.Option<Expression> leftExp = this.convertToCatalystExpression(left, tableSchema);
            scala.Option<Expression> rightExp = this.convertToCatalystExpression(right, tableSchema);
            equalTo = leftExp.isEmpty() || rightExp.isEmpty() ? null : new org.apache.spark.sql.catalyst.expressions.And((Expression)leftExp.get(), (Expression)rightExp.get());
        } else if (filter2 instanceof org.apache.spark.sql.sources.Or) {
            org.apache.spark.sql.sources.Or or = (org.apache.spark.sql.sources.Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            scala.Option<Expression> leftExp = this.convertToCatalystExpression(left, tableSchema);
            scala.Option<Expression> rightExp = this.convertToCatalystExpression(right, tableSchema);
            equalTo = leftExp.isEmpty() || rightExp.isEmpty() ? null : new Or((Expression)leftExp.get(), (Expression)rightExp.get());
        } else if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            Filter child = not.child();
            scala.Option<Expression> childExp = this.convertToCatalystExpression(child, tableSchema);
            equalTo = childExp.isEmpty() ? null : new org.apache.spark.sql.catalyst.expressions.Not((Expression)childExp.get());
        } else if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attribute = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            AttributeReference leftExp = this.toAttribute(attribute, tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_hudi_HoodieSparkUtils$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_hudi_HoodieSparkUtils$$typecreator1$1() {
                }
            }
            Literal rightExp = Literal$.MODULE$.create((Object)new StringBuilder(1).append(value).append("%").toString(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_HoodieSparkUtils$$typecreator1$1()));
            equalTo = this.sparkAdapter().createLike((Expression)leftExp, (Expression)rightExp);
        } else if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attribute = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            AttributeReference leftExp = this.toAttribute(attribute, tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_hudi_HoodieSparkUtils$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_hudi_HoodieSparkUtils$$typecreator2$1() {
                }
            }
            Literal rightExp = Literal$.MODULE$.create((Object)new StringBuilder(1).append("%").append(value).toString(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_HoodieSparkUtils$$typecreator2$1()));
            equalTo = this.sparkAdapter().createLike((Expression)leftExp, (Expression)rightExp);
        } else if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            String attribute = stringContains.attribute();
            String value = stringContains.value();
            AttributeReference leftExp = this.toAttribute(attribute, tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_hudi_HoodieSparkUtils$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_hudi_HoodieSparkUtils$$typecreator3$1() {
                }
            }
            Literal rightExp = Literal$.MODULE$.create((Object)new StringBuilder(2).append("%").append(value).append("%").toString(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_HoodieSparkUtils$$typecreator3$1()));
            equalTo = this.sparkAdapter().createLike((Expression)leftExp, (Expression)rightExp);
        } else {
            equalTo = null;
        }
        return Option$.MODULE$.apply((Object)equalTo);
    }

    public String getPartitionColumns(Properties properties) {
        TypedProperties props = new TypedProperties(properties);
        KeyGenerator keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator(props);
        return this.getPartitionColumns(keyGenerator, props);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPartitionColumns(KeyGenerator keyGen, TypedProperties typedProperties) {
        boolean bl = false;
        ObjectRef objectRef = ObjectRef.create(null);
        KeyGenerator keyGenerator = keyGen;
        if (keyGenerator instanceof BaseKeyGenerator) {
            bl = true;
            objectRef.elem = (BaseKeyGenerator)keyGenerator;
            if ((BaseKeyGenerator)objectRef.elem instanceof CustomKeyGenerator) return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((BaseKeyGenerator)objectRef.elem).getPartitionPathFields()).asScala()).map((Function1 & Serializable & scala.Serializable)pathField -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathField.split(":"))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Illegal partition path field format: '").append((String)pathField).append("' for ").append(((BaseKeyGenerator)x2$1.elem).getClass().getSimpleName()).toString()), Buffer$.MODULE$.canBuildFrom())).mkString(",");
            if ((BaseKeyGenerator)objectRef.elem instanceof CustomAvroKeyGenerator) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((BaseKeyGenerator)objectRef.elem).getPartitionPathFields()).asScala()).map((Function1 & Serializable & scala.Serializable)pathField -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathField.split(":"))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Illegal partition path field format: '").append((String)pathField).append("' for ").append(((BaseKeyGenerator)x2$1.elem).getClass().getSimpleName()).toString()), Buffer$.MODULE$.canBuildFrom())).mkString(",");
            }
        }
        if (!bl) return typedProperties.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((BaseKeyGenerator)objectRef.elem).getPartitionPathFields()).asScala()).mkString(",");
    }

    private AttributeReference toAttribute(String columnName, StructType tableSchema) {
        scala.Option field = tableSchema.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkUtils$.$anonfun$toAttribute$1(columnName, p)));
        Predef$.MODULE$.assert(field.isDefined(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Cannot find column: ").append(columnName).append(", Table Columns are: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fieldNames())).mkString(",")).toString());
        String x$1 = columnName;
        DataType x$2 = ((StructField)field.get()).dataType();
        boolean x$3 = ((StructField)field.get()).nullable();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public Tuple3<Schema, StructType, InternalSchema> getRequiredSchema(Schema tableAvroSchema, String[] requiredColumns, InternalSchema internalSchema) {
        Tuple3 tuple3;
        if (internalSchema.isEmptySchema() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).isEmpty()) {
            Map name2Fields = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableAvroSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List requiredFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)c -> (Schema.Field)name2Fields.apply(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Schema.Field.class))))).map((Function1 & Serializable & scala.Serializable)f -> new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal(), f.order()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Schema.Field.class))))).toList();
            Schema requiredAvroSchema = Schema.createRecord((String)tableAvroSchema.getName(), (String)tableAvroSchema.getDoc(), (String)tableAvroSchema.getNamespace(), (boolean)tableAvroSchema.isError(), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requiredFields).asJava()));
            StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
            tuple3 = new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)internalSchema);
        } else {
            InternalSchema prunedInternalSchema = InternalSchemaUtils.pruneInternalSchema((InternalSchema)internalSchema, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).toList()).asJava()));
            Schema requiredAvroSchema = AvroInternalSchemaConverter.convert((InternalSchema)prunedInternalSchema, (String)tableAvroSchema.getName());
            StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
            tuple3 = new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)prunedInternalSchema);
        }
        return tuple3;
    }

    public InternalSchema getRequiredSchema$default$3() {
        return InternalSchema.getEmptyInternalSchema();
    }

    public Seq<AttributeReference> toAttribute(StructType tableSchema) {
        return (Seq)tableSchema.map((Function1 & Serializable & scala.Serializable)field -> {
            String x$1 = field.name();
            DataType x$2 = field.dataType();
            boolean x$3 = field.nullable();
            Metadata x$4 = field.metadata();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
            return new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Object> collectFieldIndexes(StructType projectedSchema, StructType originalSchema) {
        Map nameToIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originalSchema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)BoxesRunTime.boxToInteger((int)index));
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return (Seq)projectedSchema.map((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToInteger((int)HoodieSparkUtils$.$anonfun$collectFieldIndexes$2(nameToIndex, field)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$globPath$2(ObjectRef basePath$1, FileStatus entry) {
        Path leafPath = entry.getPath();
        while (!leafPath.equals((Object)((Path)basePath$1.elem)) && !leafPath.getName().equals(".hoodie")) {
            leafPath = leafPath.getParent();
        }
        return leafPath.getName().equals(".hoodie");
    }

    public static final /* synthetic */ boolean $anonfun$toAttribute$1(String columnName$1, StructField p) {
        String string = p.name();
        String string2 = columnName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$collectFieldIndexes$2(Map nameToIndex$1, StructField field) {
        return BoxesRunTime.unboxToInt((Object)nameToIndex$1.apply((Object)field.name()));
    }

    private HoodieSparkUtils$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$(this);
    }
}

