/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.update.strategy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hudi.client.clustering.update.strategy.BaseSparkUpdateStrategy;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieClusteringUpdateException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SparkRejectUpdateStrategy<T extends HoodieRecordPayload<T>>
extends BaseSparkUpdateStrategy<T> {
    private static final Logger LOG = LogManager.getLogger(SparkRejectUpdateStrategy.class);

    public SparkRejectUpdateStrategy(HoodieSparkEngineContext engineContext, HashSet<HoodieFileGroupId> fileGroupsInPendingClustering) {
        super(engineContext, fileGroupsInPendingClustering);
    }

    public Pair<HoodieData<HoodieRecord<T>>, Set<HoodieFileGroupId>> handleUpdate(HoodieData<HoodieRecord<T>> taggedRecordsRDD) {
        List<HoodieFileGroupId> fileGroupIdsWithRecordUpdate = this.getGroupIdsWithUpdate(taggedRecordsRDD);
        fileGroupIdsWithRecordUpdate.forEach(fileGroupIdWithRecordUpdate -> {
            if (this.fileGroupsInPendingClustering.contains(fileGroupIdWithRecordUpdate)) {
                String msg = String.format("Not allowed to update the clustering file group %s. For pending clustering operations, we are not going to support update for now.", fileGroupIdWithRecordUpdate.toString());
                LOG.error((Object)msg);
                throw new HoodieClusteringUpdateException(msg);
            }
        });
        return Pair.of(taggedRecordsRDD, Collections.emptySet());
    }
}

