/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.data;

import java.io.Serializable;
import java.util.Map;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.storage.StorageLevel;
import scala.Tuple2;

public class HoodieJavaPairRDD<K, V>
extends HoodiePairData<K, V> {
    private final JavaPairRDD<K, V> pairRDDData;

    private HoodieJavaPairRDD(JavaPairRDD<K, V> pairRDDData) {
        this.pairRDDData = pairRDDData;
    }

    public static <K, V> HoodieJavaPairRDD<K, V> of(JavaPairRDD<K, V> pairRDDData) {
        return new HoodieJavaPairRDD<K, V>(pairRDDData);
    }

    public static <K, V> JavaPairRDD<K, V> getJavaPairRDD(HoodiePairData<K, V> hoodiePairData) {
        return ((HoodieJavaPairRDD)hoodiePairData).get();
    }

    public JavaPairRDD<K, V> get() {
        return this.pairRDDData;
    }

    public void persist(String storageLevel) {
        this.pairRDDData.persist(StorageLevel.fromString((String)storageLevel));
    }

    public void unpersist() {
        this.pairRDDData.unpersist();
    }

    public HoodieData<K> keys() {
        return HoodieJavaRDD.of(this.pairRDDData.keys());
    }

    public HoodieData<V> values() {
        return HoodieJavaRDD.of(this.pairRDDData.values());
    }

    public long count() {
        return this.pairRDDData.count();
    }

    public Map<K, Long> countByKey() {
        return this.pairRDDData.countByKey();
    }

    public HoodiePairData<K, V> reduceByKey(SerializableBiFunction<V, V, V> func, int parallelism) {
        return HoodieJavaPairRDD.of(this.pairRDDData.reduceByKey((arg_0, arg_1) -> func.apply(arg_0, arg_1), parallelism));
    }

    public <O> HoodieData<O> map(SerializableFunction<Pair<K, V>, O> func) {
        return HoodieJavaRDD.of(this.pairRDDData.map((Function & Serializable)tuple -> func.apply((Object)new ImmutablePair(tuple._1, tuple._2))));
    }

    public <L, W> HoodiePairData<L, W> mapToPair(SerializablePairFunction<Pair<K, V>, L, W> mapToPairFunc) {
        return HoodieJavaPairRDD.of(this.pairRDDData.mapToPair((PairFunction & Serializable)pair -> {
            Pair newPair = mapToPairFunc.call((Object)new ImmutablePair(pair._1, pair._2));
            return new Tuple2(newPair.getLeft(), newPair.getRight());
        }));
    }

    public <W> HoodiePairData<K, Pair<V, Option<W>>> leftOuterJoin(HoodiePairData<K, W> other) {
        return HoodieJavaPairRDD.of(JavaPairRDD.fromJavaRDD((JavaRDD)this.pairRDDData.leftOuterJoin(HoodieJavaPairRDD.getJavaPairRDD(other)).map((Function & Serializable)tuple -> new Tuple2(tuple._1, (Object)new ImmutablePair(((Tuple2)tuple._2)._1, (Object)Option.ofNullable((Object)((Optional)((Tuple2)tuple._2)._2).orElse(null)))))));
    }
}

