/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.execution.bulkinsert.GlobalSortPartitionerWithRows;
import org.apache.hudi.execution.bulkinsert.NonSortPartitionerWithRows;
import org.apache.hudi.execution.bulkinsert.PartitionSortPartitionerWithRows;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class BulkInsertInternalPartitionerWithRowsFactory {
    public static BulkInsertPartitioner<Dataset<Row>> get(BulkInsertSortMode sortMode) {
        switch (sortMode) {
            case NONE: {
                return new NonSortPartitionerWithRows();
            }
            case GLOBAL_SORT: {
                return new GlobalSortPartitionerWithRows();
            }
            case PARTITION_SORT: {
                return new PartitionSortPartitionerWithRows();
            }
        }
        throw new UnsupportedOperationException("The bulk insert sort mode \"" + sortMode.name() + "\" is not supported.");
    }
}

