/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;

public class RDDCustomColumnsSortPartitioner<T extends HoodieRecordPayload>
implements BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
    private final String[] sortColumnNames;
    private final SerializableSchema serializableSchema;
    private final boolean consistentLogicalTimestampEnabled;

    public RDDCustomColumnsSortPartitioner(HoodieWriteConfig config) {
        this.serializableSchema = new SerializableSchema(new Schema.Parser().parse(config.getSchema()));
        this.sortColumnNames = this.getSortColumnName(config);
        this.consistentLogicalTimestampEnabled = config.isConsistentLogicalTimestampEnabled();
    }

    public RDDCustomColumnsSortPartitioner(String[] columnNames, Schema schema, boolean consistentLogicalTimestampEnabled) {
        this.sortColumnNames = columnNames;
        this.serializableSchema = new SerializableSchema(schema);
        this.consistentLogicalTimestampEnabled = consistentLogicalTimestampEnabled;
    }

    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        String[] sortColumns = this.sortColumnNames;
        SerializableSchema schema = this.serializableSchema;
        boolean consistentLogicalTimestampEnabled = this.consistentLogicalTimestampEnabled;
        return records.sortBy((Function & Serializable)record -> {
            Object recordValue = HoodieAvroUtils.getRecordColumnValues((HoodieRecord)record, (String[])sortColumns, (SerializableSchema)schema, (boolean)consistentLogicalTimestampEnabled);
            if (recordValue == null) {
                return "";
            }
            return StringUtils.objToString((Object)recordValue);
        }, true, outputSparkPartitions);
    }

    public boolean arePartitionRecordsSorted() {
        return true;
    }

    private String[] getSortColumnName(HoodieWriteConfig config) {
        return config.getUserDefinedBulkInsertPartitionerSortColumns().split(",");
    }
}

