/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.HoodieInternalWriteStatus;
import org.apache.hudi.client.model.HoodieInternalRow;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.io.storage.row.HoodieInternalRowFileWriter;
import org.apache.hudi.io.storage.row.HoodieInternalRowFileWriterFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class HoodieRowCreateHandle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(HoodieRowCreateHandle.class);
    private static final AtomicLong SEQGEN = new AtomicLong(1L);
    private final String instantTime;
    private final int taskPartitionId;
    private final long taskId;
    private final long taskEpochId;
    private final HoodieTable table;
    private final HoodieWriteConfig writeConfig;
    protected final HoodieInternalRowFileWriter fileWriter;
    private final String partitionPath;
    private final Path path;
    private final String fileId;
    private final FileSystem fs;
    protected final HoodieInternalWriteStatus writeStatus;
    private final HoodieTimer currTimer;

    public HoodieRowCreateHandle(HoodieTable table, HoodieWriteConfig writeConfig, String partitionPath, String fileId, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType) {
        this.partitionPath = partitionPath;
        this.table = table;
        this.writeConfig = writeConfig;
        this.instantTime = instantTime;
        this.taskPartitionId = taskPartitionId;
        this.taskId = taskId;
        this.taskEpochId = taskEpochId;
        this.fileId = fileId;
        this.currTimer = new HoodieTimer();
        this.currTimer.startTimer();
        this.fs = table.getMetaClient().getFs();
        this.path = this.makeNewPath(partitionPath);
        this.writeStatus = new HoodieInternalWriteStatus(Boolean.valueOf(!table.getIndex().isImplicitWithStorage()), Double.valueOf(writeConfig.getWriteStatusFailureFraction()));
        this.writeStatus.setPartitionPath(partitionPath);
        this.writeStatus.setFileId(fileId);
        this.writeStatus.setStat(new HoodieWriteStat());
        try {
            HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.fs, instantTime, new Path(writeConfig.getBasePath()), FSUtils.getPartitionPath((String)writeConfig.getBasePath(), (String)partitionPath), table.getPartitionMetafileFormat());
            partitionMetadata.trySave(taskPartitionId);
            this.createMarkerFile(partitionPath, FSUtils.makeBaseFileName((String)this.instantTime, (String)this.getWriteToken(), (String)this.fileId, (String)table.getBaseFileExtension()));
            this.fileWriter = this.createNewFileWriter(this.path, table, writeConfig, structType);
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to initialize file writer for path " + this.path, (Throwable)e);
        }
        LOG.info((Object)("New handle created for partition :" + partitionPath + " with fileId " + fileId));
    }

    public void write(InternalRow record) throws IOException {
        try {
            String partitionPath = String.valueOf(record.getUTF8String(HoodieRecord.PARTITION_PATH_META_FIELD_POS));
            String seqId = HoodieRecord.generateSequenceId((String)this.instantTime, (int)this.taskPartitionId, (long)SEQGEN.getAndIncrement());
            String recordKey = String.valueOf(record.getUTF8String(HoodieRecord.RECORD_KEY_META_FIELD_POS));
            HoodieInternalRow internalRow = new HoodieInternalRow(this.instantTime, seqId, recordKey, partitionPath, this.path.getName(), record);
            try {
                this.fileWriter.writeRow(recordKey, internalRow);
                this.writeStatus.markSuccess(recordKey);
            }
            catch (Throwable t) {
                this.writeStatus.markFailure(recordKey, t);
            }
        }
        catch (Throwable ge) {
            this.writeStatus.setGlobalError(ge);
            throw ge;
        }
    }

    public boolean canWrite() {
        return this.fileWriter.canWrite();
    }

    public HoodieInternalWriteStatus close() throws IOException {
        this.fileWriter.close();
        HoodieWriteStat stat = this.writeStatus.getStat();
        stat.setPartitionPath(this.partitionPath);
        stat.setNumWrites(this.writeStatus.getTotalRecords());
        stat.setNumDeletes(0L);
        stat.setNumInserts(this.writeStatus.getTotalRecords());
        stat.setPrevCommit("null");
        stat.setFileId(this.fileId);
        stat.setPath(new Path(this.writeConfig.getBasePath()), this.path);
        long fileSizeInBytes = FSUtils.getFileSize((FileSystem)this.table.getMetaClient().getFs(), (Path)this.path);
        stat.setTotalWriteBytes(fileSizeInBytes);
        stat.setFileSizeInBytes(fileSizeInBytes);
        stat.setTotalWriteErrors(this.writeStatus.getFailedRowsSize());
        HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
        runtimeStats.setTotalCreateTime(this.currTimer.endTimer());
        stat.setRuntimeStats(runtimeStats);
        return this.writeStatus;
    }

    public String getFileName() {
        return this.path.getName();
    }

    private Path makeNewPath(String partitionPath) {
        Path path = FSUtils.getPartitionPath((String)this.writeConfig.getBasePath(), (String)partitionPath);
        try {
            if (!this.fs.exists(path)) {
                this.fs.mkdirs(path);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to make dir " + path, e);
        }
        HoodieTableConfig tableConfig = this.table.getMetaClient().getTableConfig();
        return new Path(path.toString(), FSUtils.makeBaseFileName((String)this.instantTime, (String)this.getWriteToken(), (String)this.fileId, (String)tableConfig.getBaseFileFormat().getFileExtension()));
    }

    private void createMarkerFile(String partitionPath, String dataFileName) {
        WriteMarkersFactory.get((MarkerType)this.writeConfig.getMarkersType(), (HoodieTable)this.table, (String)this.instantTime).create(partitionPath, dataFileName, IOType.CREATE);
    }

    private String getWriteToken() {
        return this.taskPartitionId + "-" + this.taskId + "-" + this.taskEpochId;
    }

    protected HoodieInternalRowFileWriter createNewFileWriter(Path path, HoodieTable hoodieTable, HoodieWriteConfig config, StructType schema) throws IOException {
        return HoodieInternalRowFileWriterFactory.getInternalRowFileWriter(path, hoodieTable, config, schema);
    }
}

