/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.RowKeyGeneratorHelper;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class ComplexKeyGenerator
extends BuiltinKeyGenerator {
    private final ComplexAvroKeyGenerator complexAvroKeyGenerator;

    public ComplexKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.stream(props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.partitionPathFields = Arrays.stream(props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.complexAvroKeyGenerator = new ComplexAvroKeyGenerator(props);
    }

    public String getRecordKey(GenericRecord record) {
        return this.complexAvroKeyGenerator.getRecordKey(record);
    }

    public String getPartitionPath(GenericRecord record) {
        return this.complexAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        this.buildFieldSchemaInfoIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getRecordKeyFromRow(row, this.getRecordKeyFields(), this.recordKeySchemaInfo, true);
    }

    @Override
    public String getPartitionPath(Row row) {
        this.buildFieldSchemaInfoIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getPartitionPathFromRow(row, this.getPartitionPathFields(), this.hiveStylePartitioning, this.partitionPathSchemaInfo);
    }

    @Override
    public String getPartitionPath(InternalRow row, StructType structType) {
        return this.getPartitionPathInternal(row, structType);
    }
}

