/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.services;

import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.guice.GuiceBeanProvider;
import org.apache.isis.applib.services.linking.DeepLinkService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.persistence.adaptermanager.AdapterManagerDefault;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;

@DomainService(nature=NatureOfService.DOMAIN)
public class DeepLinkServiceWicket
implements DeepLinkService {
    @Inject
    private GuiceBeanProvider guiceBeanProvider;

    @Programmatic
    public URI deepLinkFor(Object domainObject) {
        AdapterManagerDefault adapterManager = this.getAdapterManager();
        ObjectAdapter objectAdapter = adapterManager.adapterFor(domainObject);
        PageParameters pageParameters = EntityModel.createPageParameters((ObjectAdapter)objectAdapter);
        PageClassRegistry pageClassRegistry = (PageClassRegistry)this.guiceBeanProvider.lookup(PageClassRegistry.class);
        Class pageClass = pageClassRegistry.getPageClass(PageType.ENTITY);
        RequestCycle requestCycle = RequestCycle.get();
        CharSequence urlForPojo = requestCycle.urlFor(pageClass, pageParameters);
        String fullUrl = requestCycle.getUrlRenderer().renderFullUrl(Url.parse((CharSequence)urlForPojo));
        try {
            return new URI(fullUrl);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Cannot create a deep link to domain object: " + domainObject, ex);
        }
    }

    protected AdapterManagerDefault getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }
}

