/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AdminClientUnitTestEnv;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAdminClientTest {
    private static final Logger log = LoggerFactory.getLogger(KafkaAdminClientTest.class);
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);
    private static final AclBinding ACL1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
    private static final AclBinding ACL2 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic4", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.DENY));
    private static final AclBindingFilter FILTER1 = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), new AccessControlEntryFilter("User:ANONYMOUS", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter FILTER2 = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY));
    private static final AclBindingFilter UNKNOWN_FILTER = new AclBindingFilter(new ResourcePatternFilter(ResourceType.UNKNOWN, null, PatternType.LITERAL), new AccessControlEntryFilter("User:bob", null, AclOperation.ANY, AclPermissionType.ANY));

    @Test
    public void testDefaultApiTimeoutAndRequestTimeoutConflicts() {
        AdminClientConfig config = KafkaAdminClientTest.newConfMap("default.api.timeout.ms", "500");
        KafkaException exception = (KafkaException)Assert.assertThrows(KafkaException.class, () -> KafkaAdminClient.createInternal((AdminClientConfig)config, null));
        Assert.assertTrue((boolean)(exception.getCause() instanceof ConfigException));
    }

    @Test
    public void testGetOrCreateListValue() {
        HashMap map = new HashMap();
        List fooList = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assert.assertNotNull((Object)fooList);
        fooList.add("a");
        fooList.add("b");
        List fooList2 = KafkaAdminClient.getOrCreateListValue(map, (Object)"foo");
        Assert.assertEquals((Object)fooList, (Object)fooList2);
        Assert.assertTrue((boolean)fooList2.contains("a"));
        Assert.assertTrue((boolean)fooList2.contains("b"));
        List barList = KafkaAdminClient.getOrCreateListValue(map, (Object)"bar");
        Assert.assertNotNull((Object)barList);
        Assert.assertTrue((boolean)barList.isEmpty());
    }

    @Test
    public void testCalcTimeoutMsRemainingAsInt() {
        Assert.assertEquals((long)0L, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1000L));
        Assert.assertEquals((long)100L, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)1000L, (long)1100L));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)0L, (long)Long.MAX_VALUE));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)KafkaAdminClient.calcTimeoutMsRemainingAsInt((long)Long.MAX_VALUE, (long)0L));
    }

    @Test
    public void testPrettyPrintException() {
        Assert.assertEquals((Object)"Null exception.", (Object)KafkaAdminClient.prettyPrintException(null));
        Assert.assertEquals((Object)"TimeoutException", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException()));
        Assert.assertEquals((Object)"TimeoutException: The foobar timed out.", (Object)KafkaAdminClient.prettyPrintException((Throwable)new TimeoutException("The foobar timed out.")));
    }

    private static Map<String, Object> newStrMap(String ... vals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", "localhost:8121");
        map.put("request.timeout.ms", "1000");
        if (vals.length % 2 != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < vals.length; i += 2) {
            map.put(vals[i], vals[i + 1]);
        }
        return map;
    }

    private static AdminClientConfig newConfMap(String ... vals) {
        return new AdminClientConfig(KafkaAdminClientTest.newStrMap(vals));
    }

    @Test
    public void testGenerateClientId() {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            String id = KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", ""));
            Assert.assertTrue((String)("Got duplicate id " + id), (!ids.contains(id) ? 1 : 0) != 0);
            ids.add(id);
        }
        Assert.assertEquals((Object)"myCustomId", (Object)KafkaAdminClient.generateClientId((AdminClientConfig)KafkaAdminClientTest.newConfMap("client.id", "myCustomId")));
    }

    private static Cluster mockCluster(int numNodes, int controllerIndex) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.put(i, new Node(i, "localhost", 8121 + i));
        }
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(controllerIndex));
    }

    private static Cluster mockBootstrapCluster() {
        return Cluster.bootstrap((List)ClientUtils.parseAndValidateAddresses(Collections.singletonList("localhost:8121"), (ClientDnsLookup)ClientDnsLookup.DEFAULT));
    }

    private static AdminClientUnitTestEnv mockClientEnv(String ... configVals) {
        return new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(3, 0), configVals);
    }

    @Test
    public void testCloseAdminClient() {
        AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);
        Throwable throwable = null;
        if (env != null) {
            if (throwable != null) {
                try {
                    env.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                env.close();
            }
        }
    }

    @Test(timeout=10000L)
    public void testCloseAdminClientInCallback() throws InterruptedException {
        MockTime time = new MockTime();
        AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0));
        ListTopicsResult result = env.adminClient().listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(1000)));
        KafkaFuture kafkaFuture = result.listings();
        Semaphore callbackCalled = new Semaphore(0);
        kafkaFuture.whenComplete((topicListings, throwable) -> {
            env.close();
            callbackCalled.release();
        });
        time.sleep(2000L);
        callbackCalled.acquire();
    }

    private static OffsetDeleteResponse prepareOffsetDeleteResponse(Errors error) {
        return new OffsetDeleteResponse(new OffsetDeleteResponseData().setErrorCode(error.code()).setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection()));
    }

    private static OffsetDeleteResponse prepareOffsetDeleteResponse(String topic, int partition, Errors error) {
        return new OffsetDeleteResponse(new OffsetDeleteResponseData().setErrorCode(Errors.NONE.code()).setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Stream.of(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topic).setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partition).setErrorCode(error.code())).iterator()))).collect(Collectors.toList()).iterator())));
    }

    private static OffsetCommitResponse prepareOffsetCommitResponse(TopicPartition tp, Errors error) {
        HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
        responseData.put(tp, error);
        return new OffsetCommitResponse(0, responseData);
    }

    private static CreateTopicsResponse prepareCreateTopicsResponse(String topicName, Errors error) {
        CreateTopicsResponseData data = new CreateTopicsResponseData();
        data.topics().add(new CreateTopicsResponseData.CreatableTopicResult().setName(topicName).setErrorCode(error.code()));
        return new CreateTopicsResponse(data);
    }

    private static DeleteTopicsResponse prepareDeleteTopicsResponse(String topicName, Errors error) {
        DeleteTopicsResponseData data = new DeleteTopicsResponseData();
        data.responses().add(new DeleteTopicsResponseData.DeletableTopicResult().setName(topicName).setErrorCode(error.code()));
        return new DeleteTopicsResponse(data);
    }

    private static FindCoordinatorResponse prepareFindCoordinatorResponse(Errors error, Node node) {
        return FindCoordinatorResponse.prepareResponse((Errors)error, (Node)node);
    }

    private static MetadataResponse prepareMetadataResponse(Cluster cluster, Errors error) {
        ArrayList<MetadataResponse.TopicMetadata> metadata = new ArrayList<MetadataResponse.TopicMetadata>();
        for (String topic : cluster.topics()) {
            ArrayList<MetadataResponse.PartitionMetadata> pms = new ArrayList<MetadataResponse.PartitionMetadata>();
            for (PartitionInfo pInfo : cluster.availablePartitionsForTopic(topic)) {
                MetadataResponse.PartitionMetadata pm = new MetadataResponse.PartitionMetadata(error, new TopicPartition(topic, pInfo.partition()), Optional.of(pInfo.leader().id()), Optional.of(234), Arrays.stream(pInfo.replicas()).map(Node::id).collect(Collectors.toList()), Arrays.stream(pInfo.inSyncReplicas()).map(Node::id).collect(Collectors.toList()), Arrays.stream(pInfo.offlineReplicas()).map(Node::id).collect(Collectors.toList()));
                pms.add(pm);
            }
            MetadataResponse.TopicMetadata tm = new MetadataResponse.TopicMetadata(error, topic, false, pms);
            metadata.add(tm);
        }
        return MetadataResponse.prepareResponse((int)0, (Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), metadata, (int)Integer.MIN_VALUE);
    }

    @Test
    public void testTimeoutWithoutMetadata() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, KafkaAdminClientTest.mockBootstrapCluster(), KafkaAdminClientTest.newStrMap("request.timeout.ms", "10"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000))).all();
            TestUtils.assertFutureError(future, TimeoutException.class);
        }
    }

    @Test
    public void testConnectionFailureOnMetadataUpdate() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockBootstrapCluster();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster);){
            Cluster discoveredCluster = KafkaAdminClientTest.mockCluster(3, 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, null, true);
            env.kafkaClient().prepareResponse(request -> request instanceof MetadataRequest, (AbstractResponse)MetadataResponse.prepareResponse((Collection)discoveredCluster.nodes(), (String)discoveredCluster.clusterResource().clusterId(), (int)1, Collections.emptyList()));
            env.kafkaClient().prepareResponse(body -> body instanceof CreateTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testUnreachableBootstrapServer() throws Exception {
        Cluster cluster = Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 8121)));
        Map<Node, Long> unreachableNodes = Collections.singletonMap(cluster.nodes().get(0), 200L);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster, AdminClientUnitTestEnv.clientConfigs(new String[0]), unreachableNodes);){
            Cluster discoveredCluster = KafkaAdminClientTest.mockCluster(3, 0);
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(body -> body instanceof MetadataRequest, (AbstractResponse)MetadataResponse.prepareResponse((Collection)discoveredCluster.nodes(), (String)discoveredCluster.clusterResource().clusterId(), (int)1, Collections.emptyList()));
            env.kafkaClient().prepareResponse(body -> body instanceof CreateTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testPropagatedMetadataFetchException() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("bootstrap.servers", "localhost:8121", "request.timeout.ms", "10"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().createPendingAuthenticationError(env.cluster().nodeById(0), TimeUnit.DAYS.toMillis(1L));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000))).all();
            TestUtils.assertFutureError(future, SaslAuthenticationException.class);
        }
    }

    @Test
    public void testCreateTopics() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(body -> body instanceof CreateTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testCreateTopicsRetryBackoff() throws Exception {
        MockTime time = new MockTime();
        int retryBackoff = 100;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, KafkaAdminClientTest.mockCluster(3, 0), KafkaAdminClientTest.newStrMap("retry.backoff.ms", "" + retryBackoff));){
            MockClient mockClient = env.kafkaClient();
            mockClient.setNodeApiVersions(NodeApiVersions.create());
            AtomicLong firstAttemptTime = new AtomicLong(0L);
            AtomicLong secondAttemptTime = new AtomicLong(0L);
            mockClient.prepareResponse(body -> {
                firstAttemptTime.set(time.milliseconds());
                return body instanceof CreateTopicsRequest;
            }, null, true);
            mockClient.prepareResponse(body -> {
                secondAttemptTime.set(time.milliseconds());
                return body instanceof CreateTopicsRequest;
            }, (AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            TestUtils.waitForCondition(() -> mockClient.numAwaitingResponses() == 1, "Failed awaiting CreateTopics first request failure");
            TestUtils.waitForCondition(() -> ((KafkaAdminClient)env.adminClient()).numPendingCalls() == 1, "Failed to add retry CreateTopics call");
            time.sleep(retryBackoff);
            future.get();
            long actualRetryBackoff = secondAttemptTime.get() - firstAttemptTime.get();
            Assert.assertEquals((String)"CreateTopics retry did not await expected backoff", (long)retryBackoff, (long)actualRetryBackoff);
        }
    }

    @Test
    public void testCreateTopicsHandleNotControllerException() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NOT_CONTROLLER), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)KafkaAdminClientTest.prepareCreateTopicsResponse("myTopic", Errors.NONE), env.cluster().nodeById(1));
            KafkaFuture future = env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all();
            future.get();
        }
    }

    @Test
    public void testDeleteTopics() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse(body -> body instanceof DeleteTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.NONE));
            KafkaFuture future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            future.get();
            env.kafkaClient().prepareResponse(body -> body instanceof DeleteTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.TOPIC_DELETION_DISABLED));
            future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureError(future, TopicDeletionDisabledException.class);
            env.kafkaClient().prepareResponse(body -> body instanceof DeleteTopicsRequest, (AbstractResponse)KafkaAdminClientTest.prepareDeleteTopicsResponse("myTopic", Errors.UNKNOWN_TOPIC_OR_PARTITION));
            future = env.adminClient().deleteTopics(Collections.singletonList("myTopic"), new DeleteTopicsOptions()).all();
            TestUtils.assertFutureError(future, UnknownTopicOrPartitionException.class);
        }
    }

    @Test
    public void testInvalidTopicNames() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            List<String> sillyTopicNames = Arrays.asList("", null);
            Map deleteFutures = env.adminClient().deleteTopics(sillyTopicNames).values();
            for (String string : sillyTopicNames) {
                TestUtils.assertFutureError((Future)deleteFutures.get(string), InvalidTopicException.class);
            }
            Assert.assertEquals((long)0L, (long)env.kafkaClient().inFlightRequestCount());
            Map describeFutures = env.adminClient().describeTopics(sillyTopicNames).values();
            for (String string : sillyTopicNames) {
                TestUtils.assertFutureError((Future)describeFutures.get(string), InvalidTopicException.class);
            }
            Assert.assertEquals((long)0L, (long)env.kafkaClient().inFlightRequestCount());
            ArrayList<NewTopic> arrayList = new ArrayList<NewTopic>();
            for (String sillyTopicName : sillyTopicNames) {
                arrayList.add(new NewTopic(sillyTopicName, 1, 1));
            }
            Map map = env.adminClient().createTopics(arrayList).values();
            for (String sillyTopicName : sillyTopicNames) {
                TestUtils.assertFutureError((Future)map.get(sillyTopicName), InvalidTopicException.class);
            }
            Assert.assertEquals((long)0L, (long)env.kafkaClient().inFlightRequestCount());
        }
    }

    @Test
    public void testMetadataRetries() throws Exception {
        String topic = "topic";
        Cluster bootstrapCluster = Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 9999)));
        Cluster initializedCluster = KafkaAdminClientTest.mockCluster(3, 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, bootstrapCluster, KafkaAdminClientTest.newStrMap("bootstrap.servers", "localhost:9999", "default.api.timeout.ms", "10000000", "retries", "0"));){
            env.kafkaClient().prepareResponse(null, true);
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)initializedCluster.nodes(), (String)initializedCluster.clusterResource().clusterId(), (int)initializedCluster.controller().id(), Collections.emptyList()));
            Node leader = (Node)initializedCluster.nodes().get(0);
            MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition(topic, 0), Optional.of(leader.id()), Optional.of(10), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()), Collections.singletonList(leader.id()));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)initializedCluster.nodes(), (String)initializedCluster.clusterResource().clusterId(), (int)1, Collections.singletonList(new MetadataResponse.TopicMetadata(Errors.NONE, topic, false, Collections.singletonList(partitionMetadata), Integer.MIN_VALUE))));
            DescribeTopicsResult result = env.adminClient().describeTopics(Collections.singleton(topic));
            Map topicDescriptions = (Map)result.all().get();
            Assert.assertEquals((Object)leader, (Object)((TopicPartitionInfo)((TopicDescription)topicDescriptions.get(topic)).partitions().get(0)).leader());
            Assert.assertEquals(null, (Object)((TopicDescription)topicDescriptions.get(topic)).authorizedOperations());
        }
    }

    @Test
    public void testAdminClientApisAuthenticationFailure() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockBootstrapCluster();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(Time.SYSTEM, cluster, KafkaAdminClientTest.newStrMap("request.timeout.ms", "1000"));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().createPendingAuthenticationError((Node)cluster.nodes().get(0), TimeUnit.DAYS.toMillis(1L));
            this.callAdminClientApisAndExpectAnAuthenticationError(env);
        }
    }

    private void callAdminClientApisAndExpectAnAuthenticationError(AdminClientUnitTestEnv env) throws InterruptedException {
        try {
            env.adminClient().createTopics(Collections.singleton(new NewTopic("myTopic", Collections.singletonMap(0, Arrays.asList(0, 1, 2)))), new CreateTopicsOptions().timeoutMs(Integer.valueOf(10000))).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("my_topic", NewPartitions.increaseTo((int)3));
            counts.put("other_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(2), Arrays.asList(3))));
            env.adminClient().createPartitions(counts).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            env.adminClient().createAcls(Arrays.asList(ACL1, ACL2)).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            env.adminClient().describeAcls(FILTER1).values().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2)).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
        try {
            env.adminClient().describeConfigs(Collections.singleton(new ConfigResource(ConfigResource.Type.BROKER, "0"))).all().get();
            Assert.fail((String)"Expected an authentication error.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)("Expected an authentication error, but got " + Utils.stackTrace((Throwable)e)), (boolean)(e.getCause() instanceof AuthenticationException));
        }
    }

    @Test
    public void testDescribeAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData().setResources(DescribeAclsResponse.aclsResources(Arrays.asList(ACL1, ACL2)))));
            KafkaAdminClientTest.assertCollectionIs((Collection)env.adminClient().describeAcls(FILTER1).values().get(), ACL1, ACL2);
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData()));
            Assert.assertTrue((boolean)((Collection)env.adminClient().describeAcls(FILTER2).values().get()).isEmpty());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeAclsResponse(new DescribeAclsResponseData().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("Security is disabled")));
            TestUtils.assertFutureError(env.adminClient().describeAcls(FILTER2).values(), SecurityDisabledException.class);
            TestUtils.assertFutureError(env.adminClient().describeAcls(UNKNOWN_FILTER).values(), InvalidRequestException.class);
        }
    }

    @Test
    public void testCreateAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult(), new CreateAclsResponseData.AclCreationResult()))));
            CreateAclsResult results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            for (KafkaFuture future : results.values().values()) {
                future.get();
            }
            results.all().get();
            env.kafkaClient().prepareResponse((AbstractResponse)new CreateAclsResponse(new CreateAclsResponseData().setResults(Arrays.asList(new CreateAclsResponseData.AclCreationResult().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("Security is disabled"), new CreateAclsResponseData.AclCreationResult()))));
            results = env.adminClient().createAcls(Arrays.asList(ACL1, ACL2));
            KafkaAdminClientTest.assertCollectionIs(results.values().keySet(), ACL1, ACL2);
            TestUtils.assertFutureError((Future)results.values().get(ACL1), SecurityDisabledException.class);
            ((KafkaFuture)results.values().get(ACL2)).get();
            TestUtils.assertFutureError(results.all(), SecurityDisabledException.class);
        }
    }

    @Test
    public void testDeleteAcls() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE), DeleteAclsResponse.matchingAcl((AclBinding)ACL2, (ApiError)ApiError.NONE))), new DeleteAclsResponseData.DeleteAclsFilterResult().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No security")))));
            DeleteAclsResult results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Map filterResults = results.values();
            DeleteAclsResult.FilterResults filter1Results = (DeleteAclsResult.FilterResults)((KafkaFuture)filterResults.get(FILTER1)).get();
            Assert.assertEquals(null, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).exception());
            Assert.assertEquals((Object)ACL1, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(0)).binding());
            Assert.assertEquals(null, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).exception());
            Assert.assertEquals((Object)ACL2, (Object)((DeleteAclsResult.FilterResult)filter1Results.values().get(1)).binding());
            TestUtils.assertFutureError((Future)filterResults.get(FILTER2), SecurityDisabledException.class);
            TestUtils.assertFutureError(results.all(), SecurityDisabledException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE), new DeleteAclsResponseData.DeleteAclsMatchingAcl().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No security"))), new DeleteAclsResponseData.DeleteAclsFilterResult()))));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Assert.assertTrue((boolean)((DeleteAclsResult.FilterResults)((KafkaFuture)results.values().get(FILTER2)).get()).values().isEmpty());
            TestUtils.assertFutureError(results.all(), SecurityDisabledException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(0).setFilterResults(Arrays.asList(new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL1, (ApiError)ApiError.NONE))), new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(DeleteAclsResponse.matchingAcl((AclBinding)ACL2, (ApiError)ApiError.NONE)))))));
            results = env.adminClient().deleteAcls(Arrays.asList(FILTER1, FILTER2));
            Collection deleted = (Collection)results.all().get();
            KafkaAdminClientTest.assertCollectionIs(deleted, ACL1, ACL2);
        }
    }

    @Test
    public void testElectLeaders() throws Exception {
        TopicPartition topic1 = new TopicPartition("topic", 0);
        TopicPartition topic2 = new TopicPartition("topic", 2);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            for (ElectionType electionType : ElectionType.values()) {
                env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
                ApiError value = ApiError.fromThrowable((Throwable)new ClusterAuthorizationException(null));
                ArrayList<ElectLeadersResponseData.ReplicaElectionResult> electionResults = new ArrayList<ElectLeadersResponseData.ReplicaElectionResult>();
                ElectLeadersResponseData.ReplicaElectionResult electionResult = new ElectLeadersResponseData.ReplicaElectionResult();
                electionResult.setTopic(topic1.topic());
                ElectLeadersResponseData.PartitionResult partition1Result = new ElectLeadersResponseData.PartitionResult();
                partition1Result.setPartitionId(topic1.partition());
                partition1Result.setErrorCode(value.error().code());
                partition1Result.setErrorMessage(value.message());
                electionResult.partitionResult().add(partition1Result);
                ElectLeadersResponseData.PartitionResult partition2Result = new ElectLeadersResponseData.PartitionResult();
                partition2Result.setPartitionId(topic2.partition());
                partition2Result.setErrorCode(value.error().code());
                partition2Result.setErrorMessage(value.message());
                electionResult.partitionResult().add(partition2Result);
                electionResults.add(electionResult);
                env.kafkaClient().prepareResponse((AbstractResponse)new ElectLeadersResponse(0, Errors.NONE.code(), electionResults));
                ElectLeadersResult results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)));
                Assert.assertEquals(((Throwable)((Optional)((Map)results.partitions().get()).get(topic2)).get()).getClass(), ClusterAuthorizationException.class);
                partition1Result.setErrorCode(ApiError.NONE.error().code());
                partition1Result.setErrorMessage(ApiError.NONE.message());
                partition2Result.setErrorCode(ApiError.NONE.error().code());
                partition2Result.setErrorMessage(ApiError.NONE.message());
                env.kafkaClient().prepareResponse((AbstractResponse)new ElectLeadersResponse(0, Errors.NONE.code(), electionResults));
                results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)));
                Assert.assertFalse((boolean)((Optional)((Map)results.partitions().get()).get(topic1)).isPresent());
                Assert.assertFalse((boolean)((Optional)((Map)results.partitions().get()).get(topic2)).isPresent());
                results = env.adminClient().electLeaders(electionType, new HashSet<TopicPartition>(Arrays.asList(topic1, topic2)), (ElectLeadersOptions)new ElectLeadersOptions().timeoutMs(Integer.valueOf(100)));
                TestUtils.assertFutureError(results.partitions(), TimeoutException.class);
            }
        }
    }

    @Test
    public void testDescribeConfigs() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeConfigsResponse(0, Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, "0"), new DescribeConfigsResponse.Config(ApiError.NONE, Collections.emptySet()))));
            DescribeConfigsResult result2 = env.adminClient().describeConfigs(Collections.singleton(new ConfigResource(ConfigResource.Type.BROKER, "0")));
            result2.all().get();
        }
    }

    @Test
    public void testCreatePartitions() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            LinkedList<CreatePartitionsResponseData.CreatePartitionsTopicResult> createPartitionsResult = new LinkedList<CreatePartitionsResponseData.CreatePartitionsTopicResult>();
            createPartitionsResult.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("my_topic").setErrorCode(Errors.NONE.code()));
            createPartitionsResult.add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("other_topic").setErrorCode(Errors.INVALID_TOPIC_EXCEPTION.code()).setErrorMessage("some detailed reason"));
            CreatePartitionsResponseData data = new CreatePartitionsResponseData().setThrottleTimeMs(42).setResults(createPartitionsResult);
            env.kafkaClient().prepareResponse((AbstractResponse)new CreatePartitionsResponse(data));
            HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
            counts.put("my_topic", NewPartitions.increaseTo((int)3));
            counts.put("other_topic", NewPartitions.increaseTo((int)3, Arrays.asList(Arrays.asList(2), Arrays.asList(3))));
            CreatePartitionsResult results = env.adminClient().createPartitions(counts);
            Map values = results.values();
            KafkaFuture myTopicResult = (KafkaFuture)values.get("my_topic");
            myTopicResult.get();
            KafkaFuture otherTopicResult = (KafkaFuture)values.get("other_topic");
            try {
                otherTopicResult.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e0) {
                Assert.assertTrue((boolean)(e0.getCause() instanceof InvalidTopicException));
                InvalidTopicException e = (InvalidTopicException)e0.getCause();
                Assert.assertEquals((Object)"some detailed reason", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testDeleteRecordsTopicAuthorizationError() {
        String topic = "foo";
        TopicPartition partition = new TopicPartition(topic, 0);
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
            topics.add(new MetadataResponse.TopicMetadata(Errors.TOPIC_AUTHORIZATION_FAILED, topic, false, Collections.emptyList()));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)env.cluster().controller().id(), topics));
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(partition, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            TestUtils.assertFutureThrows((Future)results.lowWatermarks().get(partition), TopicAuthorizationException.class);
        }
    }

    @Test
    public void testDeleteRecordsMultipleSends() throws Exception {
        String topic = "foo";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(time, KafkaAdminClientTest.mockCluster(3, 0));){
            List nodes = env.cluster().nodes();
            ArrayList<MetadataResponse.PartitionMetadata> partitionMetadata = new ArrayList<MetadataResponse.PartitionMetadata>();
            partitionMetadata.add(new MetadataResponse.PartitionMetadata(Errors.NONE, tp0, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            partitionMetadata.add(new MetadataResponse.PartitionMetadata(Errors.NONE, tp1, Optional.of(((Node)nodes.get(1)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(1)).id()), Collections.singletonList(((Node)nodes.get(1)).id()), Collections.emptyList()));
            ArrayList<MetadataResponse.TopicMetadata> topicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
            topicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, topic, false, partitionMetadata));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)env.cluster().controller().id(), topicMetadata));
            HashMap<TopicPartition, DeleteRecordsResponse.PartitionResponse> deletedPartitions = new HashMap<TopicPartition, DeleteRecordsResponse.PartitionResponse>();
            deletedPartitions.put(tp0, new DeleteRecordsResponse.PartitionResponse(3L, Errors.NONE));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new DeleteRecordsResponse(0, deletedPartitions), (Node)nodes.get(0));
            env.kafkaClient().disconnect(((Node)nodes.get(1)).idString());
            env.kafkaClient().createPendingAuthenticationError((Node)nodes.get(1), 100L);
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(tp0, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(tp1, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            Assert.assertEquals((long)3L, (long)((DeletedRecords)((KafkaFuture)results.lowWatermarks().get(tp0)).get()).lowWatermark());
            TestUtils.assertFutureThrows((Future)results.lowWatermarks().get(tp1), AuthenticationException.class);
        }
    }

    @Test
    public void testDeleteRecords() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>();
        partitionInfos.add(new PartitionInfo("my_topic", 0, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 1, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 2, null, new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 3, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        partitionInfos.add(new PartitionInfo("my_topic", 4, (Node)nodes.get(0), new Node[]{(Node)nodes.get(0)}, new Node[]{(Node)nodes.get(0)}));
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), partitionInfos, Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
        TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
        TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
        TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
        TopicPartition myTopicPartition4 = new TopicPartition("my_topic", 4);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            HashMap<TopicPartition, DeleteRecordsResponse.PartitionResponse> m = new HashMap<TopicPartition, DeleteRecordsResponse.PartitionResponse>();
            m.put(myTopicPartition0, new DeleteRecordsResponse.PartitionResponse(3L, Errors.NONE));
            m.put(myTopicPartition1, new DeleteRecordsResponse.PartitionResponse(-1L, Errors.OFFSET_OUT_OF_RANGE));
            m.put(myTopicPartition3, new DeleteRecordsResponse.PartitionResponse(-1L, Errors.NOT_LEADER_FOR_PARTITION));
            m.put(myTopicPartition4, new DeleteRecordsResponse.PartitionResponse(-1L, Errors.UNKNOWN_TOPIC_OR_PARTITION));
            ArrayList<MetadataResponse.TopicMetadata> t = new ArrayList<MetadataResponse.TopicMetadata>();
            ArrayList<MetadataResponse.PartitionMetadata> p = new ArrayList<MetadataResponse.PartitionMetadata>();
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, myTopicPartition0, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, myTopicPartition1, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.LEADER_NOT_AVAILABLE, myTopicPartition2, Optional.empty(), Optional.empty(), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, myTopicPartition3, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            p.add(new MetadataResponse.PartitionMetadata(Errors.NONE, myTopicPartition4, Optional.of(((Node)nodes.get(0)).id()), Optional.of(5), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.singletonList(((Node)nodes.get(0)).id()), Collections.emptyList()));
            t.add(new MetadataResponse.TopicMetadata(Errors.NONE, "my_topic", false, p));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)cluster.nodes(), (String)cluster.clusterResource().clusterId(), (int)cluster.controller().id(), t));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteRecordsResponse(0, m));
            HashMap<TopicPartition, RecordsToDelete> recordsToDelete = new HashMap<TopicPartition, RecordsToDelete>();
            recordsToDelete.put(myTopicPartition0, RecordsToDelete.beforeOffset((long)3L));
            recordsToDelete.put(myTopicPartition1, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition2, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition3, RecordsToDelete.beforeOffset((long)10L));
            recordsToDelete.put(myTopicPartition4, RecordsToDelete.beforeOffset((long)10L));
            DeleteRecordsResult results = env.adminClient().deleteRecords(recordsToDelete);
            Map values = results.lowWatermarks();
            KafkaFuture myTopicPartition0Result = (KafkaFuture)values.get(myTopicPartition0);
            long lowWatermark = ((DeletedRecords)myTopicPartition0Result.get()).lowWatermark();
            Assert.assertEquals((long)lowWatermark, (long)3L);
            KafkaFuture myTopicPartition1Result = (KafkaFuture)values.get(myTopicPartition1);
            try {
                myTopicPartition1Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e0) {
                Assert.assertTrue((boolean)(e0.getCause() instanceof OffsetOutOfRangeException));
            }
            KafkaFuture myTopicPartition2Result = (KafkaFuture)values.get(myTopicPartition2);
            try {
                myTopicPartition2Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assert.assertTrue((boolean)(e1.getCause() instanceof LeaderNotAvailableException));
            }
            KafkaFuture myTopicPartition3Result = (KafkaFuture)values.get(myTopicPartition3);
            try {
                myTopicPartition3Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assert.assertTrue((boolean)(e1.getCause() instanceof NotLeaderForPartitionException));
            }
            KafkaFuture myTopicPartition4Result = (KafkaFuture)values.get(myTopicPartition4);
            try {
                myTopicPartition4Result.get();
                Assert.fail((String)"get() should throw ExecutionException");
            }
            catch (ExecutionException e1) {
                Assert.assertTrue((boolean)(e1.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @Test
    public void testDescribeCluster() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            MetadataResponse response = MetadataResponse.prepareResponse((int)0, (Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)2, Collections.emptyList(), (int)Integer.MIN_VALUE);
            env.kafkaClient().prepareResponse((AbstractResponse)response);
            MetadataResponse response2 = MetadataResponse.prepareResponse((int)0, (Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)3, Collections.emptyList(), (int)(1 << AclOperation.DESCRIBE.code() | 1 << AclOperation.ALTER.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)response2);
            DescribeClusterResult result = env.adminClient().describeCluster();
            Assert.assertEquals((Object)env.cluster().clusterResource().clusterId(), (Object)result.clusterId().get());
            Assert.assertEquals((long)2L, (long)((Node)result.controller().get()).id());
            Assert.assertEquals(null, (Object)result.authorizedOperations().get());
            DescribeClusterResult result2 = env.adminClient().describeCluster();
            Assert.assertEquals((Object)env.cluster().clusterResource().clusterId(), (Object)result2.clusterId().get());
            Assert.assertEquals((long)3L, (long)((Node)result2.controller().get()).id());
            Assert.assertEquals(new HashSet<AclOperation>(Arrays.asList(AclOperation.DESCRIBE, AclOperation.ALTER)), (Object)result2.authorizedOperations().get());
        }
    }

    @Test
    public void testListConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(4, 0), "retries", "2");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse(Collections.emptyList(), (String)env.cluster().clusterResource().clusterId(), (int)-1, Collections.emptyList()));
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)env.cluster().controller().id(), Collections.emptyList()));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-1").setProtocolType("consumer"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-1").setProtocolType("connector")))), env.cluster().nodeById(0));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-2").setProtocolType("consumer"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-2").setProtocolType("connector")))), env.cluster().nodeById(1));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.NONE.code()).setGroups(Arrays.asList(new ListGroupsResponseData.ListedGroup().setGroupId("group-3").setProtocolType("consumer"), new ListGroupsResponseData.ListedGroup().setGroupId("group-connect-3").setProtocolType("connector")))), env.cluster().nodeById(2));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListGroupsResponse(new ListGroupsResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setGroups(Collections.emptyList())), env.cluster().nodeById(3));
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups();
            TestUtils.assertFutureError(result.all(), UnknownServerException.class);
            Collection listings = (Collection)result.valid().get();
            Assert.assertEquals((long)3L, (long)listings.size());
            HashSet<String> groupIds = new HashSet<String>();
            for (ConsumerGroupListing listing : listings) {
                groupIds.add(listing.groupId());
            }
            Assert.assertEquals((Object)Utils.mkSet((Object[])new String[]{"group-1", "group-2", "group-3"}), groupIds);
            Assert.assertEquals((long)1L, (long)((Collection)result.errors().get()).size());
        }
    }

    @Test
    public void testListConsumerGroupsMetadataFailure() throws Exception {
        Cluster cluster = KafkaAdminClientTest.mockCluster(3, 0);
        MockTime time = new MockTime();
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retries", "0");){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)MetadataResponse.prepareResponse(Collections.emptyList(), (String)env.cluster().clusterResource().clusterId(), (int)-1, Collections.emptyList()));
            ListConsumerGroupsResult result = env.adminClient().listConsumerGroups();
            TestUtils.assertFutureError(result.all(), KafkaException.class);
        }
    }

    @Test
    public void testDescribeConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.COORDINATOR_LOAD_IN_PROGRESS, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.COORDINATOR_NOT_AVAILABLE, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NOT_COORDINATOR, (String)"", (String)"", (String)"", Collections.emptyList(), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            data = new DescribeGroupsResponseData();
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            topicPartitions.add(0, myTopicPartition0);
            topicPartitions.add(1, myTopicPartition1);
            topicPartitions.add(2, myTopicPartition2);
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            DescribeGroupsResponseData.DescribedGroupMember memberOne = DescribeGroupsResponse.groupMember((String)"0", (String)"instance1", (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null);
            DescribeGroupsResponseData.DescribedGroupMember memberTwo = DescribeGroupsResponse.groupMember((String)"1", (String)"instance2", (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null);
            ArrayList<MemberDescription> expectedMemberDescriptions = new ArrayList<MemberDescription>();
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToMemberDescriptions(memberOne, new MemberAssignment(new HashSet(topicPartitions))));
            expectedMemberDescriptions.add(KafkaAdminClientTest.convertToMemberDescriptions(memberTwo, new MemberAssignment(new HashSet(topicPartitions))));
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Arrays.asList(memberOne, memberTwo), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList("group-0"));
            ConsumerGroupDescription groupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get("group-0")).get();
            Assert.assertEquals((long)1L, (long)result.describedGroups().size());
            Assert.assertEquals((Object)"group-0", (Object)groupDescription.groupId());
            Assert.assertEquals((long)2L, (long)groupDescription.members().size());
            Assert.assertEquals(expectedMemberDescriptions, (Object)groupDescription.members());
        }
    }

    @Test
    public void testDescribeMultipleConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            topicPartitions.add(0, myTopicPartition0);
            topicPartitions.add(1, myTopicPartition1);
            topicPartitions.add(2, myTopicPartition2);
            ByteBuffer memberAssignment = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(topicPartitions));
            byte[] memberAssignmentBytes = new byte[memberAssignment.remaining()];
            memberAssignment.get(memberAssignmentBytes);
            DescribeGroupsResponseData group0Data = new DescribeGroupsResponseData();
            group0Data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Arrays.asList(DescribeGroupsResponse.groupMember((String)"0", null, (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null), DescribeGroupsResponse.groupMember((String)"1", null, (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null)), Collections.emptySet()));
            DescribeGroupsResponseData groupConnectData = new DescribeGroupsResponseData();
            group0Data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-connect-0", (Errors)Errors.NONE, (String)"", (String)"connect", (String)"", Arrays.asList(DescribeGroupsResponse.groupMember((String)"0", null, (String)"clientId0", (String)"clientHost", (byte[])memberAssignmentBytes, null), DescribeGroupsResponse.groupMember((String)"1", null, (String)"clientId1", (String)"clientHost", (byte[])memberAssignmentBytes, null)), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(group0Data));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(groupConnectData));
            HashSet<String> groups = new HashSet<String>();
            groups.add("group-0");
            groups.add("group-connect-0");
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(groups);
            Assert.assertEquals((long)2L, (long)result.describedGroups().size());
            Assert.assertEquals(groups, result.describedGroups().keySet());
        }
    }

    @Test
    public void testDescribeConsumerGroupsWithAuthorizedOperationsOmitted() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NONE, (String)"", (String)"consumer", (String)"", Collections.emptyList(), (int)Integer.MIN_VALUE));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList("group-0"));
            ConsumerGroupDescription groupDescription = (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get("group-0")).get();
            Assert.assertNull((Object)groupDescription.authorizedOperations());
        }
    }

    @Test
    public void testDescribeNonConsumerGroups() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DescribeGroupsResponseData data = new DescribeGroupsResponseData();
            data.groups().add(DescribeGroupsResponse.groupMetadata((String)"group-0", (Errors)Errors.NONE, (String)"", (String)"non-consumer", (String)"", Arrays.asList(new DescribeGroupsResponseData.DescribedGroupMember[0]), Collections.emptySet()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DescribeGroupsResponse(data));
            DescribeConsumerGroupsResult result = env.adminClient().describeConsumerGroups(Collections.singletonList("group-0"));
            TestUtils.assertFutureError((Future)result.describedGroups().get("group-0"), IllegalArgumentException.class);
        }
    }

    @Test
    public void testDescribeConsumerGroupOffsets() throws Exception {
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(Errors.COORDINATOR_NOT_AVAILABLE, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(Errors.NOT_COORDINATOR, Collections.emptyMap()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            TopicPartition myTopicPartition0 = new TopicPartition("my_topic", 0);
            TopicPartition myTopicPartition1 = new TopicPartition("my_topic", 1);
            TopicPartition myTopicPartition2 = new TopicPartition("my_topic", 2);
            TopicPartition myTopicPartition3 = new TopicPartition("my_topic", 3);
            HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responseData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
            responseData.put(myTopicPartition0, new OffsetFetchResponse.PartitionData(10L, Optional.empty(), "", Errors.NONE));
            responseData.put(myTopicPartition1, new OffsetFetchResponse.PartitionData(0L, Optional.empty(), "", Errors.NONE));
            responseData.put(myTopicPartition2, new OffsetFetchResponse.PartitionData(20L, Optional.empty(), "", Errors.NONE));
            responseData.put(myTopicPartition3, new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.NONE));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetFetchResponse(Errors.NONE, responseData));
            ListConsumerGroupOffsetsResult result = env.adminClient().listConsumerGroupOffsets("group-0");
            Map partitionToOffsetAndMetadata = (Map)result.partitionsToOffsetAndMetadata().get();
            Assert.assertEquals((long)4L, (long)partitionToOffsetAndMetadata.size());
            Assert.assertEquals((long)10L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition0)).offset());
            Assert.assertEquals((long)0L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition1)).offset());
            Assert.assertEquals((long)20L, (long)((OffsetAndMetadata)partitionToOffsetAndMetadata.get(myTopicPartition2)).offset());
            Assert.assertTrue((boolean)partitionToOffsetAndMetadata.containsKey(myTopicPartition3));
            Assert.assertNull(partitionToOffsetAndMetadata.get(myTopicPartition3));
        }
    }

    @Test
    public void testDeleteConsumerGroups() throws Exception {
        List<String> groupIds = Collections.singletonList("group-0");
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection validResponse = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            validResponse.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-0").setErrorCode(Errors.NONE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            DeleteConsumerGroupsResult result = env.adminClient().deleteConsumerGroups(groupIds);
            KafkaFuture results = (KafkaFuture)result.deletedGroups().get("group-0");
            Assert.assertNull((Object)results.get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            DeleteConsumerGroupsResult errorResult = env.adminClient().deleteConsumerGroups(groupIds);
            TestUtils.assertFutureError((Future)errorResult.deletedGroups().get("group-0"), GroupAuthorizationException.class);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            DeleteGroupsResponseData.DeletableGroupResultCollection errorResponse1 = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            errorResponse1.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-0").setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(errorResponse1)));
            DeleteGroupsResponseData.DeletableGroupResultCollection errorResponse2 = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            errorResponse2.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("group-0").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(errorResponse2)));
            DeleteGroupsResponseData.DeletableGroupResultCollection coordinatorMoved = new DeleteGroupsResponseData.DeletableGroupResultCollection();
            coordinatorMoved.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId("UnitTestError").setErrorCode(Errors.NOT_COORDINATOR.code()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(coordinatorMoved)));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(validResponse)));
            DeleteConsumerGroupsResult errorResult1 = env.adminClient().deleteConsumerGroups(groupIds);
            KafkaFuture errorResults = (KafkaFuture)errorResult1.deletedGroups().get("group-0");
            Assert.assertNull((Object)errorResults.get());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsets() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("foobar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetDeleteResponse(new OffsetDeleteResponseData().setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Stream.of(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("foo").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.NONE.code())).iterator())), new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName("bar").setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(0).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code())).iterator()))).collect(Collectors.toList()).iterator()))));
            DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1, tp2).collect(Collectors.toSet()));
            Assert.assertNull((Object)errorResult.partitionResult(tp1).get());
            TestUtils.assertFutureError(errorResult.all(), GroupSubscribedToTopicException.class);
            TestUtils.assertFutureError(errorResult.partitionResult(tp2), GroupSubscribedToTopicException.class);
            Assert.assertThrows(IllegalArgumentException.class, () -> errorResult.partitionResult(tp3));
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            DeleteConsumerGroupOffsetsResult errorResult1 = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1).collect(Collectors.toSet()));
            Assert.assertNull((Object)errorResult1.all().get());
            Assert.assertNull((Object)errorResult1.partitionResult(tp1).get());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsNonRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse(error));
                DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1).collect(Collectors.toSet()));
                TestUtils.assertFutureError(errorResult.all(), error.exception().getClass());
                TestUtils.assertFutureError(errorResult.partitionResult(tp1), error.exception().getClass());
            }
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsFindCoordinatorRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetDeleteResponse("foo", 0, Errors.NONE));
            DeleteConsumerGroupOffsetsResult result = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1).collect(Collectors.toSet()));
            Assert.assertNull((Object)result.all().get());
            Assert.assertNull((Object)result.partitionResult(tp1).get());
        }
    }

    @Test
    public void testDeleteConsumerGroupOffsetsFindCoordinatorNonRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            DeleteConsumerGroupOffsetsResult errorResult = env.adminClient().deleteConsumerGroupOffsets("group-0", Stream.of(tp1).collect(Collectors.toSet()));
            TestUtils.assertFutureError(errorResult.all(), GroupAuthorizationException.class);
            TestUtils.assertFutureError(errorResult.partitionResult(tp1), GroupAuthorizationException.class);
        }
    }

    @Test
    public void testIncrementalAlterConfigs() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            IncrementalAlterConfigsResponseData responseData = new IncrementalAlterConfigsResponseData();
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage("authorization error"));
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("topic1").setResourceType(ConfigResource.Type.TOPIC.id()).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Config value append is not allowed for config"));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData));
            ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "");
            ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "topic1");
            AlterConfigOp alterConfigOp1 = new AlterConfigOp(new ConfigEntry("log.segment.bytes", "1073741"), AlterConfigOp.OpType.SET);
            AlterConfigOp alterConfigOp2 = new AlterConfigOp(new ConfigEntry("compression.type", "gzip"), AlterConfigOp.OpType.APPEND);
            HashMap<ConfigResource, List<AlterConfigOp>> configs = new HashMap<ConfigResource, List<AlterConfigOp>>();
            configs.put(brokerResource, Collections.singletonList(alterConfigOp1));
            configs.put(topicResource, Collections.singletonList(alterConfigOp2));
            AlterConfigsResult result = env.adminClient().incrementalAlterConfigs(configs);
            TestUtils.assertFutureError((Future)result.values().get(brokerResource), ClusterAuthorizationException.class);
            TestUtils.assertFutureError((Future)result.values().get(topicResource), InvalidRequestException.class);
            responseData = new IncrementalAlterConfigsResponseData();
            responseData.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setErrorCode(Errors.NONE.code()).setErrorMessage(ApiError.NONE.message()));
            env.kafkaClient().prepareResponse((AbstractResponse)new IncrementalAlterConfigsResponse(responseData));
            env.adminClient().incrementalAlterConfigs(Collections.singletonMap(brokerResource, Collections.singletonList(alterConfigOp1))).all().get();
        }
    }

    @Test
    public void testRemoveMembersFromGroup() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            String instanceOne = "instance-1";
            String instanceTwo = "instance-2";
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse(null, true);
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code())));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code())));
            String groupId = "groupId";
            List<MemberToRemove> membersToRemove = Arrays.asList(new MemberToRemove("instance-1"), new MemberToRemove("instance-2"));
            RemoveMembersFromConsumerGroupResult unknownErrorResult = env.adminClient().removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            MemberToRemove memberOne = new MemberToRemove("instance-1");
            MemberToRemove memberTwo = new MemberToRemove("instance-2");
            TestUtils.assertFutureError(unknownErrorResult.all(), UnknownServerException.class);
            TestUtils.assertFutureError(unknownErrorResult.memberResult(memberOne), UnknownServerException.class);
            TestUtils.assertFutureError(unknownErrorResult.memberResult(memberTwo), UnknownServerException.class);
            LeaveGroupResponseData.MemberResponse responseOne = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code());
            LeaveGroupResponseData.MemberResponse responseTwo = new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-2").setErrorCode(Errors.NONE.code());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseOne, responseTwo))));
            RemoveMembersFromConsumerGroupResult memberLevelErrorResult = env.adminClient().removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureError(memberLevelErrorResult.all(), UnknownMemberIdException.class);
            TestUtils.assertFutureError(memberLevelErrorResult.memberResult(memberOne), UnknownMemberIdException.class);
            Assert.assertNull((Object)memberLevelErrorResult.memberResult(memberTwo).get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(responseTwo))));
            RemoveMembersFromConsumerGroupResult missingMemberResult = env.adminClient().removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            TestUtils.assertFutureError(missingMemberResult.all(), IllegalArgumentException.class);
            TestUtils.assertFutureError(missingMemberResult.memberResult(memberOne), IllegalArgumentException.class);
            Assert.assertNull((Object)missingMemberResult.memberResult(memberTwo).get());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()).setMembers(Arrays.asList(responseTwo, new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("instance-1").setErrorCode(Errors.NONE.code())))));
            RemoveMembersFromConsumerGroupResult noErrorResult = env.adminClient().removeMembersFromConsumerGroup(groupId, new RemoveMembersFromConsumerGroupOptions(membersToRemove));
            Assert.assertNull((Object)noErrorResult.all().get());
            Assert.assertNull((Object)noErrorResult.memberResult(memberOne).get());
            Assert.assertNull((Object)noErrorResult.memberResult(memberTwo).get());
        }
    }

    @Test
    public void testAlterPartitionReassignments() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("A", 0);
            TopicPartition tp2 = new TopicPartition("B", 0);
            HashMap reassignments = new HashMap();
            reassignments.put(tp1, Optional.empty());
            reassignments.put(tp2, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            AlterPartitionReassignmentsResponseData responseData1 = new AlterPartitionReassignmentsResponseData();
            AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse normalPartitionResponse = new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(0);
            responseData1.setResponses(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(responseData1));
            AlterPartitionReassignmentsResult result1 = env.adminClient().alterPartitionReassignments(reassignments);
            KafkaFuture future1 = result1.all();
            Future future2 = (Future)result1.values().get(tp1);
            TestUtils.assertFutureError(future1, UnknownServerException.class);
            TestUtils.assertFutureError(future2, UnknownServerException.class);
            AlterPartitionReassignmentsResponseData controllerErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage(Errors.NOT_CONTROLLER.message()).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            MetadataResponse controllerNodeResponse = MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList());
            AlterPartitionReassignmentsResponseData normalResponse = new AlterPartitionReassignmentsResponseData().setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(controllerErrResponseData));
            env.kafkaClient().prepareResponse((AbstractResponse)controllerNodeResponse);
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(normalResponse));
            AlterPartitionReassignmentsResult controllerErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            controllerErrResult.all().get();
            ((KafkaFuture)controllerErrResult.values().get(tp1)).get();
            ((KafkaFuture)controllerErrResult.values().get(tp2)).get();
            AlterPartitionReassignmentsResponseData partitionLevelErrData = new AlterPartitionReassignmentsResponseData().setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignablePartitionResponse().setPartitionIndex(0).setErrorMessage(Errors.INVALID_REPLICA_ASSIGNMENT.message()).setErrorCode(Errors.INVALID_REPLICA_ASSIGNMENT.code()))), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(partitionLevelErrData));
            AlterPartitionReassignmentsResult partitionLevelErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            TestUtils.assertFutureError((Future)partitionLevelErrResult.values().get(tp1), Errors.INVALID_REPLICA_ASSIGNMENT.exception().getClass());
            ((KafkaFuture)partitionLevelErrResult.values().get(tp2)).get();
            AlterPartitionReassignmentsResponseData topLevelErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.CLUSTER_AUTHORIZATION_FAILED.message()).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(topLevelErrResponseData));
            AlterPartitionReassignmentsResult topLevelErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            TestUtils.assertFutureError(topLevelErrResult.all(), Errors.CLUSTER_AUTHORIZATION_FAILED.exception().getClass());
            TestUtils.assertFutureError((Future)topLevelErrResult.values().get(tp1), Errors.CLUSTER_AUTHORIZATION_FAILED.exception().getClass());
            TestUtils.assertFutureError((Future)topLevelErrResult.values().get(tp2), Errors.CLUSTER_AUTHORIZATION_FAILED.exception().getClass());
            TopicPartition invalidTopicTP = new TopicPartition("", 0);
            TopicPartition invalidPartitionTP = new TopicPartition("ABC", -1);
            HashMap<TopicPartition, Optional<NewPartitionReassignment>> invalidTopicReassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
            invalidTopicReassignments.put(invalidPartitionTP, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            invalidTopicReassignments.put(invalidTopicTP, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            invalidTopicReassignments.put(tp1, Optional.of(new NewPartitionReassignment(Arrays.asList(1, 2, 3))));
            AlterPartitionReassignmentsResponseData singlePartResponseData = new AlterPartitionReassignmentsResponseData().setResponses(Collections.singletonList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(singlePartResponseData));
            AlterPartitionReassignmentsResult unrepresentableTopicResult = env.adminClient().alterPartitionReassignments(invalidTopicReassignments);
            TestUtils.assertFutureError((Future)unrepresentableTopicResult.values().get(invalidTopicTP), InvalidTopicException.class);
            TestUtils.assertFutureError((Future)unrepresentableTopicResult.values().get(invalidPartitionTP), InvalidTopicException.class);
            ((KafkaFuture)unrepresentableTopicResult.values().get(tp1)).get();
            AlterPartitionReassignmentsResponseData noErrResponseData = new AlterPartitionReassignmentsResponseData().setErrorCode(Errors.NONE.code()).setErrorMessage(Errors.NONE.message()).setResponses(Arrays.asList(new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("A").setPartitions(Collections.singletonList(normalPartitionResponse)), new AlterPartitionReassignmentsResponseData.ReassignableTopicResponse().setName("B").setPartitions(Collections.singletonList(normalPartitionResponse))));
            env.kafkaClient().prepareResponse((AbstractResponse)new AlterPartitionReassignmentsResponse(noErrResponseData));
            AlterPartitionReassignmentsResult noErrResult = env.adminClient().alterPartitionReassignments(reassignments);
            noErrResult.all().get();
            ((KafkaFuture)noErrResult.values().get(tp1)).get();
            ((KafkaFuture)noErrResult.values().get(tp2)).get();
        }
    }

    @Test
    public void testListPartitionReassignments() throws Exception {
        try (AdminClientUnitTestEnv env = KafkaAdminClientTest.mockClientEnv(new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            TopicPartition tp1 = new TopicPartition("A", 0);
            ListPartitionReassignmentsResponseData.OngoingPartitionReassignment tp1PartitionReassignment = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setRemovingReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Arrays.asList(4, 5, 6)).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6));
            ListPartitionReassignmentsResponseData.OngoingTopicReassignment tp1Reassignment = new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("A").setPartitions(Collections.singletonList(tp1PartitionReassignment));
            TopicPartition tp2 = new TopicPartition("B", 0);
            ListPartitionReassignmentsResponseData.OngoingPartitionReassignment tp2PartitionReassignment = new ListPartitionReassignmentsResponseData.OngoingPartitionReassignment().setPartitionIndex(0).setRemovingReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Arrays.asList(4, 5, 6)).setReplicas(Arrays.asList(1, 2, 3, 4, 5, 6));
            ListPartitionReassignmentsResponseData.OngoingTopicReassignment tp2Reassignment = new ListPartitionReassignmentsResponseData.OngoingTopicReassignment().setName("B").setPartitions(Collections.singletonList(tp2PartitionReassignment));
            ListPartitionReassignmentsResponseData notControllerData = new ListPartitionReassignmentsResponseData().setErrorCode(Errors.NOT_CONTROLLER.code()).setErrorMessage(Errors.NOT_CONTROLLER.message());
            MetadataResponse controllerNodeResponse = MetadataResponse.prepareResponse((Collection)env.cluster().nodes(), (String)env.cluster().clusterResource().clusterId(), (int)1, Collections.emptyList());
            ListPartitionReassignmentsResponseData reassignmentsData = new ListPartitionReassignmentsResponseData().setTopics(Arrays.asList(tp1Reassignment, tp2Reassignment));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(notControllerData));
            env.kafkaClient().prepareResponse((AbstractResponse)controllerNodeResponse);
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(reassignmentsData));
            ListPartitionReassignmentsResult noControllerResult = env.adminClient().listPartitionReassignments();
            noControllerResult.reassignments().get();
            ListPartitionReassignmentsResponseData unknownTpData = new ListPartitionReassignmentsResponseData().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message());
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(unknownTpData));
            ListPartitionReassignmentsResult unknownTpResult = env.adminClient().listPartitionReassignments(new HashSet<TopicPartition>(Arrays.asList(tp1, tp2)));
            TestUtils.assertFutureError(unknownTpResult.reassignments(), UnknownTopicOrPartitionException.class);
            ListPartitionReassignmentsResponseData responseData = new ListPartitionReassignmentsResponseData().setTopics(Arrays.asList(tp1Reassignment, tp2Reassignment));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListPartitionReassignmentsResponse(responseData));
            ListPartitionReassignmentsResult responseResult = env.adminClient().listPartitionReassignments();
            Map reassignments = (Map)responseResult.reassignments().get();
            PartitionReassignment tp1Result = (PartitionReassignment)reassignments.get(tp1);
            Assert.assertEquals(tp1PartitionReassignment.addingReplicas(), (Object)tp1Result.addingReplicas());
            Assert.assertEquals(tp1PartitionReassignment.removingReplicas(), (Object)tp1Result.removingReplicas());
            Assert.assertEquals(tp1PartitionReassignment.replicas(), (Object)tp1Result.replicas());
            Assert.assertEquals(tp1PartitionReassignment.replicas(), (Object)tp1Result.replicas());
            PartitionReassignment tp2Result = (PartitionReassignment)reassignments.get(tp2);
            Assert.assertEquals(tp2PartitionReassignment.addingReplicas(), (Object)tp2Result.addingReplicas());
            Assert.assertEquals(tp2PartitionReassignment.removingReplicas(), (Object)tp2Result.removingReplicas());
            Assert.assertEquals(tp2PartitionReassignment.replicas(), (Object)tp2Result.replicas());
            Assert.assertEquals(tp2PartitionReassignment.replicas(), (Object)tp2Result.replicas());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsets() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("foobar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            HashMap<TopicPartition, Errors> responseData = new HashMap<TopicPartition, Errors>();
            responseData.put(tp1, Errors.NONE);
            responseData.put(tp2, Errors.NONE);
            env.kafkaClient().prepareResponse((AbstractResponse)new OffsetCommitResponse(0, responseData));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            offsets.put(tp2, new OffsetAndMetadata(456L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
            Assert.assertNull((Object)result.all().get());
            Assert.assertNull((Object)result.partitionResult(tp1).get());
            Assert.assertNull((Object)result.partitionResult(tp2).get());
            TestUtils.assertFutureError(result.partitionResult(tp3), IllegalArgumentException.class);
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.COORDINATOR_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.COORDINATOR_LOAD_IN_PROGRESS));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NOT_COORDINATOR));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result1 = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
            Assert.assertNull((Object)result1.all().get());
            Assert.assertNull((Object)result1.partitionResult(tp1).get());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsNonRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        List<Errors> nonRetriableErrors = Arrays.asList(Errors.GROUP_AUTHORIZATION_FAILED, Errors.INVALID_GROUP_ID, Errors.GROUP_ID_NOT_FOUND);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            for (Errors error : nonRetriableErrors) {
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
                env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, error));
                HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
                offsets.put(tp1, new OffsetAndMetadata(123L));
                AlterConsumerGroupOffsetsResult errorResult = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
                TestUtils.assertFutureError(errorResult.all(), error.exception().getClass());
                TestUtils.assertFutureError(errorResult.partitionResult(tp1), error.exception().getClass());
            }
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsFindCoordinatorRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_NOT_AVAILABLE, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.COORDINATOR_LOAD_IN_PROGRESS, Node.noNode()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.NONE, env.cluster().controller()));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareOffsetCommitResponse(tp1, Errors.NONE));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult result = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
            Assert.assertNull((Object)result.all().get());
            Assert.assertNull((Object)result.partitionResult(tp1).get());
        }
    }

    @Test
    public void testAlterConsumerGroupOffsetsFindCoordinatorNonRetriableErrors() throws Exception {
        String groupId = "group-0";
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(KafkaAdminClientTest.mockCluster(1, 0), new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareFindCoordinatorResponse(Errors.GROUP_AUTHORIZATION_FAILED, Node.noNode()));
            HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            offsets.put(tp1, new OffsetAndMetadata(123L));
            AlterConsumerGroupOffsetsResult errorResult = env.adminClient().alterConsumerGroupOffsets("group-0", offsets);
            TestUtils.assertFutureError(errorResult.all(), GroupAuthorizationException.class);
            TestUtils.assertFutureError(errorResult.partitionResult(tp1), GroupAuthorizationException.class);
        }
    }

    @Test
    public void testListOffsets() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("bar", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("baz", 0, node0, new Node[]{node0}, new Node[]{node0}));
        Cluster cluster = new Cluster("mockClusterId", Arrays.asList(node0), pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("bar", 0);
        TopicPartition tp3 = new TopicPartition("baz", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(tp1, new ListOffsetResponse.PartitionData(Errors.NONE, -1L, 123L, Optional.of(321)));
            responseData.put(tp2, new ListOffsetResponse.PartitionData(Errors.NONE, -1L, 234L, Optional.of(432)));
            responseData.put(tp3, new ListOffsetResponse.PartitionData(Errors.NONE, 123456789L, 345L, Optional.of(543)));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetResponse(responseData));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp1, OffsetSpec.latest());
            partitions.put(tp2, OffsetSpec.earliest());
            partitions.put(tp3, OffsetSpec.forTimestamp((long)System.currentTimeMillis()));
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assert.assertFalse((boolean)offsets.isEmpty());
            Assert.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assert.assertEquals((long)321L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
            Assert.assertEquals((long)234L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).offset());
            Assert.assertEquals((long)432L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).timestamp());
            Assert.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).offset());
            Assert.assertEquals((long)543L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)123456789L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).timestamp());
            Assert.assertEquals(offsets.get(tp1), (Object)result.partitionResult(tp1).get());
            Assert.assertEquals(offsets.get(tp2), (Object)result.partitionResult(tp2).get());
            Assert.assertEquals(offsets.get(tp3), (Object)result.partitionResult(tp3).get());
            try {
                result.partitionResult(new TopicPartition("unknown", 0)).get();
                Assert.fail((String)"should have thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testListOffsetsRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("foo", 1, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        pInfos.add(new PartitionInfo("bar", 0, node1, new Node[]{node1, node0}, new Node[]{node1, node0}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp1 = new TopicPartition("foo", 0);
        TopicPartition tp2 = new TopicPartition("foo", 1);
        TopicPartition tp3 = new TopicPartition("bar", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(tp1, new ListOffsetResponse.PartitionData(Errors.LEADER_NOT_AVAILABLE, -1L, 123L, Optional.of(321)));
            responseData.put(tp3, new ListOffsetResponse.PartitionData(Errors.NONE, -1L, 987L, Optional.of(789)));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetResponse(responseData));
            responseData = new HashMap();
            responseData.put(tp2, new ListOffsetResponse.PartitionData(Errors.NONE, -1L, 456L, Optional.of(654)));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetResponse(responseData));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            responseData = new HashMap();
            responseData.put(tp1, new ListOffsetResponse.PartitionData(Errors.NONE, -1L, 345L, Optional.of(543)));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetResponse(responseData));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp1, OffsetSpec.latest());
            partitions.put(tp2, OffsetSpec.latest());
            partitions.put(tp3, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assert.assertFalse((boolean)offsets.isEmpty());
            Assert.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assert.assertEquals((long)543L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
            Assert.assertEquals((long)456L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).offset());
            Assert.assertEquals((long)654L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp2)).timestamp());
            Assert.assertEquals((long)987L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).offset());
            Assert.assertEquals((long)789L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp3)).timestamp());
        }
    }

    @Test
    public void testListOffsetsNonRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(tp1, new ListOffsetResponse.PartitionData(Errors.TOPIC_AUTHORIZATION_FAILED, -1L, -1L, Optional.empty()));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetResponse(responseData));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            TestUtils.assertFutureError(result.all(), TopicAuthorizationException.class);
        }
    }

    @Test
    public void testListOffsetsMetadataRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0}));
        pInfos.add(new PartitionInfo("foo", 1, node1, new Node[]{node1}, new Node[]{node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.LEADER_NOT_AVAILABLE));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.UNKNOWN_TOPIC_OR_PARTITION));
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(tp0, new ListOffsetResponse.PartitionData(Errors.NONE, -1L, 345L, Optional.of(543)));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetResponse(responseData));
            responseData = new HashMap();
            responseData.put(tp1, new ListOffsetResponse.PartitionData(Errors.NONE, -1L, 789L, Optional.of(987)));
            env.kafkaClient().prepareResponse((AbstractResponse)new ListOffsetResponse(responseData));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assert.assertFalse((boolean)offsets.isEmpty());
            Assert.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assert.assertEquals((long)543L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assert.assertEquals((long)789L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assert.assertEquals((long)987L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
        }
    }

    @Test
    public void testListOffsetsWithMultiplePartitionsLeaderChange() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        Node node2 = new Node(2, "localhost", 8122);
        List<Node> nodes = Arrays.asList(node0, node1, node2);
        PartitionInfo oldPInfo1 = new PartitionInfo("foo", 0, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        PartitionInfo oldPnfo2 = new PartitionInfo("foo", 1, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        List<PartitionInfo> oldPInfos = Arrays.asList(oldPInfo1, oldPnfo2);
        Cluster oldCluster = new Cluster("mockClusterId", nodes, oldPInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(oldCluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(oldCluster, Errors.NONE));
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(tp0, new ListOffsetResponse.PartitionData(Errors.NOT_LEADER_FOR_PARTITION, -1L, 345L, Optional.of(543)));
            responseData.put(tp1, new ListOffsetResponse.PartitionData(Errors.LEADER_NOT_AVAILABLE, -2L, 123L, Optional.of(456)));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node0);
            PartitionInfo newPInfo1 = new PartitionInfo("foo", 0, node1, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            PartitionInfo newPInfo2 = new PartitionInfo("foo", 1, node2, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            List<PartitionInfo> newPInfos = Arrays.asList(newPInfo1, newPInfo2);
            Cluster newCluster = new Cluster("mockClusterId", nodes, newPInfos, Collections.emptySet(), Collections.emptySet(), node0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(newCluster, Errors.NONE));
            responseData = new HashMap();
            responseData.put(tp0, new ListOffsetResponse.PartitionData(Errors.NONE, -1L, 345L, Optional.of(543)));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node1);
            responseData = new HashMap();
            responseData.put(tp1, new ListOffsetResponse.PartitionData(Errors.NONE, -2L, 123L, Optional.of(456)));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node2);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assert.assertFalse((boolean)offsets.isEmpty());
            Assert.assertEquals((long)345L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assert.assertEquals((long)543L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-1L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
            Assert.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).offset());
            Assert.assertEquals((long)456L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-2L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp1)).timestamp());
        }
    }

    @Test
    public void testListOffsetsWithLeaderChange() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        Node node2 = new Node(2, "localhost", 8122);
        List<Node> nodes = Arrays.asList(node0, node1, node2);
        PartitionInfo oldPartitionInfo = new PartitionInfo("foo", 0, node0, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
        Cluster oldCluster = new Cluster("mockClusterId", nodes, Collections.singletonList(oldPartitionInfo), Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(oldCluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(oldCluster, Errors.NONE));
            HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
            responseData.put(tp0, new ListOffsetResponse.PartitionData(Errors.NOT_LEADER_FOR_PARTITION, -1L, 345L, Optional.of(543)));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node0);
            PartitionInfo newPartitionInfo = new PartitionInfo("foo", 0, node1, new Node[]{node0, node1, node2}, new Node[]{node0, node1, node2});
            Cluster newCluster = new Cluster("mockClusterId", nodes, Collections.singletonList(newPartitionInfo), Collections.emptySet(), Collections.emptySet(), node0);
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(newCluster, Errors.NONE));
            responseData = new HashMap();
            responseData.put(tp0, new ListOffsetResponse.PartitionData(Errors.NONE, -2L, 123L, Optional.of(456)));
            env.kafkaClient().prepareResponseFrom((AbstractResponse)new ListOffsetResponse(responseData), node1);
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp0, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            Map offsets = (Map)result.all().get();
            Assert.assertFalse((boolean)offsets.isEmpty());
            Assert.assertEquals((long)123L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).offset());
            Assert.assertEquals((long)456L, (long)((Integer)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).leaderEpoch().get()).intValue());
            Assert.assertEquals((long)-2L, (long)((ListOffsetsResult.ListOffsetsResultInfo)offsets.get(tp0)).timestamp());
        }
    }

    @Test
    public void testListOffsetsMetadataNonRetriableErrors() throws Exception {
        Node node0 = new Node(0, "localhost", 8120);
        Node node1 = new Node(1, "localhost", 8121);
        List<Node> nodes = Arrays.asList(node0, node1);
        ArrayList<PartitionInfo> pInfos = new ArrayList<PartitionInfo>();
        pInfos.add(new PartitionInfo("foo", 0, node0, new Node[]{node0, node1}, new Node[]{node0, node1}));
        Cluster cluster = new Cluster("mockClusterId", nodes, pInfos, Collections.emptySet(), Collections.emptySet(), node0);
        TopicPartition tp1 = new TopicPartition("foo", 0);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv(cluster, new String[0]);){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            env.kafkaClient().prepareResponse((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.TOPIC_AUTHORIZATION_FAILED));
            HashMap<TopicPartition, OffsetSpec> partitions = new HashMap<TopicPartition, OffsetSpec>();
            partitions.put(tp1, OffsetSpec.latest());
            ListOffsetsResult result = env.adminClient().listOffsets(partitions);
            TestUtils.assertFutureError(result.all(), TopicAuthorizationException.class);
        }
    }

    @Test
    public void testGetSubLevelError() {
        List<LeaveGroupRequestData.MemberIdentity> memberIdentities = Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("instance-0"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("instance-1"));
        HashMap<LeaveGroupRequestData.MemberIdentity, Errors> errorsMap = new HashMap<LeaveGroupRequestData.MemberIdentity, Errors>();
        errorsMap.put(memberIdentities.get(0), Errors.NONE);
        errorsMap.put(memberIdentities.get(1), Errors.FENCED_INSTANCE_ID);
        Assert.assertEquals(IllegalArgumentException.class, KafkaAdminClient.getSubLevelError(errorsMap, (Object)new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("non-exist-id"), (String)"For unit test").getClass());
        Assert.assertNull((Object)KafkaAdminClient.getSubLevelError(errorsMap, (Object)memberIdentities.get(0), (String)"For unit test"));
        Assert.assertEquals(FencedInstanceIdException.class, KafkaAdminClient.getSubLevelError(errorsMap, (Object)memberIdentities.get(1), (String)"For unit test").getClass());
    }

    @Test
    public void testSuccessfulRetryAfterRequestTimeout() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Arrays.asList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int requestTimeoutMs = 1000;
        int retryBackoffMs = 100;
        int apiTimeoutMs = 3000;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(1000));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsResult result = env.adminClient().listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(3000)));
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(1001L);
            TestUtils.waitForCondition(() -> !env.kafkaClient().hasInFlightRequests(), "Timed out waiting for inFlightRequests to be timed out");
            time.sleep(100L);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Failed to retry Metadata request");
            env.kafkaClient().respond((AbstractResponse)KafkaAdminClientTest.prepareMetadataResponse(cluster, Errors.NONE));
            Assert.assertEquals((long)1L, (long)((Collection)result.listings().get()).size());
            Assert.assertEquals((Object)"foo", (Object)((TopicListing)((Collection)result.listings().get()).iterator().next()).name());
        }
    }

    @Test
    public void testDefaultApiTimeout() throws Exception {
        this.testApiTimeout(1500, 3000, OptionalInt.empty());
    }

    @Test
    public void testDefaultApiTimeoutOverride() throws Exception {
        this.testApiTimeout(1500, 10000, OptionalInt.of(3000));
    }

    private void testApiTimeout(int requestTimeoutMs, int defaultApiTimeoutMs, OptionalInt overrideApiTimeoutMs) throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Arrays.asList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int retryBackoffMs = 100;
        int effectiveTimeoutMs = overrideApiTimeoutMs.orElse(defaultApiTimeoutMs);
        Assert.assertEquals((String)"This test expects the effective timeout to be twice the request timeout", (long)(2 * requestTimeoutMs), (long)effectiveTimeoutMs);
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(requestTimeoutMs), "default.api.timeout.ms", String.valueOf(defaultApiTimeoutMs));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsOptions options = new ListTopicsOptions();
            overrideApiTimeoutMs.ifPresent(arg_0 -> ((ListTopicsOptions)options).timeoutMs(arg_0));
            ListTopicsResult result = env.adminClient().listTopics(options);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(requestTimeoutMs + 1);
            TestUtils.waitForCondition(() -> !env.kafkaClient().hasInFlightRequests(), "Timed out waiting for inFlightRequests to be timed out");
            TestUtils.waitForCondition(() -> {
                boolean hasInflightRequests = env.kafkaClient().hasInFlightRequests();
                if (!hasInflightRequests) {
                    time.sleep(100L);
                }
                return hasInflightRequests;
            }, "Timed out waiting for Metadata request to be sent");
            time.sleep(requestTimeoutMs + 1);
            TestUtils.assertFutureThrows(result.future, TimeoutException.class);
        }
    }

    @Test
    public void testRequestTimeoutExceedingDefaultApiTimeout() throws Exception {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        MockTime time = new MockTime();
        Node node0 = new Node(0, "localhost", 8121);
        nodes.put(0, node0);
        Cluster cluster = new Cluster("mockClusterId", nodes.values(), Arrays.asList(new PartitionInfo("foo", 0, node0, new Node[]{node0}, new Node[]{node0})), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
        int retryBackoffMs = 100;
        int requestTimeoutMs = 120000;
        try (AdminClientUnitTestEnv env = new AdminClientUnitTestEnv((Time)time, cluster, "retry.backoff.ms", String.valueOf(100), "request.timeout.ms", String.valueOf(120000));){
            env.kafkaClient().setNodeApiVersions(NodeApiVersions.create());
            ListTopicsOptions options = new ListTopicsOptions();
            ListTopicsResult result = env.adminClient().listTopics(options);
            TestUtils.waitForCondition(() -> env.kafkaClient().hasInFlightRequests(), "Timed out waiting for Metadata request to be sent");
            time.sleep(60001L);
            Assert.assertTrue((boolean)env.kafkaClient().hasInFlightRequests());
            time.sleep(60000L);
            TestUtils.assertFutureThrows(result.future, TimeoutException.class);
        }
    }

    private static MemberDescription convertToMemberDescriptions(DescribeGroupsResponseData.DescribedGroupMember member, MemberAssignment assignment) {
        return new MemberDescription(member.memberId(), Optional.ofNullable(member.groupInstanceId()), member.clientId(), member.clientHost(), assignment);
    }

    @SafeVarargs
    private static <T> void assertCollectionIs(Collection<T> collection, T ... elements) {
        for (T element : elements) {
            Assert.assertTrue((String)("Did not find " + element), (boolean)collection.contains(element));
        }
        Assert.assertEquals((String)"There are unexpected extra elements in the collection.", (long)elements.length, (long)collection.size());
    }

    public static KafkaAdminClient createInternal(AdminClientConfig config, KafkaAdminClient.TimeoutProcessorFactory timeoutProcessorFactory) {
        return KafkaAdminClient.createInternal((AdminClientConfig)config, (KafkaAdminClient.TimeoutProcessorFactory)timeoutProcessorFactory);
    }

    public static class FailureInjectingTimeoutProcessorFactory
    extends KafkaAdminClient.TimeoutProcessorFactory {
        private int numTries = 0;
        private int failuresInjected = 0;

        public KafkaAdminClient.TimeoutProcessor create(long now) {
            return new FailureInjectingTimeoutProcessor(now);
        }

        synchronized boolean shouldInjectFailure() {
            ++this.numTries;
            if (this.numTries == 1) {
                ++this.failuresInjected;
                return true;
            }
            return false;
        }

        public synchronized int failuresInjected() {
            return this.failuresInjected;
        }

        public final class FailureInjectingTimeoutProcessor
        extends KafkaAdminClient.TimeoutProcessor {
            public FailureInjectingTimeoutProcessor(long now) {
                super(now);
            }

            boolean callHasExpired(KafkaAdminClient.Call call) {
                if (!call.isInternal() && FailureInjectingTimeoutProcessorFactory.this.shouldInjectFailure()) {
                    log.debug("Injecting timeout for {}.", (Object)call);
                    return true;
                }
                boolean ret = super.callHasExpired(call);
                log.debug("callHasExpired({}) = {}", (Object)call, (Object)ret);
                return ret;
            }
        }
    }
}

