/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;

@InterfaceStability.Unstable
public interface KStream<K, V> {
    public KStream<K, V> filter(Predicate<? super K, ? super V> var1);

    public KStream<K, V> filterNot(Predicate<? super K, ? super V> var1);

    public <KR> KStream<KR, V> selectKey(KeyValueMapper<? super K, ? super V, ? extends KR> var1);

    public <KR, VR> KStream<KR, VR> map(KeyValueMapper<? super K, ? super V, ? extends KeyValue<? extends KR, ? extends VR>> var1);

    public <VR> KStream<K, VR> mapValues(ValueMapper<? super V, ? extends VR> var1);

    public <KR, VR> KStream<KR, VR> flatMap(KeyValueMapper<? super K, ? super V, ? extends Iterable<? extends KeyValue<? extends KR, ? extends VR>>> var1);

    public <VR> KStream<K, VR> flatMapValues(ValueMapper<? super V, ? extends Iterable<? extends VR>> var1);

    public void print();

    public void print(String var1);

    public void print(Serde<K> var1, Serde<V> var2);

    public void print(Serde<K> var1, Serde<V> var2, String var3);

    public void writeAsText(String var1);

    public void writeAsText(String var1, String var2);

    public void writeAsText(String var1, Serde<K> var2, Serde<V> var3);

    public void writeAsText(String var1, String var2, Serde<K> var3, Serde<V> var4);

    public void foreach(ForeachAction<? super K, ? super V> var1);

    public KStream<K, V>[] branch(Predicate<? super K, ? super V> ... var1);

    public KStream<K, V> through(String var1);

    public KStream<K, V> through(StreamPartitioner<? super K, ? super V> var1, String var2);

    public KStream<K, V> through(Serde<K> var1, Serde<V> var2, String var3);

    public KStream<K, V> through(Serde<K> var1, Serde<V> var2, StreamPartitioner<? super K, ? super V> var3, String var4);

    public void to(String var1);

    public void to(StreamPartitioner<? super K, ? super V> var1, String var2);

    public void to(Serde<K> var1, Serde<V> var2, String var3);

    public void to(Serde<K> var1, Serde<V> var2, StreamPartitioner<? super K, ? super V> var3, String var4);

    public <K1, V1> KStream<K1, V1> transform(TransformerSupplier<? super K, ? super V, KeyValue<K1, V1>> var1, String ... var2);

    public <VR> KStream<K, VR> transformValues(ValueTransformerSupplier<? super V, ? extends VR> var1, String ... var2);

    public void process(ProcessorSupplier<? super K, ? super V> var1, String ... var2);

    public KGroupedStream<K, V> groupByKey();

    public KGroupedStream<K, V> groupByKey(Serde<K> var1, Serde<V> var2);

    public <KR> KGroupedStream<KR, V> groupBy(KeyValueMapper<? super K, ? super V, KR> var1);

    public <KR> KGroupedStream<KR, V> groupBy(KeyValueMapper<? super K, ? super V, KR> var1, Serde<KR> var2, Serde<V> var3);

    public <VO, VR> KStream<K, VR> join(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3);

    public <VO, VR> KStream<K, VR> join(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3, Serde<K> var4, Serde<V> var5, Serde<VO> var6);

    public <VO, VR> KStream<K, VR> leftJoin(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3);

    public <VO, VR> KStream<K, VR> leftJoin(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3, Serde<K> var4, Serde<V> var5, Serde<VO> var6);

    public <VO, VR> KStream<K, VR> outerJoin(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3);

    public <VO, VR> KStream<K, VR> outerJoin(KStream<K, VO> var1, ValueJoiner<? super V, ? super VO, ? extends VR> var2, JoinWindows var3, Serde<K> var4, Serde<V> var5, Serde<VO> var6);

    public <VT, VR> KStream<K, VR> join(KTable<K, VT> var1, ValueJoiner<? super V, ? super VT, ? extends VR> var2);

    public <VT, VR> KStream<K, VR> join(KTable<K, VT> var1, ValueJoiner<? super V, ? super VT, ? extends VR> var2, Serde<K> var3, Serde<V> var4);

    public <VT, VR> KStream<K, VR> leftJoin(KTable<K, VT> var1, ValueJoiner<? super V, ? super VT, ? extends VR> var2);

    public <VT, VR> KStream<K, VR> leftJoin(KTable<K, VT> var1, ValueJoiner<? super V, ? super VT, ? extends VR> var2, Serde<K> var3, Serde<V> var4);

    public <GK, GV, RV> KStream<K, RV> join(GlobalKTable<GK, GV> var1, KeyValueMapper<? super K, ? super V, ? extends GK> var2, ValueJoiner<? super V, ? super GV, ? extends RV> var3);

    public <GK, GV, RV> KStream<K, RV> leftJoin(GlobalKTable<GK, GV> var1, KeyValueMapper<? super K, ? super V, ? extends GK> var2, ValueJoiner<? super V, ? super GV, ? extends RV> var3);
}

