/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;

class RocksDBSessionStore<K, AGG>
implements SessionStore<K, AGG> {
    private final Serde<K> keySerde;
    private final Serde<AGG> aggSerde;
    private final SegmentedBytesStore bytesStore;
    private StateSerdes<K, AGG> serdes;
    protected String topic;

    RocksDBSessionStore(SegmentedBytesStore bytesStore, Serde<K> keySerde, Serde<AGG> aggSerde) {
        this.keySerde = keySerde;
        this.bytesStore = bytesStore;
        this.aggSerde = aggSerde;
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = this.bytesStore.fetch(Bytes.wrap((byte[])this.serdes.rawKey(key)), earliestSessionEndTime, latestSessionStartTime);
        return new SessionStoreIterator<K, AGG>(bytesIterator, this.serdes);
    }

    @Override
    public void remove(Windowed<K> key) {
        this.bytesStore.remove(SessionKeySerde.toBinary(key, this.serdes.keySerializer(), this.topic));
    }

    @Override
    public void put(Windowed<K> sessionKey, AGG aggregate) {
        this.bytesStore.put(SessionKeySerde.toBinary(sessionKey, this.serdes.keySerializer(), this.topic), this.aggSerde.serializer().serialize(this.bytesStore.name(), aggregate));
    }

    @Override
    public String name() {
        return this.bytesStore.name();
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        String storeName = this.bytesStore.name();
        this.topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), storeName);
        this.serdes = new StateSerdes(this.topic, (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.aggSerde == null ? context.valueSerde() : this.aggSerde));
        this.bytesStore.init(context, root);
    }

    @Override
    public void flush() {
        this.bytesStore.flush();
    }

    @Override
    public void close() {
        this.bytesStore.close();
    }

    @Override
    public boolean persistent() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.bytesStore.isOpen();
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> fetch(K key) {
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    private static class SessionStoreIterator<K, AGG>
    implements KeyValueIterator<Windowed<K>, AGG> {
        private final KeyValueIterator<Bytes, byte[]> bytesIterator;
        private final StateSerdes<K, AGG> serdes;

        SessionStoreIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, StateSerdes<K, AGG> serdes) {
            this.bytesIterator = bytesIterator;
            this.serdes = serdes;
        }

        @Override
        public void close() {
            this.bytesIterator.close();
        }

        @Override
        public Windowed<K> peekNextKey() {
            Bytes bytes = this.bytesIterator.peekNextKey();
            return SessionKeySerde.from(bytes.get(), this.serdes.keyDeserializer(), this.serdes.topic());
        }

        @Override
        public boolean hasNext() {
            return this.bytesIterator.hasNext();
        }

        @Override
        public KeyValue<Windowed<K>, AGG> next() {
            KeyValue next = (KeyValue)this.bytesIterator.next();
            return KeyValue.pair(SessionKeySerde.from(((Bytes)next.key).get(), this.serdes.keyDeserializer(), this.serdes.topic()), this.serdes.valueFrom((byte[])next.value));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported by SessionStoreIterator");
        }
    }
}

